/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.RefLikeType;
import soot.Singletons;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.tagkit.ColorTag;
import soot.tagkit.KeyTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class NullPointerColorer
extends BodyTransformer {
    public NullPointerColorer(Singletons.Global g) {
    }

    public static NullPointerColorer v() {
        return G.v().soot_jimple_toolkits_annotation_nullcheck_NullPointerColorer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        BranchedRefVarsAnalysis analysis = new BranchedRefVarsAnalysis(new ExceptionalUnitGraph(b));
        for (Stmt stmt : b.getUnits()) {
            Iterator<ValueBox> usesIt = stmt.getUseBoxes().iterator();
            FlowSet beforeSet = (FlowSet)analysis.getFlowBefore(stmt);
            while (usesIt.hasNext()) {
                ValueBox vBox = usesIt.next();
                this.addColorTags(vBox, beforeSet, stmt, analysis);
            }
            Iterator<ValueBox> defsIt = stmt.getDefBoxes().iterator();
            FlowSet afterSet = (FlowSet)analysis.getFallFlowAfter(stmt);
            while (defsIt.hasNext()) {
                ValueBox vBox = defsIt.next();
                this.addColorTags(vBox, afterSet, stmt, analysis);
            }
        }
        Iterator<Tag> iterator2 = b.getMethod().getDeclaringClass().getTags().iterator();
        boolean keysAdded = false;
        while (iterator2.hasNext()) {
            Tag next2 = iterator2.next();
            if (!(next2 instanceof KeyTag) || !((KeyTag)next2).analysisType().equals("NullCheckTag")) continue;
            keysAdded = true;
        }
        if (!keysAdded) {
            b.getMethod().getDeclaringClass().addTag(new KeyTag(0, "Nullness: Null", "NullCheckTag"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(1, "Nullness: Not Null", "NullCheckTag"));
            b.getMethod().getDeclaringClass().addTag(new KeyTag(3, "Nullness: Nullness Unknown", "NullCheckTag"));
        }
    }

    private void addColorTags(ValueBox vBox, FlowSet set2, Stmt s2, BranchedRefVarsAnalysis analysis) {
        Value val = vBox.getValue();
        if (val.getType() instanceof RefLikeType) {
            int vInfo = analysis.anyRefInfo(val, set2);
            switch (vInfo) {
                case 1: {
                    s2.addTag(new StringTag(val + ": Null", "NullCheckTag"));
                    vBox.addTag(new ColorTag(0, "NullCheckTag"));
                    break;
                }
                case 2: {
                    s2.addTag(new StringTag(val + ": NonNull", "NullCheckTag"));
                    vBox.addTag(new ColorTag(1, "NullCheckTag"));
                    break;
                }
                case 99: {
                    s2.addTag(new StringTag(val + ": Nullness Unknown", "NullCheckTag"));
                    vBox.addTag(new ColorTag(3, "NullCheckTag"));
                    break;
                }
                case 0: {
                    s2.addTag(new StringTag(val + ": Nullness Unknown", "NullCheckTag"));
                    vBox.addTag(new ColorTag(3, "NullCheckTag"));
                }
            }
        }
    }
}

