/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.List;
import soot.toolkits.graph.HashMutableDirectedGraph;

class ExtendedHashMutableDirectedGraph
extends HashMutableDirectedGraph {
    @Override
    public void addEdge(Object from2, Object to2) {
        if (!super.containsNode(from2)) {
            super.addNode(from2);
        }
        if (!super.containsNode(to2)) {
            super.addNode(to2);
        }
        super.addEdge(from2, to2);
    }

    public void addMutualEdge(Object from2, Object to2) {
        if (!super.containsNode(from2)) {
            super.addNode(from2);
        }
        if (!super.containsNode(to2)) {
            super.addNode(to2);
        }
        super.addEdge(from2, to2);
        super.addEdge(to2, from2);
    }

    public void skipNode(Object node) {
        if (!super.containsNode(node)) {
            return;
        }
        Object[] preds = this.getPredsOf(node).toArray();
        Object[] succs = this.getSuccsOf(node).toArray();
        for (Object element2 : preds) {
            for (Object element0 : succs) {
                if (element2 == element0) continue;
                super.addEdge(element2, element0);
            }
        }
        for (Object element2 : preds) {
            super.removeEdge(element2, node);
        }
        for (Object element2 : succs) {
            super.removeEdge(node, element2);
        }
        super.removeNode(node);
    }

    public void mergeWith(ExtendedHashMutableDirectedGraph other) {
        List nodes = other.getNodes();
        for (Object node : nodes) {
            List succs = other.getSuccsOf(node);
            for (Object succ : succs) {
                this.addEdge(node, succ);
            }
        }
    }

    public String toString() {
        String rtn = "Graph:\n";
        List nodes = super.getNodes();
        for (Object node : nodes) {
            List succs = super.getSuccsOf(node);
            for (Object succ : succs) {
                rtn = rtn + node + "\t --- \t" + succ + "\n";
            }
        }
        return rtn;
    }
}

