/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public final class PropIter
extends Propagator {
    protected PAG pag;

    public PropIter(PAG pag) {
        this.pag = pag;
    }

    @Override
    public final void propagate() {
        boolean change;
        OnFlyCallGraph ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        int iteration = 1;
        do {
            change = false;
            TreeSet<VarNode> simpleSources = new TreeSet<VarNode>(this.pag.simpleSources());
            if (this.pag.getOpts().verbose()) {
                G.v().out.println("Iteration " + iteration++);
            }
            for (VarNode varNode : simpleSources) {
                change = this.handleSimples(varNode) | change;
            }
            if (ofcg != null) {
                QueueReader<Node> addedEdges = this.pag.edgeReader();
                for (VarNode src : this.pag.getVarNodeNumberer()) {
                    ofcg.updatedNode(src);
                }
                ofcg.build();
                while (addedEdges.hasNext()) {
                    Node node = addedEdges.next();
                    Node addedTgt = addedEdges.next();
                    change = true;
                    if (node instanceof VarNode) {
                        PointsToSetInternal p2set = ((VarNode)node).getP2Set();
                        if (p2set == null) continue;
                        p2set.unFlushNew();
                        continue;
                    }
                    if (!(node instanceof AllocNode)) continue;
                    ((VarNode)addedTgt).makeP2Set().add(node);
                }
                if (change) {
                    new TopoSorter(this.pag, false).sort();
                }
            }
            for (ValNode valNode : this.pag.loadSources()) {
                change = this.handleLoads((FieldRefNode)valNode) | change;
            }
            for (ValNode valNode : this.pag.storeSources()) {
                change = this.handleStores((VarNode)valNode) | change;
            }
        } while (change);
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element2 : targets = this.pag.allocLookup(src)) {
            ret = element2.makeP2Set().add(src) | ret;
        }
        return ret;
    }

    protected final boolean handleSimples(VarNode src) {
        Node[] simpleTargets;
        boolean ret = false;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        for (Node element2 : simpleTargets = this.pag.simpleLookup(src)) {
            ret = element2.makeP2Set().addAll(srcSet, null) | ret;
        }
        return ret;
    }

    protected final boolean handleStores(VarNode src) {
        Node[] storeTargets;
        boolean ret = false;
        final PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return false;
        }
        for (Node element2 : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element2;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropIter.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(srcSet, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
        }
        return ret;
    }

    protected final boolean handleLoads(FieldRefNode src) {
        boolean ret = false;
        final Node[] loadTargets = this.pag.loadLookup(src);
        final SparkField f = src.getField();
        ret = src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF == null) {
                    return;
                }
                PointsToSetInternal set2 = nDotF.getP2Set();
                if (set2.isEmpty()) {
                    return;
                }
                for (Node element2 : loadTargets) {
                    VarNode target = (VarNode)element2;
                    if (!target.makeP2Set().addAll(set2, null)) continue;
                    this.returnValue = true;
                }
            }
        }) | ret;
        return ret;
    }
}

