/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import soot.FastHierarchy;
import soot.G;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class MergeChecker {
    protected PAG pag;
    protected MultiMap<SparkField, VarNode> fieldToBase = new HashMultiMap<SparkField, VarNode>();

    public MergeChecker(PAG pag) {
        this.pag = pag;
    }

    public void check() {
        FieldRefNode fr;
        for (AllocNode allocNode : this.pag.allocSources()) {
            this.handleAllocNode(allocNode);
        }
        for (Node node : this.pag.simpleSources()) {
            this.handleSimples((VarNode)node);
        }
        for (Node node : this.pag.loadSources()) {
            this.handleLoads((FieldRefNode)node);
        }
        for (Node node : this.pag.storeSources()) {
            this.handleStores((VarNode)node);
        }
        for (Node node : this.pag.loadSources()) {
            fr = (FieldRefNode)node;
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        for (Node node : this.pag.storeInvSources()) {
            fr = (FieldRefNode)node;
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        for (VarNode varNode : this.pag.getVarNodeNumberer()) {
            for (FieldRefNode fr2 : varNode.getAllFieldRefs()) {
                for (VarNode dst : this.fieldToBase.get(fr2.getField())) {
                    FieldRefNode fr22;
                    if (!varNode.getP2Set().hasNonEmptyIntersection(dst.getP2Set()) || (fr22 = dst.dot(fr2.getField())).getReplacement() == fr2.getReplacement()) continue;
                    G.v().out.println("Check failure: " + fr2 + " should be merged with " + fr22);
                }
            }
        }
    }

    protected void checkAll(final Node container2, PointsToSetInternal nodes, final Node upstream) {
        nodes.forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                MergeChecker.this.checkNode(container2, n, upstream);
            }
        });
    }

    protected void checkNode(Node container2, Node n, Node upstream) {
        if (container2.getReplacement() != container2) {
            throw new RuntimeException("container " + container2 + " is illegal");
        }
        if (upstream.getReplacement() != upstream) {
            throw new RuntimeException("upstream " + upstream + " is illegal");
        }
        PointsToSetInternal p2set = container2.getP2Set();
        FastHierarchy fh = this.pag.getTypeManager().getFastHierarchy();
        if (!p2set.contains(n) && (fh == null || container2.getType() == null || fh.canStoreType(n.getType(), container2.getType()))) {
            G.v().out.println("Check failure: " + container2 + " does not have " + n + "; upstream is " + upstream);
        }
    }

    protected void handleAllocNode(AllocNode src) {
        Node[] targets;
        for (Node element2 : targets = this.pag.allocLookup(src)) {
            this.checkNode(element2, src, src);
        }
    }

    protected void handleSimples(VarNode src) {
        Node[] simpleTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        for (Node element2 : simpleTargets = this.pag.simpleLookup(src)) {
            this.checkAll(element2, srcSet, src);
        }
    }

    protected void handleStores(VarNode src) {
        Node[] storeTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        for (Node element2 : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element2;
            this.checkAll(fr, srcSet, src);
        }
    }

    protected void handleLoads(FieldRefNode src) {
        Node[] loadTargets = this.pag.loadLookup(src);
        PointsToSetInternal set2 = src.getP2Set();
        if (set2.isEmpty()) {
            return;
        }
        for (Node element2 : loadTargets) {
            VarNode target = (VarNode)element2;
            this.checkAll(target, set2, src);
        }
    }
}

