/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Context;
import soot.FastHierarchy;
import soot.G;
import soot.Kind;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.GlobalNodeFactory;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.BitPointsToSet;
import soot.jimple.spark.sets.DoublePointsToSet;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.HybridPointsToSet;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.sets.SharedHybridSet;
import soot.jimple.spark.sets.SharedListSet;
import soot.jimple.spark.sets.SortedArraySet;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.pointer.util.NativeMethodDriver;
import soot.options.SparkOptions;
import soot.tagkit.LinkTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.scalar.Pair;
import soot.util.ArrayNumberer;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class PAG
implements PointsToAnalysis {
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    protected P2SetFactory setFactory;
    protected boolean somethingMerged = false;
    ChunkedQueue<AllocNode> newAllocNodes = new ChunkedQueue();
    protected ChunkedQueue<Node> edgeQueue = new ChunkedQueue();
    private final ArrayNumberer<AllocNode> allocNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<VarNode> varNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<FieldRefNode> fieldRefNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer<AllocDotField> allocDotFieldNodeNumberer = new ArrayNumberer();
    protected SparkOptions opts;
    protected Map<VarNode, Object> simple = new HashMap<VarNode, Object>();
    protected Map<FieldRefNode, Object> load = new HashMap<FieldRefNode, Object>();
    protected Map<VarNode, Object> store = new HashMap<VarNode, Object>();
    protected Map<AllocNode, Object> alloc = new HashMap<AllocNode, Object>();
    protected Map<VarNode, Object> simpleInv = new HashMap<VarNode, Object>();
    protected Map<VarNode, Object> loadInv = new HashMap<VarNode, Object>();
    protected Map<FieldRefNode, Object> storeInv = new HashMap<FieldRefNode, Object>();
    protected Map<VarNode, Object> allocInv = new HashMap<VarNode, Object>();
    private boolean runGeomPTA = false;
    protected Map<Pair, Set<Edge>> assign2edges = new HashMap<Pair, Set<Edge>>();
    private final Map<Object, LocalVarNode> valToLocalVarNode = new HashMap<Object, LocalVarNode>(1000);
    private final Map<Object, GlobalVarNode> valToGlobalVarNode = new HashMap<Object, GlobalVarNode>(1000);
    private final Map<Object, AllocNode> valToAllocNode = new HashMap<Object, AllocNode>(1000);
    private OnFlyCallGraph ofcg;
    private final ArrayList<VarNode> dereferences = new ArrayList();
    protected TypeManager typeManager;
    private final LargeNumberedMap<Local, LocalVarNode> localToNodeMap = new LargeNumberedMap(Scene.v().getLocalNumberer());
    public int maxFinishNumber = 0;
    private Map<Node, Tag> nodeToTag;
    private final GlobalNodeFactory nodeFactory = new GlobalNodeFactory(this);
    public NativeMethodDriver nativeMethodDriver;
    public HashMultiMap<InvokeExpr, Pair<Node, Node>> callAssigns = new HashMultiMap();
    public Map<InvokeExpr, SootMethod> callToMethod = new HashMap<InvokeExpr, SootMethod>();
    public Map<InvokeExpr, Node> virtualCallsToReceivers = new HashMap<InvokeExpr, Node>();

    public PAG(SparkOptions opts) {
        this.opts = opts;
        if (opts.add_tags()) {
            this.nodeToTag = new HashMap<Node, Tag>();
        }
        if (opts.rta() && opts.on_fly_cg()) {
            throw new RuntimeException("Incompatible options rta:true and on-fly-cg:true for cg.spark. Use -p cg-.spark on-fly-cg:false when using RTA.");
        }
        this.typeManager = new TypeManager(this);
        if (!opts.ignore_types()) {
            this.typeManager.setFastHierarchy(Scene.v().getOrMakeFastHierarchy());
        }
        switch (opts.set_impl()) {
            case 1: {
                this.setFactory = HashPointsToSet.getFactory();
                break;
            }
            case 3: {
                this.setFactory = HybridPointsToSet.getFactory();
                break;
            }
            case 5: {
                this.setFactory = SharedHybridSet.getFactory();
                break;
            }
            case 6: {
                this.setFactory = SharedListSet.getFactory();
                break;
            }
            case 4: {
                this.setFactory = SortedArraySet.getFactory();
                break;
            }
            case 2: {
                this.setFactory = BitPointsToSet.getFactory();
                break;
            }
            case 7: {
                P2SetFactory newF;
                P2SetFactory oldF;
                switch (opts.double_set_old()) {
                    case 1: {
                        oldF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        oldF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        oldF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        oldF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        oldF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        oldF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                switch (opts.double_set_new()) {
                    case 1: {
                        newF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        newF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        newF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        newF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        newF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        newF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.setFactory = DoublePointsToSet.getFactory(newF, oldF);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.runGeomPTA = opts.geom_pta();
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        LocalVarNode n = this.findLocalVarNode(l);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        ContextVarNode n = this.findContextVarNode(l, c);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode n = this.findGlobalVarNode(f);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s2, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s2, f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s2) {
        return this.reachingObjectsInternal(s2, ArrayElement.v());
    }

    private PointsToSet reachingObjectsInternal(PointsToSet s2, final SparkField f) {
        if (this.getOpts().field_based() || this.getOpts().vta()) {
            GlobalVarNode n = this.findGlobalVarNode(f);
            if (n == null) {
                return EmptyPointsToSet.v();
            }
            return n.getP2Set();
        }
        if (this.getOpts().propagator() == 5) {
            throw new RuntimeException("The alias edge propagator does not compute points-to information for instance fields! Use a different propagator.");
        }
        PointsToSetInternal bases = (PointsToSetInternal)s2;
        final PointsToSetInternal ret = this.setFactory.newSet(f instanceof SootField ? ((SootField)f).getType() : null, this);
        bases.forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF != null) {
                    ret.addAll(nDotF.getP2Set(), null);
                }
            }
        });
        return ret;
    }

    public P2SetFactory getSetFactory() {
        return this.setFactory;
    }

    private <K extends Node> void lookupInMap(Map<K, Object> map2) {
        for (Node object : map2.keySet()) {
            this.lookup(map2, object);
        }
    }

    public void cleanUpMerges() {
        if (this.opts.verbose()) {
            G.v().out.println("Cleaning up graph for merged nodes");
        }
        this.lookupInMap(this.simple);
        this.lookupInMap(this.alloc);
        this.lookupInMap(this.store);
        this.lookupInMap(this.load);
        this.lookupInMap(this.simpleInv);
        this.lookupInMap(this.allocInv);
        this.lookupInMap(this.storeInv);
        this.lookupInMap(this.loadInv);
        this.somethingMerged = false;
        if (this.opts.verbose()) {
            G.v().out.println("Done cleaning up graph for merged nodes");
        }
    }

    public boolean doAddSimpleEdge(VarNode from2, VarNode to2) {
        return this.addToMap(this.simple, from2, to2) | this.addToMap(this.simpleInv, to2, from2);
    }

    public boolean doAddStoreEdge(VarNode from2, FieldRefNode to2) {
        return this.addToMap(this.store, from2, to2) | this.addToMap(this.storeInv, to2, from2);
    }

    public boolean doAddLoadEdge(FieldRefNode from2, VarNode to2) {
        return this.addToMap(this.load, from2, to2) | this.addToMap(this.loadInv, to2, from2);
    }

    public boolean doAddAllocEdge(AllocNode from2, VarNode to2) {
        return this.addToMap(this.alloc, from2, to2) | this.addToMap(this.allocInv, to2, from2);
    }

    void mergedWith(Node n1, Node n2) {
        Map[] maps;
        if (n1.equals(n2)) {
            throw new RuntimeException("oops");
        }
        this.somethingMerged = true;
        if (this.ofcg() != null) {
            this.ofcg().mergedWith(n1, n2);
        }
        for (Map m : maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv}) {
            if (!m.keySet().contains(n2)) continue;
            Object[] os = new Object[]{m.get(n1), m.get(n2)};
            int size1 = PAG.getSize(os[0]);
            int size2 = PAG.getSize(os[1]);
            if (size1 == 0) {
                if (os[1] != null) {
                    m.put(n1, os[1]);
                }
            } else if (size2 != 0) {
                Node[] ar;
                if (os[0] instanceof HashSet) {
                    if (os[1] instanceof HashSet) {
                        ((HashSet)os[0]).addAll((HashSet)os[1]);
                    } else {
                        ar = (Node[])os[1];
                        for (Node node : ar) {
                            ((HashSet)os[0]).add(node);
                        }
                    }
                } else if (os[1] instanceof HashSet) {
                    ar = (Node[])os[0];
                    for (Node node : ar) {
                        ((HashSet)os[1]).add(node);
                    }
                    m.put(n1, os[1]);
                } else if (size1 * size2 < 1000) {
                    Node[] a1 = (Node[])os[0];
                    Node[] a2 = (Node[])os[1];
                    Node[] ret = new Node[size1 + size2];
                    System.arraycopy(a1, 0, ret, 0, a1.length);
                    int j = a1.length;
                    block3: for (Node rep : a2) {
                        for (int k = 0; k < j; ++k) {
                            if (rep == ret[k]) continue block3;
                        }
                        ret[j++] = rep;
                    }
                    Node[] nodeArray = new Node[j];
                    System.arraycopy(ret, 0, nodeArray, 0, j);
                    ret = nodeArray;
                    m.put(n1, nodeArray);
                } else {
                    HashSet<Node> s2 = new HashSet<Node>(size1 + size2);
                    for (Object object : os) {
                        Node[] ar2;
                        if (object == null) continue;
                        if (object instanceof Set) {
                            s2.addAll((Set)object);
                            continue;
                        }
                        for (Node element1 : ar2 = (Node[])object) {
                            s2.add(element1);
                        }
                    }
                    m.put(n1, s2);
                }
            }
            m.remove(n2);
        }
    }

    protected <K extends Node> Node[] lookup(Map<K, Object> m, K key2) {
        Node[] valueList = m.get(key2);
        if (valueList == null) {
            return EMPTY_NODE_ARRAY;
        }
        if (valueList instanceof Set) {
            try {
                valueList = ((Set)valueList).toArray(EMPTY_NODE_ARRAY);
                m.put(key2, valueList);
            }
            catch (Exception e) {
                Iterator it = ((Set)valueList).iterator();
                while (it.hasNext()) {
                    G.v().out.println("" + it.next());
                }
                throw new RuntimeException("" + valueList + e);
            }
        }
        Node[] ret = valueList;
        if (this.somethingMerged) {
            for (int i = 0; i < ret.length; ++i) {
                int j;
                Node reti = ret[i];
                Node rep = reti.getReplacement();
                if (rep == reti && rep != key2) continue;
                if (ret.length <= 75) {
                    int j2 = i;
                    while (i < ret.length) {
                        block14: {
                            reti = ret[i];
                            rep = reti.getReplacement();
                            if (rep != key2) {
                                for (int k = 0; k < j2; ++k) {
                                    if (rep != ret[k]) {
                                        continue;
                                    }
                                    break block14;
                                }
                                ret[j2++] = rep;
                            }
                        }
                        ++i;
                    }
                    Node[] newArray = new Node[j2];
                    System.arraycopy(ret, 0, newArray, 0, j2);
                    ret = newArray;
                    m.put(key2, newArray);
                    break;
                }
                HashSet<Node> s2 = new HashSet<Node>(ret.length * 2);
                for (j = 0; j < i; ++j) {
                    s2.add(ret[j]);
                }
                for (j = i; j < ret.length; ++j) {
                    rep = ret[j].getReplacement();
                    if (rep == key2) continue;
                    s2.add(rep);
                }
                ret = s2.toArray(EMPTY_NODE_ARRAY);
                m.put(key2, ret);
                break;
            }
        }
        return ret;
    }

    public Node[] simpleLookup(VarNode key2) {
        return this.lookup(this.simple, key2);
    }

    public Node[] simpleInvLookup(VarNode key2) {
        return this.lookup(this.simpleInv, key2);
    }

    public Node[] loadLookup(FieldRefNode key2) {
        return this.lookup(this.load, key2);
    }

    public Node[] loadInvLookup(VarNode key2) {
        return this.lookup(this.loadInv, key2);
    }

    public Node[] storeLookup(VarNode key2) {
        return this.lookup(this.store, key2);
    }

    public Node[] storeInvLookup(FieldRefNode key2) {
        return this.lookup(this.storeInv, key2);
    }

    public Node[] allocLookup(AllocNode key2) {
        return this.lookup(this.alloc, key2);
    }

    public Node[] allocInvLookup(VarNode key2) {
        return this.lookup(this.allocInv, key2);
    }

    public Set<VarNode> simpleSources() {
        return this.simple.keySet();
    }

    public Set<AllocNode> allocSources() {
        return this.alloc.keySet();
    }

    public Set<VarNode> storeSources() {
        return this.store.keySet();
    }

    public Set<FieldRefNode> loadSources() {
        return this.load.keySet();
    }

    public Set<VarNode> simpleInvSources() {
        return this.simpleInv.keySet();
    }

    public Set<VarNode> allocInvSources() {
        return this.allocInv.keySet();
    }

    public Set<FieldRefNode> storeInvSources() {
        return this.storeInv.keySet();
    }

    public Set<VarNode> loadInvSources() {
        return this.loadInv.keySet();
    }

    public Iterator<VarNode> simpleSourcesIterator() {
        return this.simple.keySet().iterator();
    }

    public Iterator<AllocNode> allocSourcesIterator() {
        return this.alloc.keySet().iterator();
    }

    public Iterator<VarNode> storeSourcesIterator() {
        return this.store.keySet().iterator();
    }

    public Iterator<FieldRefNode> loadSourcesIterator() {
        return this.load.keySet().iterator();
    }

    public Iterator<VarNode> simpleInvSourcesIterator() {
        return this.simpleInv.keySet().iterator();
    }

    public Iterator<VarNode> allocInvSourcesIterator() {
        return this.allocInv.keySet().iterator();
    }

    public Iterator<FieldRefNode> storeInvSourcesIterator() {
        return this.storeInv.keySet().iterator();
    }

    public Iterator<VarNode> loadInvSourcesIterator() {
        return this.loadInv.keySet().iterator();
    }

    private static int getSize(Object set2) {
        if (set2 instanceof Set) {
            return ((Set)set2).size();
        }
        if (set2 == null) {
            return 0;
        }
        return ((Object[])set2).length;
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    private void addNodeTag(Node node, SootMethod m) {
        if (this.nodeToTag != null) {
            StringTag tag = m == null ? new StringTag(node.toString()) : new LinkTag(node.toString(), m, m.getDeclaringClass().getName());
            this.nodeToTag.put(node, tag);
        }
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m) {
        AllocNode ret;
        if (this.opts.types_for_sites() || this.opts.vta()) {
            newExpr = type;
        }
        if ((ret = this.valToAllocNode.get(newExpr)) == null) {
            ret = new AllocNode(this, newExpr, type, m);
            this.valToAllocNode.put(newExpr, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, m);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(String s2) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.String"), RefType.v("java.lang.String"), null);
        }
        StringConstantNode ret = (StringConstantNode)this.valToAllocNode.get(s2);
        if (ret == null) {
            ret = new StringConstantNode(this, s2);
            this.valToAllocNode.put(s2, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(ClassConstant cc) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.Class"), RefType.v("java.lang.Class"), null);
        }
        ClassConstantNode ret = (ClassConstantNode)this.valToAllocNode.get(cc);
        if (ret == null) {
            ret = new ClassConstantNode(this, cc);
            this.valToAllocNode.put(cc, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public QueueReader<AllocNode> allocNodeListener() {
        return this.newAllocNodes.reader();
    }

    public GlobalVarNode findGlobalVarNode(Object value2) {
        if (this.opts.rta()) {
            value2 = null;
        }
        return this.valToGlobalVarNode.get(value2);
    }

    public LocalVarNode findLocalVarNode(Object value2) {
        if (this.opts.rta()) {
            value2 = null;
        } else if (value2 instanceof Local) {
            return this.localToNodeMap.get((Local)value2);
        }
        return this.valToLocalVarNode.get(value2);
    }

    public GlobalVarNode makeGlobalVarNode(Object value2, Type type) {
        GlobalVarNode ret;
        if (this.opts.rta()) {
            value2 = null;
            type = RefType.v("java.lang.Object");
        }
        if ((ret = this.valToGlobalVarNode.get(value2)) == null) {
            ret = new GlobalVarNode(this, value2, type);
            this.valToGlobalVarNode.put(value2, ret);
            this.addNodeTag(ret, null);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value2 + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value2, Type type, SootMethod method) {
        if (this.opts.rta()) {
            value2 = null;
            type = RefType.v("java.lang.Object");
            method = null;
        } else if (value2 instanceof Local) {
            LocalVarNode ret;
            Local val = (Local)value2;
            if (val.getNumber() == 0) {
                Scene.v().getLocalNumberer().add(val);
            }
            if ((ret = this.localToNodeMap.get(val)) == null) {
                ret = new LocalVarNode(this, value2, type, method);
                this.localToNodeMap.put((Local)value2, ret);
                this.addNodeTag(ret, method);
            } else if (!ret.getType().equals(type)) {
                throw new RuntimeException("Value " + value2 + " of type " + type + " previously had type " + ret.getType());
            }
            return ret;
        }
        LocalVarNode ret = this.valToLocalVarNode.get(value2);
        if (ret == null) {
            ret = new LocalVarNode(this, value2, type, method);
            this.valToLocalVarNode.put(value2, ret);
            this.addNodeTag(ret, method);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value2 + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public ContextVarNode findContextVarNode(Object baseValue, Context context) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.context(context);
    }

    public ContextVarNode makeContextVarNode(Object baseValue, Type baseType, Context context, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeContextVarNode(base, context);
    }

    public ContextVarNode makeContextVarNode(LocalVarNode base, Context context) {
        ContextVarNode ret = base.context(context);
        if (ret == null) {
            ret = new ContextVarNode(this, base, context);
            this.addNodeTag(ret, base.getMethod());
        }
        return ret;
    }

    public FieldRefNode findLocalFieldRefNode(Object baseValue, SparkField field2) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field2);
    }

    public FieldRefNode findGlobalFieldRefNode(Object baseValue, SparkField field2) {
        GlobalVarNode base = this.findGlobalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field2);
    }

    public FieldRefNode makeLocalFieldRefNode(Object baseValue, Type baseType, SparkField field2, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeFieldRefNode(base, field2);
    }

    public FieldRefNode makeGlobalFieldRefNode(Object baseValue, Type baseType, SparkField field2) {
        GlobalVarNode base = this.makeGlobalVarNode(baseValue, baseType);
        return this.makeFieldRefNode(base, field2);
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field2) {
        FieldRefNode ret = base.dot(field2);
        if (ret == null) {
            ret = new FieldRefNode(this, base, field2);
            if (base instanceof LocalVarNode) {
                this.addNodeTag(ret, ((LocalVarNode)base).getMethod());
            } else {
                this.addNodeTag(ret, null);
            }
        }
        return ret;
    }

    public AllocDotField findAllocDotField(AllocNode an2, SparkField field2) {
        return an2.dot(field2);
    }

    public AllocDotField makeAllocDotField(AllocNode an2, SparkField field2) {
        AllocDotField ret = an2.dot(field2);
        if (ret == null) {
            ret = new AllocDotField(this, an2, field2);
        }
        return ret;
    }

    public boolean addSimpleEdge(VarNode from2, VarNode to2) {
        boolean ret = false;
        if (this.doAddSimpleEdge(from2, to2)) {
            this.edgeQueue.add(from2);
            this.edgeQueue.add(to2);
            ret = true;
        }
        if (this.opts.simple_edges_bidirectional() && this.doAddSimpleEdge(to2, from2)) {
            this.edgeQueue.add(to2);
            this.edgeQueue.add(from2);
            ret = true;
        }
        return ret;
    }

    public boolean addStoreEdge(VarNode from2, FieldRefNode to2) {
        if (!this.opts.rta() && this.doAddStoreEdge(from2, to2)) {
            this.edgeQueue.add(from2);
            this.edgeQueue.add(to2);
            return true;
        }
        return false;
    }

    public boolean addLoadEdge(FieldRefNode from2, VarNode to2) {
        if (!this.opts.rta() && this.doAddLoadEdge(from2, to2)) {
            this.edgeQueue.add(from2);
            this.edgeQueue.add(to2);
            return true;
        }
        return false;
    }

    public boolean addAllocEdge(AllocNode from2, VarNode to2) {
        FastHierarchy fh = this.typeManager.getFastHierarchy();
        if ((fh == null || to2.getType() == null || fh.canStoreType(from2.getType(), to2.getType())) && this.doAddAllocEdge(from2, to2)) {
            this.edgeQueue.add(from2);
            this.edgeQueue.add(to2);
            return true;
        }
        return false;
    }

    public final boolean addEdge(Node from2, Node to2) {
        from2 = from2.getReplacement();
        to2 = to2.getReplacement();
        if (from2 instanceof VarNode) {
            if (to2 instanceof VarNode) {
                return this.addSimpleEdge((VarNode)from2, (VarNode)to2);
            }
            return this.addStoreEdge((VarNode)from2, (FieldRefNode)to2);
        }
        if (from2 instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from2, (VarNode)to2);
        }
        return this.addAllocEdge((AllocNode)from2, (VarNode)to2);
    }

    public QueueReader<Node> edgeReader() {
        return this.edgeQueue.reader();
    }

    public int getNumAllocNodes() {
        return this.allocNodeNumberer.size();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setOnFlyCallGraph(OnFlyCallGraph ofcg) {
        this.ofcg = ofcg;
    }

    public OnFlyCallGraph getOnFlyCallGraph() {
        return this.ofcg;
    }

    public OnFlyCallGraph ofcg() {
        return this.ofcg;
    }

    public void addDereference(VarNode base) {
        this.dereferences.add(base);
    }

    public List<VarNode> getDereferences() {
        return this.dereferences;
    }

    public Map<Node, Tag> getNodeTags() {
        return this.nodeToTag;
    }

    public ArrayNumberer<AllocNode> getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public ArrayNumberer<VarNode> getVarNodeNumberer() {
        return this.varNodeNumberer;
    }

    public ArrayNumberer<FieldRefNode> getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public ArrayNumberer<AllocDotField> getAllocDotFieldNodeNumberer() {
        return this.allocDotFieldNodeNumberer;
    }

    public SparkOptions getOpts() {
        return this.opts;
    }

    public Pair<Node, Node> addInterproceduralAssignment(Node from2, Node to2, Edge e) {
        Pair<Node, Node> val = new Pair<Node, Node>(from2, to2);
        if (this.runGeomPTA) {
            Set<Edge> sets = this.assign2edges.get(val);
            if (sets == null) {
                sets = new HashSet<Edge>();
                this.assign2edges.put(val, sets);
            }
            sets.add(e);
        }
        return val;
    }

    public Set<Edge> lookupEdgesForAssignment(Pair<Node, Node> val) {
        return this.assign2edges.get(val);
    }

    public final void addCallTarget(Edge e) {
        if (!e.passesParameters()) {
            return;
        }
        MethodPAG srcmpag = MethodPAG.v(this, e.src());
        MethodPAG tgtmpag = MethodPAG.v(this, e.tgt());
        if (e.isExplicit() || e.kind() == Kind.THREAD || e.kind() == Kind.ASYNCTASK) {
            this.addCallTarget(srcmpag, tgtmpag, (Stmt)e.srcUnit(), e.srcCtxt(), e.tgtCtxt(), e);
        } else if (e.kind() == Kind.EXECUTOR) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            boolean virtualCall = this.callAssigns.containsKey((Object)ie);
            Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
            parm = srcmpag.parameterize(parm, e.srcCtxt());
            parm = parm.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(parm, thiz);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(parm, thiz, e);
            this.callAssigns.put(ie, pval);
            this.callToMethod.put(ie, srcmpag.getMethod());
            if (virtualCall && !this.virtualCallsToReceivers.containsKey(ie)) {
                this.virtualCallsToReceivers.put(ie, parm);
            }
        } else if (e.kind() == Kind.PRIVILEGED) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
            parm = srcmpag.parameterize(parm, e.srcCtxt());
            parm = parm.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(parm, thiz);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(parm, thiz, e);
            this.callAssigns.put(ie, pval);
            this.callToMethod.put(ie, srcmpag.getMethod());
            if (e.srcUnit() instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)e.srcUnit();
                Node ret = tgtmpag.nodeFactory().caseRet();
                ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                ret = ret.getReplacement();
                Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                lhs = lhs.getReplacement();
                this.addEdge(ret, lhs);
                pval = this.addInterproceduralAssignment(ret, lhs, e);
                this.callAssigns.put(ie, pval);
                this.callToMethod.put(ie, srcmpag.getMethod());
            }
        } else if (e.kind() == Kind.FINALIZE) {
            Node srcThis = srcmpag.nodeFactory().caseThis();
            srcThis = srcmpag.parameterize(srcThis, e.srcCtxt());
            srcThis = srcThis.getReplacement();
            Node tgtThis = tgtmpag.nodeFactory().caseThis();
            tgtThis = tgtmpag.parameterize(tgtThis, e.tgtCtxt());
            tgtThis = tgtThis.getReplacement();
            this.addEdge(srcThis, tgtThis);
            Pair<Node, Node> pval = this.addInterproceduralAssignment(srcThis, tgtThis, e);
        } else if (e.kind() == Kind.NEWINSTANCE) {
            Stmt s2 = (Stmt)e.srcUnit();
            InstanceInvokeExpr iie = (InstanceInvokeExpr)s2.getInvokeExpr();
            Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
            cls = srcmpag.parameterize(cls, e.srcCtxt());
            cls = cls.getReplacement();
            Node newObject = this.nodeFactory.caseNewInstance((VarNode)cls);
            Node initThis = tgtmpag.nodeFactory().caseThis();
            initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
            initThis = initThis.getReplacement();
            this.addEdge(newObject, initThis);
            if (s2 instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s2;
                Node asLHS = srcmpag.nodeFactory().getNode(as.getLeftOp());
                asLHS = srcmpag.parameterize(asLHS, e.srcCtxt());
                asLHS = asLHS.getReplacement();
                this.addEdge(newObject, asLHS);
            }
            Pair<Node, Node> pval = this.addInterproceduralAssignment(newObject, initThis, e);
            this.callAssigns.put(s2.getInvokeExpr(), pval);
            this.callToMethod.put(s2.getInvokeExpr(), srcmpag.getMethod());
        } else if (e.kind() == Kind.REFL_INVOKE) {
            Pair<Node, Node> pval;
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Value arg0 = ie.getArg(0);
            if (arg0 != NullConstant.v()) {
                Node parm0 = srcmpag.nodeFactory().getNode(arg0);
                parm0 = srcmpag.parameterize(parm0, e.srcCtxt());
                parm0 = parm0.getReplacement();
                Node thiz = tgtmpag.nodeFactory().caseThis();
                thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
                thiz = thiz.getReplacement();
                this.addEdge(parm0, thiz);
                pval = this.addInterproceduralAssignment(parm0, thiz, e);
                this.callAssigns.put(ie, pval);
                this.callToMethod.put(ie, srcmpag.getMethod());
            }
            Value arg1 = ie.getArg(1);
            SootMethod tgt = e.getTgt().method();
            if (arg1 != NullConstant.v() && tgt.getParameterCount() > 0) {
                Node parm1 = srcmpag.nodeFactory().getNode(arg1);
                parm1 = srcmpag.parameterize(parm1, e.srcCtxt());
                parm1 = parm1.getReplacement();
                FieldRefNode parm1contents = this.makeFieldRefNode((VarNode)parm1, ArrayElement.v());
                for (int i = 0; i < tgt.getParameterCount(); ++i) {
                    if (!(tgt.getParameterType(i) instanceof RefLikeType)) continue;
                    Node tgtParmI = tgtmpag.nodeFactory().caseParm(i);
                    tgtParmI = tgtmpag.parameterize(tgtParmI, e.tgtCtxt());
                    tgtParmI = tgtParmI.getReplacement();
                    this.addEdge(parm1contents, tgtParmI);
                    pval = this.addInterproceduralAssignment(parm1contents, tgtParmI, e);
                    this.callAssigns.put(ie, pval);
                }
            }
            if (e.srcUnit() instanceof AssignStmt && tgt.getReturnType() instanceof RefLikeType) {
                AssignStmt as = (AssignStmt)e.srcUnit();
                Node ret = tgtmpag.nodeFactory().caseRet();
                ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                ret = ret.getReplacement();
                Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                lhs = lhs.getReplacement();
                this.addEdge(ret, lhs);
                pval = this.addInterproceduralAssignment(ret, lhs, e);
                this.callAssigns.put(ie, pval);
            }
        } else if (e.kind() == Kind.REFL_CLASS_NEWINSTANCE || e.kind() == Kind.REFL_CONSTR_NEWINSTANCE) {
            Pair<Node, Node> pval;
            Stmt s3 = (Stmt)e.srcUnit();
            InstanceInvokeExpr iie = (InstanceInvokeExpr)s3.getInvokeExpr();
            Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
            cls = srcmpag.parameterize(cls, e.srcCtxt());
            if ((cls = cls.getReplacement()) instanceof ContextVarNode) {
                cls = this.findLocalVarNode(((VarNode)cls).getVariable());
            }
            GlobalVarNode newObject = this.makeGlobalVarNode(cls, RefType.v("java.lang.Object"));
            SootClass tgtClass = e.getTgt().method().getDeclaringClass();
            RefType tgtType = tgtClass.getType();
            AllocNode site = this.makeAllocNode(new Pair<Node, SootClass>(cls, tgtClass), tgtType, null);
            this.addEdge(site, newObject);
            Node initThis = tgtmpag.nodeFactory().caseThis();
            initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
            initThis = initThis.getReplacement();
            this.addEdge(newObject, initThis);
            this.addInterproceduralAssignment(newObject, initThis, e);
            if (e.kind() == Kind.REFL_CONSTR_NEWINSTANCE) {
                Value arg = iie.getArg(0);
                SootMethod tgt = e.getTgt().method();
                if (arg != NullConstant.v() && tgt.getParameterCount() > 0) {
                    Node parm0 = srcmpag.nodeFactory().getNode(arg);
                    parm0 = srcmpag.parameterize(parm0, e.srcCtxt());
                    parm0 = parm0.getReplacement();
                    FieldRefNode parm1contents = this.makeFieldRefNode((VarNode)parm0, ArrayElement.v());
                    for (int i = 0; i < tgt.getParameterCount(); ++i) {
                        if (!(tgt.getParameterType(i) instanceof RefLikeType)) continue;
                        Node tgtParmI = tgtmpag.nodeFactory().caseParm(i);
                        tgtParmI = tgtmpag.parameterize(tgtParmI, e.tgtCtxt());
                        tgtParmI = tgtParmI.getReplacement();
                        this.addEdge(parm1contents, tgtParmI);
                        pval = this.addInterproceduralAssignment(parm1contents, tgtParmI, e);
                        this.callAssigns.put(iie, pval);
                    }
                }
            }
            if (s3 instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s3;
                Node asLHS = srcmpag.nodeFactory().getNode(as.getLeftOp());
                asLHS = srcmpag.parameterize(asLHS, e.srcCtxt());
                asLHS = asLHS.getReplacement();
                this.addEdge(newObject, asLHS);
            }
            pval = this.addInterproceduralAssignment(newObject, initThis, e);
            this.callAssigns.put(s3.getInvokeExpr(), pval);
            this.callToMethod.put(s3.getInvokeExpr(), srcmpag.getMethod());
        } else {
            throw new RuntimeException("Unhandled edge " + e);
        }
    }

    public final void addCallTarget(MethodPAG srcmpag, MethodPAG tgtmpag, Stmt s2, Context srcContext, Context tgtContext, Edge e) {
        Value dest;
        Pair<Node, Node> pval;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        InvokeExpr ie = s2.getInvokeExpr();
        boolean virtualCall = this.callAssigns.containsKey((Object)ie);
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            Node argNode = srcnf.getNode(arg);
            argNode = srcmpag.parameterize(argNode, srcContext);
            argNode = argNode.getReplacement();
            Node parm = tgtnf.caseParm(i);
            parm = tgtmpag.parameterize(parm, tgtContext);
            parm = parm.getReplacement();
            this.addEdge(argNode, parm);
            Pair<Node, Node> pval2 = this.addInterproceduralAssignment(argNode, parm, e);
            this.callAssigns.put(ie, pval2);
            this.callToMethod.put(ie, srcmpag.getMethod());
        }
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            Node baseNode = srcnf.getNode(iie.getBase());
            baseNode = srcmpag.parameterize(baseNode, srcContext);
            baseNode = baseNode.getReplacement();
            Node thisRef = tgtnf.caseThis();
            thisRef = tgtmpag.parameterize(thisRef, tgtContext);
            thisRef = thisRef.getReplacement();
            this.addEdge(baseNode, thisRef);
            pval = this.addInterproceduralAssignment(baseNode, thisRef, e);
            this.callAssigns.put(ie, pval);
            this.callToMethod.put(ie, srcmpag.getMethod());
            if (virtualCall && !this.virtualCallsToReceivers.containsKey(ie)) {
                this.virtualCallsToReceivers.put(ie, baseNode);
            }
        }
        if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType && !(dest instanceof NullConstant)) {
            Node destNode = srcnf.getNode(dest);
            destNode = srcmpag.parameterize(destNode, srcContext);
            destNode = destNode.getReplacement();
            Node retNode = tgtnf.caseRet();
            retNode = tgtmpag.parameterize(retNode, tgtContext);
            retNode = retNode.getReplacement();
            this.addEdge(retNode, destNode);
            pval = this.addInterproceduralAssignment(retNode, destNode, e);
            this.callAssigns.put(ie, pval);
            this.callToMethod.put(ie, srcmpag.getMethod());
        }
    }

    public void cleanPAG() {
        this.simple.clear();
        this.load.clear();
        this.store.clear();
        this.alloc.clear();
        this.simpleInv.clear();
        this.loadInv.clear();
        this.storeInv.clear();
        this.allocInv.clear();
    }

    protected <K extends Node> boolean addToMap(Map<K, Object> m, K key2, Node value2) {
        HashSet valueList = m.get(key2);
        if (valueList == null) {
            valueList = new HashSet(4);
            m.put(key2, valueList);
        } else if (!(valueList instanceof Set)) {
            Node[] ar = (Node[])valueList;
            HashSet<Node> vl = new HashSet<Node>(ar.length + 4);
            m.put(key2, vl);
            for (Node element2 : ar) {
                vl.add(element2);
            }
            return vl.add(value2);
        }
        return ((Set)valueList).add(value2);
    }

    public GlobalNodeFactory nodeFactory() {
        return this.nodeFactory;
    }
}

