/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.List;
import soot.Immediate;
import soot.IntType;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.UnitBoxOwner;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.ArrayWriteInst;
import soot.baf.Baf;
import soot.baf.FieldPutInst;
import soot.baf.IncInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.ConvertToBaf;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StaticFieldRef;
import soot.jimple.StmtSwitch;
import soot.jimple.SubExpr;
import soot.jimple.internal.AbstractDefinitionStmt;
import soot.jimple.internal.RValueBox;
import soot.jimple.internal.VariableBox;
import soot.util.Switch;

public class JAssignStmt
extends AbstractDefinitionStmt
implements AssignStmt {
    public JAssignStmt(Value variable, Value rvalue) {
        this(new LinkedVariableBox(variable), new LinkedRValueBox(rvalue));
        ((LinkedVariableBox)this.leftBox).setOtherBox(this.rightBox);
        ((LinkedRValueBox)this.rightBox).setOtherBox(this.leftBox);
        if (!this.leftBox.canContainValue(variable) || !this.rightBox.canContainValue(rvalue)) {
            throw new RuntimeException("Illegal assignment statement.  Make sure that either left side or right hand side has a local or constant.");
        }
    }

    protected JAssignStmt(ValueBox variableBox, ValueBox rvalueBox) {
        super(variableBox, rvalueBox);
    }

    @Override
    public boolean containsInvokeExpr() {
        return this.getRightOp() instanceof InvokeExpr;
    }

    @Override
    public InvokeExpr getInvokeExpr() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return (InvokeExpr)this.rightBox.getValue();
    }

    @Override
    public ValueBox getInvokeExprBox() {
        if (!this.containsInvokeExpr()) {
            throw new RuntimeException("getInvokeExpr() called with no invokeExpr present!");
        }
        return this.rightBox;
    }

    @Override
    public boolean containsArrayRef() {
        return this.getLeftOp() instanceof ArrayRef || this.getRightOp() instanceof ArrayRef;
    }

    @Override
    public ArrayRef getArrayRef() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRef() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return (ArrayRef)this.leftBox.getValue();
        }
        return (ArrayRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getArrayRefBox() {
        if (!this.containsArrayRef()) {
            throw new RuntimeException("getArrayRefBox() called with no ArrayRef present!");
        }
        if (this.leftBox.getValue() instanceof ArrayRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public boolean containsFieldRef() {
        return this.getLeftOp() instanceof FieldRef || this.getRightOp() instanceof FieldRef;
    }

    @Override
    public FieldRef getFieldRef() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRef() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return (FieldRef)this.leftBox.getValue();
        }
        return (FieldRef)this.rightBox.getValue();
    }

    @Override
    public ValueBox getFieldRefBox() {
        if (!this.containsFieldRef()) {
            throw new RuntimeException("getFieldRefBox() called with no FieldRef present!");
        }
        if (this.leftBox.getValue() instanceof FieldRef) {
            return this.leftBox;
        }
        return this.rightBox;
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        Value rValue = this.rightBox.getValue();
        if (rValue instanceof UnitBoxOwner) {
            return ((UnitBoxOwner)((Object)rValue)).getUnitBoxes();
        }
        return super.getUnitBoxes();
    }

    public String toString() {
        return this.leftBox.getValue().toString() + " = " + this.rightBox.getValue().toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        this.leftBox.toString(up);
        up.literal(" = ");
        this.rightBox.toString(up);
    }

    @Override
    public Object clone() {
        return new JAssignStmt(Jimple.cloneIfNecessary(this.getLeftOp()), Jimple.cloneIfNecessary(this.getRightOp()));
    }

    @Override
    public void setLeftOp(Value variable) {
        this.getLeftOpBox().setValue(variable);
    }

    @Override
    public void setRightOp(Value rvalue) {
        this.getRightOpBox().setValue(rvalue);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseAssignStmt(this);
    }

    @Override
    public void convertToBaf(final JimpleToBafContext context, final List<Unit> out) {
        Value lvalue = this.getLeftOp();
        final Value rvalue = this.getRightOp();
        if (lvalue instanceof Local && (rvalue instanceof AddExpr || rvalue instanceof SubExpr)) {
            Local l = (Local)lvalue;
            BinopExpr expr = (BinopExpr)rvalue;
            Value op1 = expr.getOp1();
            Value op2 = expr.getOp2();
            if (l.getType().equals(IntType.v())) {
                boolean isValidCase = false;
                int x = 0;
                if (op1 == l && op2 instanceof IntConstant) {
                    x = ((IntConstant)op2).value;
                    isValidCase = true;
                } else if (expr instanceof AddExpr && op2 == l && op1 instanceof IntConstant) {
                    x = ((IntConstant)op1).value;
                    isValidCase = true;
                }
                if (isValidCase && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                    IncInst u = Baf.v().newIncInst(context.getBafLocalOfJimpleLocal(l), IntConstant.v(expr instanceof AddExpr ? x : -x));
                    u.addAllTagsOf(this);
                    out.add(u);
                    return;
                }
            }
        }
        context.setCurrentUnit(this);
        lvalue.apply(new AbstractJimpleValueSwitch(){

            @Override
            public void caseArrayRef(ArrayRef v) {
                ((ConvertToBaf)((Object)v.getBase())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)v.getIndex())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                ArrayWriteInst u = Baf.v().newArrayWriteInst(v.getType());
                u.addAllTagsOf(JAssignStmt.this);
                out.add(u);
            }

            @Override
            public void caseInstanceFieldRef(InstanceFieldRef v) {
                ((ConvertToBaf)((Object)v.getBase())).convertToBaf(context, out);
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                FieldPutInst u = Baf.v().newFieldPutInst(v.getFieldRef());
                u.addAllTagsOf(JAssignStmt.this);
                out.add(u);
            }

            @Override
            public void caseLocal(Local v) {
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                StoreInst u = Baf.v().newStoreInst(v.getType(), context.getBafLocalOfJimpleLocal(v));
                u.addAllTagsOf(JAssignStmt.this);
                out.add(u);
            }

            @Override
            public void caseStaticFieldRef(StaticFieldRef v) {
                ((ConvertToBaf)((Object)rvalue)).convertToBaf(context, out);
                StaticPutInst u = Baf.v().newStaticPutInst(v.getFieldRef());
                u.addAllTagsOf(JAssignStmt.this);
                out.add(u);
            }
        });
    }

    private static class LinkedRValueBox
    extends RValueBox {
        ValueBox otherBox = null;

        private LinkedRValueBox(Value v) {
            super(v);
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        @Override
        public boolean canContainValue(Value v) {
            if (super.canContainValue(v)) {
                if (this.otherBox == null) {
                    return true;
                }
                Value o = this.otherBox.getValue();
                return v instanceof Immediate || o instanceof Immediate;
            }
            return false;
        }
    }

    private static class LinkedVariableBox
    extends VariableBox {
        ValueBox otherBox = null;

        private LinkedVariableBox(Value v) {
            super(v);
        }

        public void setOtherBox(ValueBox otherBox) {
            this.otherBox = otherBox;
        }

        @Override
        public boolean canContainValue(Value v) {
            if (super.canContainValue(v)) {
                if (this.otherBox == null) {
                    return true;
                }
                Value o = this.otherBox.getValue();
                return v instanceof Immediate || o instanceof Immediate;
            }
            return false;
        }
    }
}

