/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.source;

import java.util.Collections;
import java.util.Set;
import soot.jimple.infoflow.data.AccessPath;

public class SourceInfo {
    private final Object userData;
    private final Set<AccessPath> accessPaths;

    public SourceInfo(AccessPath ap) {
        this(Collections.singleton(ap), null);
    }

    public SourceInfo(AccessPath ap, Object userData) {
        this(Collections.singleton(ap), userData);
    }

    public SourceInfo(Set<AccessPath> bundle) {
        this(bundle, null);
    }

    public SourceInfo(Set<AccessPath> bundle, Object userData) {
        this.userData = userData;
        this.accessPaths = bundle;
    }

    public int hashCode() {
        return 31 * (this.userData == null ? 0 : this.userData.hashCode()) + 31 * (this.accessPaths == null ? 0 : this.accessPaths.hashCode());
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SourceInfo)) {
            return false;
        }
        SourceInfo otherInfo = (SourceInfo)other;
        if (this.userData == null && otherInfo.userData != null) {
            return false;
        }
        if (this.accessPaths == null) {
            if (otherInfo.userData != null) {
                return false;
            }
        } else {
            if (!this.userData.equals(otherInfo.userData)) {
                return false;
            }
            if (!this.accessPaths.equals(otherInfo.accessPaths)) {
                return false;
            }
        }
        return true;
    }

    public Object getUserData() {
        return this.userData;
    }

    public Set<AccessPath> getAccessPaths() {
        return this.accessPaths;
    }
}

