/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.source;

import heros.InterproceduralCFG;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.source.SourceInfo;

public class DefaultSourceSinkManager
implements ISourceSinkManager {
    private Collection<String> sources;
    private Collection<String> sinks;
    private Collection<String> returnTaintMethods;
    private Collection<String> parameterTaintMethods;

    public DefaultSourceSinkManager(Collection<String> sources, Collection<String> sinks) {
        this(sources, sinks, null, null);
    }

    public DefaultSourceSinkManager(Collection<String> sources, Collection<String> sinks, Collection<String> parameterTaintMethods, Collection<String> returnTaintMethods) {
        this.sources = sources;
        this.sinks = sinks;
        this.parameterTaintMethods = parameterTaintMethods != null ? parameterTaintMethods : new HashSet();
        this.returnTaintMethods = returnTaintMethods != null ? returnTaintMethods : new HashSet();
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public void setSinks(List<String> sinks) {
        this.sinks = sinks;
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg) {
        IdentityStmt istmt;
        SootMethod callee = sCallSite.containsInvokeExpr() ? sCallSite.getInvokeExpr().getMethod() : null;
        AccessPath targetAP = null;
        if (callee != null && this.sources.contains(callee.toString())) {
            if (callee.getReturnType() != null && sCallSite instanceof DefinitionStmt) {
                Value leftOp = ((DefinitionStmt)sCallSite).getLeftOp();
                targetAP = new AccessPath(leftOp, true);
            } else if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
                Value base = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                targetAP = new AccessPath(base, true);
            }
        } else if (sCallSite instanceof IdentityStmt && (istmt = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
            ParameterRef pref = (ParameterRef)istmt.getRightOp();
            SootMethod currentMethod = cfg.getMethodOf(istmt);
            if (this.parameterTaintMethods.contains(currentMethod.toString())) {
                targetAP = new AccessPath(currentMethod.getActiveBody().getParameterLocal(pref.getIndex()), true);
            }
        }
        if (targetAP == null) {
            return null;
        }
        return new SourceInfo(targetAP);
    }

    @Override
    public boolean isSink(Stmt sCallSite, InterproceduralCFG<Unit, SootMethod> cfg, AccessPath ap) {
        if (this.returnTaintMethods != null && sCallSite instanceof ReturnStmt && this.returnTaintMethods.contains(cfg.getMethodOf(sCallSite).getSignature())) {
            return true;
        }
        return this.sinks != null && sCallSite.containsInvokeExpr() && this.sinks.contains(sCallSite.getInvokeExpr().getMethod().getSignature());
    }

    public void setParameterTaintMethods(List<String> parameterTaintMethods) {
        this.parameterTaintMethods = parameterTaintMethods;
    }

    public void setReturnTaintMethods(List<String> returnTaintMethods) {
        this.returnTaintMethods = returnTaintMethods;
    }
}

