/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.util.ArrayList;
import java.util.List;

public class RIFLDocument {
    private AttackerIO attackerIO = new AttackerIO();
    private List<DomainSpec> domains = new ArrayList<DomainSpec>();
    private List<SourceSinkDomPair> domainAssignment = new ArrayList<SourceSinkDomPair>();
    private List<DomPair> domainHierarchy = new ArrayList<DomPair>();
    private List<FlowPair> flowPolicy = new ArrayList<FlowPair>();
    private TopDomain topDomain = null;
    private BottomDomain bottomDomain = null;

    public AttackerIO getAttackerIO() {
        return this.attackerIO;
    }

    public List<DomainSpec> getDomains() {
        return this.domains;
    }

    public List<SourceSinkDomPair> getDomainAssignment() {
        return this.domainAssignment;
    }

    public List<DomPair> getDomainHierarchy() {
        return this.domainHierarchy;
    }

    public List<FlowPair> getFlowPolicy() {
        return this.flowPolicy;
    }

    public static String getRIFLSpecVersion() {
        return "1.0";
    }

    public TopDomain getTopDomain() {
        if (this.topDomain == null) {
            this.topDomain = new TopDomain();
        }
        return this.topDomain;
    }

    public BottomDomain getBottomDomain() {
        if (this.bottomDomain == null) {
            this.bottomDomain = new BottomDomain();
        }
        return this.bottomDomain;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.attackerIO == null ? 0 : this.attackerIO.hashCode());
        result2 = 31 * result2 + (this.domainAssignment == null ? 0 : this.domainAssignment.hashCode());
        result2 = 31 * result2 + (this.domainHierarchy == null ? 0 : this.domainHierarchy.hashCode());
        result2 = 31 * result2 + (this.domains == null ? 0 : this.domains.hashCode());
        result2 = 31 * result2 + (this.flowPolicy == null ? 0 : this.flowPolicy.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RIFLDocument)) {
            return false;
        }
        RIFLDocument other = (RIFLDocument)obj;
        return this.attackerIO.equals(other.attackerIO) && this.domainAssignment.equals(other.domainAssignment) && this.domainHierarchy.equals(other.domainHierarchy) && this.domains.equals(other.domains) && this.flowPolicy.equals(other.flowPolicy);
    }

    public class FlowPair {
        private final DomainSpec firstDomain;
        private final DomainSpec secondDomain;

        public FlowPair(DomainSpec firstDomain, DomainSpec secondDomain) {
            this.firstDomain = firstDomain;
            this.secondDomain = secondDomain;
        }

        public DomainSpec getFirstDomain() {
            return this.firstDomain;
        }

        public DomainSpec getSecondDomain() {
            return this.secondDomain;
        }

        public int hashCode() {
            return 31 * this.firstDomain.hashCode() + 31 * this.secondDomain.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof FlowPair)) {
                return false;
            }
            FlowPair otherPair = (FlowPair)other;
            return this.firstDomain.equals(otherPair.firstDomain) && this.secondDomain.equals(otherPair.secondDomain);
        }
    }

    public class DomPair {
        private final DomainSpec firstDomain;
        private final DomainSpec secondDomain;

        public DomPair(DomainSpec firstDomain, DomainSpec secondDomain) {
            this.firstDomain = firstDomain;
            this.secondDomain = secondDomain;
        }

        public DomainSpec getFirstDomain() {
            return this.firstDomain;
        }

        public DomainSpec getSecondDomain() {
            return this.secondDomain;
        }

        public int hashCode() {
            return 31 * this.firstDomain.hashCode() + 31 * this.secondDomain.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof DomPair)) {
                return false;
            }
            DomPair otherPair = (DomPair)other;
            return this.firstDomain.equals(otherPair.firstDomain) && this.secondDomain.equals(otherPair.secondDomain);
        }
    }

    public class SourceSinkDomPair {
        private final SourceSinkSpec sourceOrSink;
        private final DomainSpec domain;
        private final DomPairType type;

        public SourceSinkDomPair(SourceSinkSpec sourceOrSink, DomainSpec domain, DomPairType type) {
            this.sourceOrSink = sourceOrSink;
            this.domain = domain;
            this.type = type;
        }

        public SourceSinkSpec getSourceOrSink() {
            return this.sourceOrSink;
        }

        public DomainSpec getDomain() {
            return this.domain;
        }

        public DomPairType getType() {
            return this.type;
        }

        public int hashCode() {
            return 31 * this.sourceOrSink.hashCode() + 31 * this.domain.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof SourceSinkDomPair)) {
                return false;
            }
            SourceSinkDomPair otherPair = (SourceSinkDomPair)other;
            return this.sourceOrSink.equals(otherPair.sourceOrSink) && this.domain.equals(otherPair.domain);
        }
    }

    public static enum DomPairType {
        SourceDomPair,
        SinkDomPair;

    }

    public class Category
    extends DomainSpec {
        private String value;

        public Category(String value2) {
            this.value = "";
            this.value = value2;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return 31 * this.value.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof Category)) {
                return false;
            }
            Category otherSpec = (Category)other;
            return this.value.equals(otherSpec.value);
        }
    }

    public class BottomDomain
    extends DomainSpec {
    }

    public class TopDomain
    extends DomainSpec {
    }

    public abstract class DomainSpec {
    }

    public class JavaFieldSpec
    extends JavaSourceSinkSpec {
        private final String packageName;
        private final String className;
        private final String fieldName;

        public JavaFieldSpec(String packageName, String className, String fieldName) {
            this.packageName = packageName;
            this.className = className;
            this.fieldName = fieldName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int hashCode() {
            return 31 * this.packageName.hashCode() + 31 * this.className.hashCode() + 31 * this.fieldName.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof JavaFieldSpec)) {
                return false;
            }
            JavaFieldSpec otherSpec = (JavaFieldSpec)other;
            return this.packageName.equals(otherSpec.packageName) && this.className.equals(otherSpec.className) && this.fieldName.equals(otherSpec.fieldName);
        }
    }

    public class JavaParameterSpec
    extends JavaSourceSinkSpec {
        private final String packageName;
        private final String className;
        private final String halfSignature;
        private final int paramIdx;

        public JavaParameterSpec(String packageName, String className, String halfSignature, int paramIdx) {
            this.packageName = packageName;
            this.className = className;
            this.halfSignature = halfSignature;
            this.paramIdx = paramIdx;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getHalfSignature() {
            return this.halfSignature;
        }

        public int getParamIdx() {
            return this.paramIdx;
        }

        public int hashCode() {
            return 31 * this.packageName.hashCode() + 31 * this.className.hashCode() + 31 * this.halfSignature.hashCode() + 31 * this.paramIdx;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof JavaParameterSpec)) {
                return false;
            }
            JavaParameterSpec otherSpec = (JavaParameterSpec)other;
            return this.packageName.equals(otherSpec.packageName) && this.className.equals(otherSpec.className) && this.halfSignature.equals(otherSpec.halfSignature) && this.paramIdx == otherSpec.paramIdx;
        }
    }

    public class JavaSourceSinkSpec
    extends SourceSinkSpec {
    }

    public abstract class SourceSinkSpec {
    }

    public class AttackerIO {
        private List<SourceSinkSpec> sources = new ArrayList<SourceSinkSpec>();
        private List<SourceSinkSpec> sinks = new ArrayList<SourceSinkSpec>();

        public List<SourceSinkSpec> getSources() {
            return this.sources;
        }

        public List<SourceSinkSpec> getSinks() {
            return this.sinks;
        }

        public int hashCode() {
            return 31 * this.sources.hashCode() + 31 * this.sinks.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof AttackerIO)) {
                return false;
            }
            AttackerIO otherIO = (AttackerIO)other;
            return this.sources.equals(otherIO.sources) && this.sinks.equals(otherIO.sinks);
        }
    }
}

