/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.DefaultSeeds;
import heros.FlowFunction;
import heros.FlowFunctions;
import heros.InterproceduralCFG;
import heros.TwoElementSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.EquivalentValue;
import soot.Local;
import soot.NullType;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.problems.TaintFact;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.toolkits.ide.DefaultJimpleIFDSTabulationProblem;

public class IFDSForwardReachingConstantDefinitions
extends DefaultJimpleIFDSTabulationProblem<TaintFact, InterproceduralCFG<Unit, SootMethod>> {
    boolean found = false;
    static final boolean DEBUG = true;
    InfoflowCFG infoflowCFG;

    public IFDSForwardReachingConstantDefinitions(InfoflowCFG icfg) {
        super(icfg);
        this.infoflowCFG = icfg;
    }

    private static boolean checkIfIsArrayFunction(SootMethod method, InstanceInvokeExpr instanceInvokeExpr) {
        String methodName = method.getName();
        Value base = instanceInvokeExpr.getBase();
        System.out.println(base.getType());
        return base.getType().toString().equals("android.content.Intent") && methodName.startsWith("get") && methodName.contains("Array");
    }

    @Override
    public FlowFunctions<Unit, TaintFact, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, TaintFact, SootMethod>(){

            @Override
            public FlowFunction<TaintFact> getNormalFlowFunction(final Unit curr, final Unit succ) {
                if (curr instanceof DefinitionStmt) {
                    final DefinitionStmt assignment = (DefinitionStmt)curr;
                    return new FlowFunction<TaintFact>(){

                        @Override
                        public Set<TaintFact> computeTargets(TaintFact source) {
                            System.out.println("getNormalFlowFunction: " + curr + " in method: " + IFDSForwardReachingConstantDefinitions.this.interproceduralCFG().getMethodOf((Unit)curr) + " next inst: " + succ + " source: " + source);
                            if (source != IFDSForwardReachingConstantDefinitions.this.zeroValue()) {
                                FieldRef fieldRef;
                                System.out.println(source);
                                System.out.println(assignment.getLeftOp());
                                if (assignment.getRightOp() instanceof Constant && IFDSForwardReachingConstantDefinitions.maybeSameLocation(assignment.getLeftOp(), (Value)source.getO1())) {
                                    System.out.println("killing because of constant");
                                    return Collections.emptySet();
                                }
                                if (assignment.getRightOp() instanceof FieldRef && IFDSForwardReachingConstantDefinitions.maybeSameLocation(assignment.getLeftOp(), (Value)source.getO1()) && !((SootMethod)IFDSForwardReachingConstantDefinitions.this.interproceduralCFG().getMethodOf((Unit)curr)).isConstructor() && (fieldRef = (FieldRef)assignment.getRightOp()).getField().isFinal()) {
                                    System.out.println("killing because of final field and constructor");
                                    return Collections.emptySet();
                                }
                                if (((Value)source.getO1()).equivTo(assignment.getRightOp()) || IFDSForwardReachingConstantDefinitions.maybeSameLocation((Value)source.getO1(), assignment.getRightOp())) {
                                    System.out.println("transfering from " + source + " to " + assignment.getRightOp());
                                    Value left = assignment.getLeftOp();
                                    return Collections.singleton(new TaintFact(left, (Set)source.getO2()));
                                }
                                return Collections.singleton(source);
                            }
                            System.out.println("killing because of zero value");
                            return Collections.emptySet();
                        }
                    };
                }
                return new FlowFunction<TaintFact>(){

                    @Override
                    public Set<TaintFact> computeTargets(TaintFact source) {
                        if (source == IFDSForwardReachingConstantDefinitions.this.zeroValue()) {
                            return Collections.emptySet();
                        }
                        return Collections.singleton(source);
                    }
                };
            }

            @Override
            public FlowFunction<TaintFact> getCallFlowFunction(Unit callStmt, final SootMethod destinationMethod) {
                final Stmt stmt = (Stmt)callStmt;
                InvokeExpr invokeExpr = stmt.getInvokeExpr();
                final List<Value> args = invokeExpr.getArgs();
                final ArrayList<Local> localArguments = new ArrayList<Local>(args.size());
                for (Value value2 : args) {
                    if (value2 instanceof Local) {
                        localArguments.add((Local)value2);
                        continue;
                    }
                    localArguments.add(null);
                }
                return new FlowFunction<TaintFact>(){

                    @Override
                    public Set<TaintFact> computeTargets(TaintFact source) {
                        System.out.println("getCallFlowFunction: " + stmt + " source: " + source + " in method: " + IFDSForwardReachingConstantDefinitions.this.interproceduralCFG().getMethodOf((Stmt)stmt));
                        if (source == IFDSForwardReachingConstantDefinitions.this.zeroValue()) {
                            return Collections.emptySet();
                        }
                        LinkedHashSet<TaintFact> values2 = new LinkedHashSet<TaintFact>();
                        if (source.getO1() instanceof FieldRef) {
                            System.out.println("checking field ref: " + source + " on " + stmt);
                            System.out.println("checking this fields... type:" + ((Value)source.getO1()).getClass());
                            if (source.getO1() instanceof InstanceFieldRef && stmt.containsInvokeExpr() && stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                                InstanceFieldRef instanceFieldRef = (InstanceFieldRef)source.getO1();
                                Value invokeBase = ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase();
                                System.out.println("comparing local: " + instanceFieldRef.getBase() + " and " + invokeBase);
                                if (IFDSForwardReachingConstantDefinitions.mayBaseAtSameLocation((Local)instanceFieldRef.getBase(), (Local)invokeBase)) {
                                    values2.add(source);
                                }
                            } else if (source.getO1() instanceof StaticFieldRef) {
                                System.out.println("adding staticfield ref: " + source);
                                values2.add(source);
                            } else {
                                System.out.println("not static ref or this field, ignoring");
                            }
                            if (values2.size() == 0) {
                                System.out.println("killing value: " + source + " in callflowfunction");
                                return Collections.emptySet();
                            }
                            return values2;
                        }
                        if (!destinationMethod.getName().equals("<clinit>") && !destinationMethod.getSubSignature().equals("void run()") && localArguments.contains(source.getO1())) {
                            int paramIndex = args.indexOf(source.getO1());
                            TaintFact pair = new TaintFact(new EquivalentValue(Jimple.v().newParameterRef(destinationMethod.getParameterType(paramIndex), paramIndex)), (Set)source.getO2());
                            return Collections.singleton(pair);
                        }
                        return Collections.emptySet();
                    }
                };
            }

            @Override
            public FlowFunction<TaintFact> getReturnFlowFunction(final Unit callSite, final SootMethod calleeMethod, final Unit exitStmt, final Unit returnSite) {
                return new FlowFunction<TaintFact>(){

                    @Override
                    public Set<TaintFact> computeTargets(TaintFact source) {
                        ReturnStmt returnStmt;
                        System.out.println("return flow flow :" + callSite);
                        System.out.println("getReturnFlowFunction: callSite " + callSite + " calleeMethod: " + calleeMethod.getSignature() + " exitStmt: " + exitStmt + " returnSite: " + returnSite + " source: " + source);
                        if (exitStmt instanceof ReturnStmt && (returnStmt = (ReturnStmt)exitStmt).getOp().equivTo(source.getO1())) {
                            DefinitionStmt definitionStmt = (DefinitionStmt)callSite;
                            TaintFact pair = new TaintFact(definitionStmt.getLeftOp(), (Set)source.getO2());
                            return Collections.singleton(pair);
                        }
                        if (source.getO1() instanceof FieldRef) {
                            System.out.println("passing taint on fieldref in getReturnFlow functions: " + source);
                            return Collections.singleton(source);
                        }
                        System.out.println("killing value: " + source + " in returnflow function");
                        return Collections.emptySet();
                    }
                };
            }

            @Override
            public FlowFunction<TaintFact> getCallToReturnFlowFunction(final Unit callSite, final Unit returnSite) {
                final Stmt stmt = (Stmt)callSite;
                System.out.println("callflow :" + stmt);
                System.out.println("call-to-return flow flow :" + callSite);
                return new FlowFunction<TaintFact>(){

                    @Override
                    public Set<TaintFact> computeTargets(TaintFact source) {
                        SootMethod callee = ((Stmt)callSite).getInvokeExpr().getMethod();
                        if (callee.getName().equals("getIntent") && callSite instanceof DefinitionStmt) {
                            System.out.println("call-to-return flow flow generating getIntent taint");
                            DefinitionStmt definitionStmt = (DefinitionStmt)callSite;
                            TaintFact newfact = new TaintFact(definitionStmt.getLeftOp(), Collections.singleton(definitionStmt));
                            System.out.println("checking two sources: I: " + source + " II: " + newfact);
                            if (((Value)source.getO1()).getType().toString().equals("android.content.Intent")) {
                                System.out.println("facts are same or zero because in getIntent");
                                return Collections.singleton(newfact);
                            }
                            return new TwoElementSet<TaintFact>(newfact, source);
                        }
                        if (callSite instanceof DefinitionStmt && stmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                            Value base = ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase();
                            if (IFDSForwardReachingConstantDefinitions.checkIfIsArrayFunction(callee, (InstanceInvokeExpr)stmt.getInvokeExpr()) && base.equivTo(source.getO1())) {
                                System.out.println("call-to-return flow flow generating getExtra taint");
                                DefinitionStmt definitionStmt = (DefinitionStmt)callSite;
                                HashSet<DefinitionStmt> stmts = new HashSet<DefinitionStmt>();
                                stmts.addAll((Collection)source.getO2());
                                stmts.add(definitionStmt);
                                TaintFact newfact = new TaintFact(definitionStmt.getLeftOp(), (Set<DefinitionStmt>)stmts);
                                if (newfact.equals(source) || source == IFDSForwardReachingConstantDefinitions.this.zeroValue()) {
                                    return Collections.singleton(newfact);
                                }
                                return new TwoElementSet<TaintFact>(newfact, source);
                            }
                        }
                        System.out.println("getCallToReturnFlowFunction: callSite " + callSite + " returnSite: " + returnSite + " source: " + source);
                        if (source == IFDSForwardReachingConstantDefinitions.this.zeroValue()) {
                            return Collections.emptySet();
                        }
                        if (source.getO1() instanceof FieldRef) {
                            InvokeExpr invokeExpr;
                            if (source.getO1() instanceof StaticFieldRef) {
                                System.out.println("value: " + source + "killed  because of staticfieldref in getCallToReturn");
                                if (!IFDSForwardReachingConstantDefinitions.this.infoflowCFG.isStaticFieldUsed(callee, ((StaticFieldRef)source.getO1()).getField())) {
                                    return Collections.singleton(source);
                                }
                                return Collections.emptySet();
                            }
                            if (source.getO1() instanceof InstanceFieldRef && stmt.containsInvokeExpr() && (invokeExpr = stmt.getInvokeExpr()) instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
                                InstanceFieldRef instanceFieldRef = (InstanceFieldRef)source.getO1();
                                if (IFDSForwardReachingConstantDefinitions.mayBaseAtSameLocation((Local)instanceFieldRef.getBase(), (Local)instanceInvokeExpr.getBase())) {
                                    System.out.println("value: " + source + "killed  because of this field in getCallToReturn");
                                    return Collections.emptySet();
                                }
                            }
                            System.out.println("value: " + source + "propagated because non-this nor static in calltoreturn");
                            return Collections.singleton(source);
                        }
                        if (callSite instanceof DefinitionStmt) {
                            DefinitionStmt assignStmt = (DefinitionStmt)callSite;
                            if (((Value)source.getO1()).equivTo(assignStmt.getLeftOp()) || IFDSForwardReachingConstantDefinitions.maybeSameLocation((Value)source.getO1(), assignStmt.getLeftOp())) {
                                System.out.println("killing value: " + source + " because of return overwrite");
                                return Collections.emptySet();
                            }
                            return Collections.singleton(source);
                        }
                        return Collections.singleton(source);
                    }
                };
            }
        };
    }

    @Override
    public Map<Unit, Set<TaintFact>> initialSeeds() {
        System.out.println("initial seeds");
        return DefaultSeeds.make(Collections.singleton(Scene.v().getEntryPoints().get(0).getActiveBody().getUnits().getFirst()), this.zeroValue());
    }

    @Override
    public TaintFact createZeroValue() {
        return new TaintFact(new JimpleLocal("<<zero>>", NullType.v()), Collections.emptySet());
    }

    public static boolean mayBaseAtSameLocation(Local base1, Local base2) {
        PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
        PointsToSet pts1 = pta.reachingObjects(base1);
        PointsToSet pts2 = pta.reachingObjects(base2);
        return pts1.hasNonEmptyIntersection(pts2);
    }

    public static boolean maybeSameLocation(Value v1, Value v2) {
        if (!(v1 instanceof InstanceFieldRef && v2 instanceof InstanceFieldRef || v1 instanceof ArrayRef && v2 instanceof ArrayRef)) {
            return v1.equivTo(v2);
        }
        if (v1 instanceof InstanceFieldRef && v2 instanceof InstanceFieldRef) {
            InstanceFieldRef ifr1 = (InstanceFieldRef)v1;
            InstanceFieldRef ifr2 = (InstanceFieldRef)v2;
            if (!ifr1.getField().getName().equals(ifr2.getField().getName())) {
                return false;
            }
            Local base1 = (Local)ifr1.getBase();
            Local base2 = (Local)ifr2.getBase();
            PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
            PointsToSet pts1 = pta.reachingObjects(base1);
            PointsToSet pts2 = pta.reachingObjects(base2);
            return pts1.hasNonEmptyIntersection(pts2);
        }
        ArrayRef ar1 = (ArrayRef)v1;
        ArrayRef ar2 = (ArrayRef)v2;
        Local base1 = (Local)ar1.getBase();
        Local base2 = (Local)ar2.getBase();
        PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
        PointsToSet pts1 = pta.reachingObjects(base1);
        PointsToSet pts2 = pta.reachingObjects(base2);
        return pts1.hasNonEmptyIntersection(pts2);
    }

    public static Value getFieldRefWrap(Value value2) {
        if (value2 instanceof FieldRef) {
            return new EquivalentValue((FieldRef)value2);
        }
        return value2;
    }
}

