/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.IntType;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.internal.JEqExpr;
import soot.jimple.internal.JGotoStmt;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.toolkits.scalar.NopEliminator;

public class DefaultEntryPointCreator
extends BaseEntryPointCreator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntryPointCreator.class);
    private final Collection<String> methodsToCall;

    public DefaultEntryPointCreator(Collection<String> methodsToCall) {
        this.methodsToCall = methodsToCall;
    }

    @Override
    protected SootMethod createDummyMainInternal(SootMethod mainMethod) {
        HashMap<String, Set<String>> classMap = SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false);
        Body body = mainMethod.getActiveBody();
        LocalGenerator generator = new LocalGenerator(body);
        HashMap<String, Local> localVarsForClasses = new HashMap<String, Local>();
        for (String className : classMap.keySet()) {
            SootClass createdClass = Scene.v().forceResolve(className, 3);
            createdClass.setApplicationClass();
            Local localVal = this.generateClassConstructor(createdClass, body);
            if (localVal == null) {
                logger.warn("Cannot generate constructor for class: {}", (Object)createdClass);
                continue;
            }
            localVarsForClasses.put(className, localVal);
        }
        int conditionCounter = 0;
        JNopStmt startStmt = new JNopStmt();
        JNopStmt endStmt = new JNopStmt();
        Local intCounter = generator.generateLocal(IntType.v());
        body.getUnits().add(startStmt);
        for (Map.Entry entry2 : classMap.entrySet()) {
            Local classLocal = (Local)localVarsForClasses.get(entry2.getKey());
            for (String method : (Set)entry2.getValue()) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(method);
                SootMethod currentMethod = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature());
                if (currentMethod == null) {
                    logger.warn("Entry point not found: {}", (Object)method);
                    continue;
                }
                JEqExpr cond = new JEqExpr(intCounter, IntConstant.v(conditionCounter));
                ++conditionCounter;
                JNopStmt thenStmt = new JNopStmt();
                JIfStmt ifStmt = new JIfStmt((Value)cond, thenStmt);
                body.getUnits().add(ifStmt);
                this.buildMethodCall(currentMethod, body, classLocal, generator);
                body.getUnits().add(thenStmt);
            }
        }
        body.getUnits().add(endStmt);
        JGotoStmt gotoStart = new JGotoStmt(startStmt);
        body.getUnits().add(gotoStart);
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(body);
        this.eliminateSelfLoops(body);
        return mainMethod;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        return SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false).keySet();
    }
}

