/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import soot.jimple.infoflow.data.pathBuilders.ContextInsensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.ContextInsensitiveSourceFinder;
import soot.jimple.infoflow.data.pathBuilders.ContextSensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.EmptyPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.RecursivePathBuilder;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class DefaultPathBuilderFactory
implements IPathBuilderFactory {
    private final boolean reconstructPaths;
    private final PathBuilder pathBuilder;

    public DefaultPathBuilderFactory() {
        this(PathBuilder.ContextSensitive, false);
    }

    public DefaultPathBuilderFactory(PathBuilder builder, boolean reconstructPaths) {
        this.pathBuilder = builder;
        this.reconstructPaths = reconstructPaths;
    }

    @Override
    public IAbstractionPathBuilder createPathBuilder(int maxThreadNum, IInfoflowCFG icfg) {
        switch (this.pathBuilder) {
            case Recursive: {
                return new RecursivePathBuilder(icfg, maxThreadNum, this.reconstructPaths);
            }
            case ContextSensitive: {
                return new ContextSensitivePathBuilder(icfg, maxThreadNum, this.reconstructPaths);
            }
            case ContextInsensitive: {
                return new ContextInsensitivePathBuilder(icfg, maxThreadNum, this.reconstructPaths);
            }
            case ContextInsensitiveSourceFinder: {
                return new ContextInsensitiveSourceFinder(icfg, maxThreadNum);
            }
            case None: {
                return new EmptyPathBuilder();
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    @Override
    public boolean supportsPathReconstruction() {
        switch (this.pathBuilder) {
            case Recursive: 
            case ContextSensitive: 
            case ContextInsensitive: {
                return this.reconstructPaths;
            }
            case ContextInsensitiveSourceFinder: 
            case None: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    public static enum PathBuilder {
        Recursive,
        ContextSensitive,
        ContextInsensitive,
        ContextInsensitiveSourceFinder,
        None;

    }
}

