/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.jimple.Stmt;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;

public class SourceContextAndPath
extends SourceContext
implements Cloneable {
    private List<Abstraction> path = null;
    private List<Stmt> callStack = null;
    private int hashCode = 0;

    public SourceContextAndPath(AccessPath value2, Stmt stmt) {
        this(value2, stmt, null);
    }

    public SourceContextAndPath(AccessPath value2, Stmt stmt, Object userData) {
        super(value2, stmt, userData);
    }

    public List<Abstraction> getAbstractionPath() {
        return this.path == null ? Collections.emptyList() : Collections.unmodifiableList(this.path);
    }

    public List<Stmt> getPath() {
        if (this.path == null) {
            return Collections.emptyList();
        }
        ArrayList<Stmt> stmtPath = new ArrayList<Stmt>(this.path.size());
        for (Abstraction abs : this.path) {
            if (abs.getCurrentStmt() == null) continue;
            stmtPath.add(abs.getCurrentStmt());
        }
        return stmtPath;
    }

    public SourceContextAndPath extendPath(Abstraction abs) {
        return this.extendPath(abs, true);
    }

    public SourceContextAndPath extendPath(Abstraction abs, boolean trackPath) {
        if (abs == null) {
            return this;
        }
        if (abs.getCurrentStmt() == null && abs.getCorrespondingCallSite() == null) {
            return this;
        }
        if (abs.getCorrespondingCallSite() == null && !trackPath) {
            return this;
        }
        if (this.path != null) {
            for (Abstraction a2 : this.path) {
                if (a2 != abs) continue;
                return null;
            }
        }
        SourceContextAndPath scap = this.clone();
        if (trackPath && abs.getCurrentStmt() != null) {
            if (scap.path == null) {
                scap.path = new ArrayList<Abstraction>();
            }
            scap.path.add(0, abs);
        }
        if (abs.getCorrespondingCallSite() != null && abs.getCorrespondingCallSite() != abs.getCurrentStmt()) {
            if (scap.callStack == null) {
                scap.callStack = new ArrayList<Stmt>();
            }
            scap.callStack.add(0, abs.getCorrespondingCallSite());
        }
        return scap;
    }

    public Pair<SourceContextAndPath, Stmt> popTopCallStackItem() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        SourceContextAndPath scap = this.clone();
        return new Pair<SourceContextAndPath, Stmt>(scap, scap.callStack.remove(0));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SourceContextAndPath scap = (SourceContextAndPath)other;
        if (this.hashCode != 0 && scap.hashCode != 0 && this.hashCode != scap.hashCode) {
            return false;
        }
        if (this.callStack == null ? scap.callStack != null : !this.callStack.equals(scap.callStack)) {
            return false;
        }
        if (!Infoflow.getPathAgnosticResults() && !this.path.equals(scap.path)) {
            return false;
        }
        return super.equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        SourceContextAndPath sourceContextAndPath = this;
        synchronized (sourceContextAndPath) {
            this.hashCode = (!Infoflow.getPathAgnosticResults() ? 31 * (this.path == null ? 0 : this.path.hashCode()) : 0) + 31 * (this.callStack == null ? 0 : this.callStack.hashCode()) + 31 * super.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public synchronized SourceContextAndPath clone() {
        SourceContextAndPath scap = new SourceContextAndPath(this.getAccessPath(), this.getStmt(), this.getUserData());
        if (this.path != null) {
            scap.path = new ArrayList<Abstraction>(this.path);
        }
        if (this.callStack != null) {
            scap.callStack = new ArrayList<Stmt>(this.callStack);
        }
        return scap;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\ton Path: " + this.path;
    }
}

