/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.cfg;

import java.util.Collections;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.VoidType;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;

public class LibraryClassPatcher {
    public void patchLibraries() {
        this.patchHandlerImplementation();
        this.patchThreadImplementation();
    }

    private void patchThreadImplementation() {
        SootClass sc = Scene.v().getSootClassUnsafe("java.lang.Thread");
        if (sc == null) {
            return;
        }
        SootMethod smRun = sc.getMethodUnsafe("void run()");
        if (smRun == null || smRun.hasActiveBody()) {
            return;
        }
        SootMethod smCons = sc.getMethodUnsafe("void <init>(java.lang.Runnable)");
        if (smCons == null || smCons.hasActiveBody()) {
            return;
        }
        SootClass runnable = Scene.v().getSootClassUnsafe("java.lang.Runnable");
        if (runnable == null) {
            return;
        }
        int fieldIdx = 0;
        SootField fldTarget = null;
        while ((fldTarget = sc.getFieldByNameUnsafe("target" + fieldIdx)) != null) {
            ++fieldIdx;
        }
        fldTarget = new SootField("target" + fieldIdx, runnable.getType());
        sc.addField(fldTarget);
        this.patchThreadConstructor(smCons, runnable, fldTarget);
        this.patchThreadRunMethod(smRun, runnable, fldTarget);
    }

    private void patchThreadRunMethod(SootMethod smRun, SootClass runnable, SootField fldTarget) {
        SootClass sc = smRun.getDeclaringClass();
        JimpleBody b = Jimple.v().newBody(smRun);
        smRun.setActiveBody(b);
        Local thisLocal = Jimple.v().newLocal("this", sc.getType());
        b.getLocals().add(thisLocal);
        b.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(sc.getType())));
        Local targetLocal = Jimple.v().newLocal("target", runnable.getType());
        b.getLocals().add(targetLocal);
        b.getUnits().add(Jimple.v().newAssignStmt(targetLocal, Jimple.v().newInstanceFieldRef(thisLocal, fldTarget.makeRef())));
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        b.getUnits().add(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(targetLocal, NullConstant.v()), retStmt));
        b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newInterfaceInvokeExpr(targetLocal, runnable.getMethod("void run()").makeRef())));
        b.getUnits().add(retStmt);
    }

    private void patchThreadConstructor(SootMethod smCons, SootClass runnable, SootField fldTarget) {
        SootClass sc = smCons.getDeclaringClass();
        JimpleBody b = Jimple.v().newBody(smCons);
        smCons.setActiveBody(b);
        Local thisLocal = Jimple.v().newLocal("this", sc.getType());
        b.getLocals().add(thisLocal);
        b.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(sc.getType())));
        Local param0Local = Jimple.v().newLocal("p0", runnable.getType());
        b.getLocals().add(param0Local);
        b.getUnits().add(Jimple.v().newIdentityStmt(param0Local, Jimple.v().newParameterRef(runnable.getType(), 0)));
        b.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, fldTarget.makeRef()), param0Local));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    private void patchHandlerImplementation() {
        SootClass sc = Scene.v().getSootClassUnsafe("android.os.Handler");
        if (sc == null) {
            return;
        }
        SootClass runnable = Scene.v().getSootClassUnsafe("java.lang.Runnable");
        if (runnable == null) {
            return;
        }
        SootMethod smPost = sc.getMethodUnsafe("boolean post(java.lang.Runnable)");
        SootMethod smPostAtFrontOfQueue = sc.getMethodUnsafe("boolean postAtFrontOfQueue(java.lang.Runnable)");
        SootMethod smPostAtTimeWithToken = sc.getMethodUnsafe("boolean postAtTime(java.lang.Runnable,java.lang.Object,long)");
        SootMethod smPostAtTime = sc.getMethodUnsafe("boolean postAtTime(java.lang.Runnable,long)");
        SootMethod smPostDelayed = sc.getMethodUnsafe("boolean postDelayed(java.lang.Runnable,long)");
        if (smPost != null && !smPost.hasActiveBody()) {
            this.patchHandlerPostBody(smPost, runnable);
        }
        if (smPostAtFrontOfQueue != null && !smPostAtFrontOfQueue.hasActiveBody()) {
            this.patchHandlerPostBody(smPostAtFrontOfQueue, runnable);
        }
        if (smPostAtTime != null && !smPostAtTime.hasActiveBody()) {
            this.patchHandlerPostBody(smPostAtTime, runnable);
        }
        if (smPostAtTimeWithToken != null && !smPostAtTimeWithToken.hasActiveBody()) {
            this.patchHandlerPostBody(smPostAtTimeWithToken, runnable);
        }
        if (smPostDelayed != null && !smPostDelayed.hasActiveBody()) {
            this.patchHandlerPostBody(smPostDelayed, runnable);
        }
    }

    private Body patchHandlerPostBody(SootMethod method, SootClass runnable) {
        SootClass sc = method.getDeclaringClass();
        JimpleBody b = Jimple.v().newBody(method);
        method.setActiveBody(b);
        Local thisLocal = Jimple.v().newLocal("this", sc.getType());
        b.getLocals().add(thisLocal);
        b.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(sc.getType())));
        Local firstParam = null;
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Local paramLocal = Jimple.v().newLocal("param" + i, method.getParameterType(i));
            b.getLocals().add(paramLocal);
            b.getUnits().add(Jimple.v().newIdentityStmt(paramLocal, Jimple.v().newParameterRef(method.getParameterType(i), i)));
            if (i != 0) continue;
            firstParam = paramLocal;
        }
        b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newInterfaceInvokeExpr(firstParam, Scene.v().makeMethodRef(runnable, "run", Collections.emptyList(), VoidType.v(), false))));
        ReturnStmt retStmt = Jimple.v().newReturnStmt(IntConstant.v(1));
        b.getUnits().add(retStmt);
        return b;
    }
}

