/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.source.data.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.android.source.data.SourceSinkDefinition;

public class PermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private Set<SourceSinkDefinition> sourceList = null;
    private Set<SourceSinkDefinition> sinkList = null;
    private Set<SourceSinkDefinition> neitherList = null;
    private static final int INITIAL_SET_SIZE = 10000;
    private List<String> data;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>\\s*(.*?)(\\s+->\\s+(.*))?$";
    private final String regexNoRet = "^<(.+):\\s*(.+)\\s*\\((.*)\\)>\\s*(.*?)?(\\s+->\\s+(.*))?$";

    public static PermissionMethodParser fromFile(String fileName) throws IOException {
        PermissionMethodParser pmp = new PermissionMethodParser();
        pmp.readFile(fileName);
        return pmp;
    }

    public static PermissionMethodParser fromStringList(List<String> data) throws IOException {
        PermissionMethodParser pmp = new PermissionMethodParser(data);
        return pmp;
    }

    private PermissionMethodParser() {
    }

    private PermissionMethodParser(List<String> data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String fileName) throws IOException {
        this.data = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                this.data.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    @Override
    public Set<SourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    @Override
    public Set<SourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    private void parse() {
        this.sourceList = new HashSet<SourceSinkDefinition>(10000);
        this.sinkList = new HashSet<SourceSinkDefinition>(10000);
        this.neitherList = new HashSet<SourceSinkDefinition>(10000);
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>\\s*(.*?)(\\s+->\\s+(.*))?$");
        Pattern pNoRet = Pattern.compile("^<(.+):\\s*(.+)\\s*\\((.*)\\)>\\s*(.*?)?(\\s+->\\s+(.*))?$");
        for (String line : this.data) {
            if (line.isEmpty() || line.startsWith("%")) continue;
            Matcher m = p.matcher(line);
            if (m.find()) {
                AndroidMethod am = this.parseMethod(m, true);
                SourceSinkDefinition singleMethod = new SourceSinkDefinition(am);
                if (am.isSource()) {
                    this.sourceList.add(singleMethod);
                    continue;
                }
                if (am.isSink()) {
                    this.sinkList.add(singleMethod);
                    continue;
                }
                if (!am.isNeitherNor()) continue;
                this.neitherList.add(singleMethod);
                continue;
            }
            Matcher mNoRet = pNoRet.matcher(line);
            if (mNoRet.find()) {
                AndroidMethod am = this.parseMethod(mNoRet, true);
                SourceSinkDefinition singleMethod = new SourceSinkDefinition(am);
                if (am.isSource()) {
                    this.sourceList.add(singleMethod);
                    continue;
                }
                if (am.isSink()) {
                    this.sinkList.add(singleMethod);
                    continue;
                }
                if (!am.isNeitherNor()) continue;
                this.neitherList.add(singleMethod);
                continue;
            }
            System.err.println("Line does not match: " + line);
        }
    }

    private AndroidMethod parseMethod(Matcher m, boolean hasReturnType) {
        String params;
        assert (m.group(1) != null && m.group(2) != null && m.group(3) != null && m.group(4) != null);
        int groupIdx = 1;
        String className = m.group(groupIdx++).trim();
        String returnType = "";
        if (hasReturnType) {
            returnType = m.group(groupIdx++).trim();
        }
        String methodName = m.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        String classData = "";
        String permData = "";
        HashSet<String> permissions = new HashSet<String>();
        if (groupIdx < m.groupCount() && m.group(groupIdx) != null) {
            permData = m.group(groupIdx);
            if (permData.contains("->")) {
                classData = permData.replace("->", "").trim();
                permData = "";
            }
            ++groupIdx;
        }
        if (!permData.isEmpty()) {
            for (String permission : permData.split(" ")) {
                permissions.add(permission);
            }
        }
        AndroidMethod singleMethod = new AndroidMethod(methodName, methodParameters, returnType, className, permissions);
        if (classData.isEmpty() && m.group(groupIdx) != null) {
            classData = m.group(groupIdx).replace("->", "").trim();
            ++groupIdx;
        }
        if (!classData.isEmpty()) {
            for (String target : classData.split("\\s")) {
                if ((target = target.trim()).contains("|")) {
                    target = target.substring(target.indexOf(124));
                }
                if (target.isEmpty() || target.startsWith("|")) continue;
                if (target.equals("_SOURCE_")) {
                    singleMethod.setSource(true);
                    continue;
                }
                if (target.equals("_SINK_")) {
                    singleMethod.setSink(true);
                    continue;
                }
                if (target.equals("_NONE_")) {
                    singleMethod.setNeitherNor(true);
                    continue;
                }
                throw new RuntimeException("error in target definition: " + target);
            }
        }
        return singleMethod;
    }

    @Override
    public Set<SourceSinkDefinition> getAllMethods() {
        HashSet<SourceSinkDefinition> sourcesSinks = new HashSet<SourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

