/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class AndroidMethod
extends SootMethodAndClass {
    private final Set<String> permissions;
    private boolean isSource = false;
    private boolean isSink = false;
    private boolean isNeitherNor = false;
    private CATEGORY category = null;

    public AndroidMethod(String methodName, String returnType, String className) {
        super(methodName, className, returnType, new ArrayList<String>());
        this.permissions = Collections.emptySet();
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className) {
        super(methodName, className, returnType, parameters);
        this.permissions = Collections.emptySet();
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className, Set<String> permissions) {
        super(methodName, className, returnType, parameters);
        this.permissions = permissions;
    }

    public AndroidMethod(SootMethod sm) {
        super(sm);
        this.permissions = Collections.emptySet();
    }

    public AndroidMethod(SootMethodAndClass methodAndClass) {
        super(methodAndClass);
        this.permissions = Collections.emptySet();
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public boolean isSink() {
        return this.isSink;
    }

    public void setSink(boolean isSink) {
        this.isSink = isSink;
    }

    public boolean isNeitherNor() {
        return this.isNeitherNor;
    }

    public void setNeitherNor(boolean isNeitherNor) {
        this.isNeitherNor = isNeitherNor;
    }

    public void setCategory(CATEGORY category) {
        this.category = category;
    }

    public CATEGORY getCategory() {
        return this.category;
    }

    @Override
    public String toString() {
        String s2 = this.getSignature();
        for (String perm : this.permissions) {
            s2 = s2 + " " + perm;
        }
        if (this.isSource || this.isSink || this.isNeitherNor) {
            s2 = s2 + " ->";
        }
        if (this.isSource) {
            s2 = s2 + " _SOURCE_";
        }
        if (this.isSink) {
            s2 = s2 + " _SINK_ ";
        }
        if (this.isNeitherNor) {
            s2 = s2 + " _NONE_";
        }
        if (this.category != null) {
            s2 = s2 + "|" + (Object)((Object)this.category);
        }
        return s2;
    }

    public String getSignatureAndPermissions() {
        String s2 = this.getSignature();
        for (String perm : this.permissions) {
            s2 = s2 + " " + perm;
        }
        return s2;
    }

    public boolean isAnnotated() {
        return this.isSource || this.isSink || this.isNeitherNor;
    }

    public static AndroidMethod createFromSignature(String signature) {
        if (!signature.startsWith("<")) {
            signature = "<" + signature;
        }
        if (!signature.endsWith(">")) {
            signature = signature + ">";
        }
        SootMethodAndClass smac = SootMethodRepresentationParser.v().parseSootMethodString(signature);
        return new AndroidMethod(smac.getMethodName(), smac.getParameters(), smac.getReturnType(), smac.getClassName());
    }

    public static enum CATEGORY {
        ALL,
        NO_CATEGORY,
        HARDWARE_INFO,
        UNIQUE_IDENTIFIER,
        LOCATION_INFORMATION,
        NETWORK_INFORMATION,
        ACCOUNT_INFORMATION,
        EMAIL_INFORMATION,
        FILE_INFORMATION,
        BLUETOOTH_INFORMATION,
        VOIP_INFORMATION,
        DATABASE_INFORMATION,
        PHONE_INFORMATION,
        PHONE_CONNECTION,
        INTER_APP_COMMUNICATION,
        VOIP,
        PHONE_STATE,
        EMAIL,
        BLUETOOTH,
        ACCOUNT_SETTINGS,
        VIDEO,
        SYNCHRONIZATION_DATA,
        NETWORK,
        EMAIL_SETTINGS,
        FILE,
        LOG,
        AUDIO,
        SMS_MMS,
        CONTACT_INFORMATION,
        CALENDAR_INFORMATION,
        SYSTEM_SETTINGS,
        IMAGE,
        BROWSER_INFORMATION,
        NFC;

    }
}

