/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.k33nteam.JadeCfg;
import soot.Body;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.HashMultiMap;
import soot.util.queue.QueueReader;

public class AnalyzeJimpleClass {
    private final Set<String> entryPointClasses;
    private final Set<String> androidCallbacks;
    private final Map<String, Set<SootMethodAndClass>> callbackMethods = new HashMap<String, Set<SootMethodAndClass>>();
    private final Map<String, Set<SootMethodAndClass>> callbackWorklist = new HashMap<String, Set<SootMethodAndClass>>();
    private final Map<String, Set<Integer>> layoutClasses = new HashMap<String, Set<Integer>>();
    private final Set<String> dynamicManifestComponents = new HashSet<String>();

    public AnalyzeJimpleClass(Set<String> entryPointClasses) throws IOException {
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = this.loadAndroidCallbacks();
    }

    public AnalyzeJimpleClass(Set<String> entryPointClasses, Set<String> androidCallbacks) {
        this.entryPointClasses = entryPointClasses;
        this.androidCallbacks = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadAndroidCallbacks() throws IOException {
        HashSet<String> androidCallbacks = new HashSet<String>();
        try (BufferedReader rdr = null;){
            String line;
            String fileName = JadeCfg.getCallback_file();
            if (!new File(fileName).exists() && !new File(fileName = "../soot-infoflow-android/AndroidCallbacks.txt").exists()) {
                throw new RuntimeException("Callback definition file not found");
            }
            rdr = new BufferedReader(new FileReader(fileName));
            while ((line = rdr.readLine()) != null) {
                if (line.isEmpty()) continue;
                androidCallbacks.add(line);
            }
        }
        return androidCallbacks;
    }

    public void collectCallbackMethods() {
        Transform transform2 = new Transform("wjtp.ajc", new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                AnalyzeJimpleClass.this.findClassLayoutMappings();
                for (String className : AnalyzeJimpleClass.this.entryPointClasses) {
                    SootClass sc = Scene.v().getSootClass(className);
                    ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
                    methods.addAll(sc.getMethods());
                    AnalyzeJimpleClass.this.analyzeRechableMethods(sc, methods);
                    AnalyzeJimpleClass.this.analyzeMethodOverrideCallbacks(sc);
                }
                System.out.println("Callback analysis done.");
            }
        });
        PackManager.v().getPack("wjtp").add(transform2);
    }

    public void collectCallbackMethodsIncremental() {
        Transform transform2 = new Transform("wjtp.ajc", new SceneTransformer(){

            protected void internalTransform(String phaseName, Map options) {
                System.out.println("Running incremental callback analysis for " + AnalyzeJimpleClass.this.callbackWorklist.size() + " components...");
                HashMultiMap workListCopy = new HashMultiMap(AnalyzeJimpleClass.this.callbackWorklist);
                for (String className : workListCopy.keySet()) {
                    LinkedList<SootMethod> entryClasses = new LinkedList<SootMethod>();
                    for (SootMethodAndClass am : workListCopy.get(className)) {
                        entryClasses.add(Scene.v().getMethod(am.getSignature()));
                    }
                    AnalyzeJimpleClass.this.analyzeRechableMethods(Scene.v().getSootClass(className), entryClasses);
                    AnalyzeJimpleClass.this.callbackWorklist.remove(className);
                }
                System.out.println("Incremental callback analysis done.");
            }
        });
        PackManager.v().getPack("wjtp").add(transform2);
    }

    private void analyzeRechableMethods(SootClass lifecycleElement, List<MethodOrMethodContext> methods) {
        ReachableMethods rm = new ReachableMethods(Scene.v().getCallGraph(), methods);
        rm.update();
        QueueReader<MethodOrMethodContext> reachableMethods = rm.listener();
        while (reachableMethods.hasNext()) {
            SootMethod method = ((MethodOrMethodContext)reachableMethods.next()).method();
            this.analyzeMethodForCallbackRegistrations(lifecycleElement, method);
            this.analyzeMethodForDynamicBroadcastReceiver(method);
        }
    }

    private void analyzeMethodForCallbackRegistrations(SootClass lifecycleElement, SootMethod method) {
        if (method.getDeclaringClass().getName().startsWith("android.") || method.getDeclaringClass().getName().startsWith("java.")) {
            return;
        }
        if (!method.isConcrete()) {
            return;
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(method.retrieveActiveBody());
        SmartLocalDefs smd = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        HashSet<SootClass> callbackClasses = new HashSet<SootClass>();
        for (Unit u : method.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)stmt.getInvokeExpr();
            String[] parameters = SootMethodRepresentationParser.v().getParameterTypesFromSubSignature(iinv.getMethodRef().getSubSignature().getString());
            for (int i = 0; i < parameters.length; ++i) {
                Value arg;
                String param2 = parameters[i];
                if (!this.androidCallbacks.contains(param2) || !((arg = iinv.getArg(i)).getType() instanceof RefType) || !(arg instanceof Local)) continue;
                for (Unit def : smd.getDefsOfAt((Local)arg, u)) {
                    assert (def instanceof DefinitionStmt);
                    Type tp = ((DefinitionStmt)def).getRightOp().getType();
                    if (!(tp instanceof RefType)) continue;
                    SootClass callbackClass = ((RefType)tp).getSootClass();
                    if (callbackClass.isInterface()) {
                        for (SootClass impl : Scene.v().getActiveHierarchy().getImplementersOf(callbackClass)) {
                            for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(impl)) {
                                callbackClasses.add(c);
                            }
                        }
                        continue;
                    }
                    for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(callbackClass)) {
                        callbackClasses.add(c);
                    }
                }
            }
        }
        for (SootClass callbackClass : callbackClasses) {
            this.analyzeClass(callbackClass, lifecycleElement);
        }
    }

    private void analyzeMethodForDynamicBroadcastReceiver(SootMethod method) {
        if (!method.isConcrete() || !method.hasActiveBody()) {
            return;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            Value br;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !stmt.getInvokeExpr().getMethod().getName().equals("registerReceiver") || stmt.getInvokeExpr().getArgCount() <= 0 || !this.isInheritedMethod(stmt, "android.content.ContextWrapper", "android.content.Context") || !((br = stmt.getInvokeExpr().getArg(0)).getType() instanceof RefType)) continue;
            RefType rt = (RefType)br.getType();
            this.dynamicManifestComponents.add(rt.getClassName());
        }
    }

    private boolean isInheritedMethod(Stmt stmt, String ... classNames) {
        Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(stmt);
        while (edgeIt.hasNext()) {
            Edge edge = edgeIt.next();
            String targetClass = edge.getTgt().method().getDeclaringClass().getName();
            for (String className : classNames) {
                if (!className.equals(targetClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void findClassLayoutMappings() {
        QueueReader<MethodOrMethodContext> rmIterator = Scene.v().getReachableMethods().listener();
        while (rmIterator.hasNext()) {
            SootMethod sm = ((MethodOrMethodContext)rmIterator.next()).method();
            if (!sm.isConcrete()) continue;
            for (Unit u : sm.retrieveActiveBody().getUnits()) {
                InvokeExpr inv;
                Stmt stmt;
                if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !this.invokesSetContentView(inv = stmt.getInvokeExpr())) continue;
                for (Value val : inv.getArgs()) {
                    if (!(val instanceof IntConstant)) continue;
                    IntConstant constVal = (IntConstant)val;
                    Set<Integer> layoutIDs = this.layoutClasses.get(sm.getDeclaringClass().getName());
                    if (layoutIDs == null) {
                        layoutIDs = new HashSet<Integer>();
                        this.layoutClasses.put(sm.getDeclaringClass().getName(), layoutIDs);
                    }
                    layoutIDs.add(constVal.value);
                }
            }
        }
    }

    private boolean invokesSetContentView(InvokeExpr inv) {
        String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(inv.getMethodRef().getSubSignature().getString());
        if (!methodName.equals("setContentView")) {
            return false;
        }
        SootClass curClass = inv.getMethod().getDeclaringClass();
        while (curClass != null) {
            if (curClass.getName().equals("android.app.Activity") || curClass.getName().equals("android.support.v7.app.ActionBarActivity")) {
                return true;
            }
            if (curClass.declaresMethod("void setContentView(int)")) {
                return false;
            }
            curClass = curClass.hasSuperclass() ? curClass.getSuperclass() : null;
        }
        return false;
    }

    private void analyzeClass(SootClass sootClass, SootClass lifecycleElement) {
        if (sootClass.getName().startsWith("android.") || sootClass.getName().startsWith("java.")) {
            return;
        }
        this.analyzeClassInterfaceCallbacks(sootClass, sootClass, lifecycleElement);
    }

    private void analyzeMethodOverrideCallbacks(SootClass sootClass) {
        if (!sootClass.isConcrete()) {
            return;
        }
        if (sootClass.isInterface()) {
            return;
        }
        if (sootClass.getName().startsWith("android.")) {
            return;
        }
        HashSet<String> systemMethods = new HashSet<String>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sootClass)) {
            if (!parentClass.getName().startsWith("android.")) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.add(sm.getSubSignature());
            }
        }
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSubclassesOfIncluding(sootClass)) {
            if (parentClass.getName().startsWith("android.")) continue;
            for (SootMethod method : parentClass.getMethods()) {
                if (!systemMethods.contains(method.getSubSignature())) continue;
                this.checkAndAddMethod(method, sootClass);
            }
        }
    }

    private SootMethod getMethodFromHierarchyEx(SootClass c, String methodSignature) {
        if (c.declaresMethod(methodSignature)) {
            return c.getMethod(methodSignature);
        }
        if (c.hasSuperclass()) {
            return this.getMethodFromHierarchyEx(c.getSuperclass(), methodSignature);
        }
        throw new RuntimeException("Could not find method");
    }

    private void analyzeClassInterfaceCallbacks(SootClass baseClass, SootClass sootClass, SootClass lifecycleElement) {
        if (!baseClass.isConcrete()) {
            return;
        }
        if (baseClass.getName().startsWith("android.")) {
            return;
        }
        if (sootClass.hasSuperclass()) {
            this.analyzeClassInterfaceCallbacks(baseClass, sootClass.getSuperclass(), lifecycleElement);
        }
        for (SootClass i : this.collectAllInterfaces(sootClass)) {
            if (!this.androidCallbacks.contains(i.getName())) continue;
            for (SootMethod sm : i.getMethods()) {
                this.checkAndAddMethod(this.getMethodFromHierarchyEx(baseClass, sm.getSubSignature()), lifecycleElement);
            }
        }
    }

    private void checkAndAddMethod(SootMethod method, SootClass baseClass) {
        HashSet<AndroidMethod> methods;
        boolean isNew;
        AndroidMethod am = new AndroidMethod(method);
        if (am.getClassName().startsWith("android.") || am.getClassName().startsWith("java.")) {
            return;
        }
        if (method.isConcrete() && this.isEmpty(method.retrieveActiveBody())) {
            return;
        }
        if (this.callbackMethods.containsKey(baseClass.getName())) {
            isNew = this.callbackMethods.get(baseClass.getName()).add(am);
        } else {
            methods = new HashSet<AndroidMethod>();
            isNew = methods.add(am);
            this.callbackMethods.put(baseClass.getName(), methods);
        }
        if (isNew) {
            if (this.callbackWorklist.containsKey(baseClass.getName())) {
                this.callbackWorklist.get(baseClass.getName()).add(am);
            } else {
                methods = new HashSet();
                isNew = methods.add(am);
                this.callbackWorklist.put(baseClass.getName(), methods);
            }
        }
    }

    private boolean isEmpty(Body activeBody) {
        for (Unit u : activeBody.getUnits()) {
            if (u instanceof IdentityStmt || u instanceof ReturnVoidStmt) continue;
            return false;
        }
        return true;
    }

    private Set<SootClass> collectAllInterfaces(SootClass sootClass) {
        HashSet<SootClass> interfaces = new HashSet<SootClass>(sootClass.getInterfaces());
        for (SootClass i : sootClass.getInterfaces()) {
            interfaces.addAll(this.collectAllInterfaces(i));
        }
        return interfaces;
    }

    public Map<String, Set<SootMethodAndClass>> getCallbackMethods() {
        return this.callbackMethods;
    }

    public Map<String, Set<Integer>> getLayoutClasses() {
        return this.layoutClasses;
    }

    public Set<String> getDynamicManifestComponents() {
        return this.dynamicManifestComponents;
    }
}

