/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.PopInst;
import soot.baf.ThrowInst;
import soot.baf.VirtualInvokeInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.NullConstant;

public class IfNullToTryCatch
extends BodyTransformer
implements IJbcoTransform {
    int count = 0;
    int totalifs = 0;
    public static String[] dependancies = new String[]{"bb.jbco_riitcb", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_riitcb";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("If(Non)Nulls changed to traps: " + this.count);
        out.println("Total ifs found: " + this.totalifs);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        SootClass exc = G.v().soot_Scene().getSootClass("java.lang.NullPointerException");
        SootClass obj = G.v().soot_Scene().getSootClass("java.lang.Object");
        SootMethod toStrg = obj.getMethodByName("toString");
        SootMethod eq2 = obj.getMethodByName("equals");
        boolean change = false;
        PatchingChain<Unit> units = b.getUnits();
        Iterator<Unit> uit = units.snapshotIterator();
        while (uit.hasNext()) {
            PopInst pop;
            Unit targ;
            Unit u = uit.next();
            if (BodyBuilder.isBafIf(u)) {
                ++this.totalifs;
            }
            if (u instanceof IfNullInst && Rand.getInt(10) <= weight) {
                targ = ((IfNullInst)u).getTarget();
                Unit succ = units.getSuccOf(u);
                pop = Baf.v().newPopInst(RefType.v());
                Unit popClone = (Unit)pop.clone();
                units.insertBefore(pop, targ);
                GotoInst gotoTarg = Baf.v().newGotoInst(targ);
                units.insertBefore(gotoTarg, (Unit)pop);
                if (Rand.getInt(2) == 0) {
                    VirtualInvokeInst methCall = Baf.v().newVirtualInvokeInst(toStrg.makeRef());
                    units.insertBefore(methCall, u);
                    if (Rand.getInt(2) == 0) {
                        units.remove(u);
                        units.insertAfter(popClone, (Unit)methCall);
                    }
                    b.getTraps().add(Baf.v().newTrap(exc, methCall, succ, pop));
                } else {
                    ThrowInst throwu = Baf.v().newThrowInst();
                    units.insertBefore(throwu, u);
                    units.remove(u);
                    units.insertBefore(Baf.v().newPushInst(NullConstant.v()), (Unit)throwu);
                    IfCmpNeInst ifunit = Baf.v().newIfCmpNeInst(RefType.v(), succ);
                    units.insertBefore(ifunit, (Unit)throwu);
                    units.insertBefore(Baf.v().newPushInst(NullConstant.v()), (Unit)throwu);
                    b.getTraps().add(Baf.v().newTrap(exc, throwu, succ, pop));
                }
                ++this.count;
                change = true;
                continue;
            }
            if (!(u instanceof IfNonNullInst) || Rand.getInt(10) > weight) continue;
            targ = ((IfNonNullInst)u).getTarget();
            VirtualInvokeInst methCall = Baf.v().newVirtualInvokeInst(eq2.makeRef());
            units.insertBefore(methCall, u);
            units.insertBefore(Baf.v().newPushInst(NullConstant.v()), (Unit)methCall);
            if (Rand.getInt(2) == 0) {
                pop = Baf.v().newPopInst(BooleanType.v());
                units.insertBefore(pop, u);
                GotoInst gotoTarg = Baf.v().newGotoInst(targ);
                units.insertBefore(gotoTarg, u);
                pop = Baf.v().newPopInst(RefType.v());
                units.insertAfter(pop, u);
                units.remove(u);
                b.getTraps().addFirst(Baf.v().newTrap(exc, methCall, gotoTarg, pop));
            } else {
                IfEqInst iffalse = Baf.v().newIfEqInst(targ);
                units.insertBefore(iffalse, u);
                units.insertBefore(Baf.v().newPushInst(NullConstant.v()), u);
                PopInst pop2 = Baf.v().newPopInst(RefType.v());
                units.insertAfter(pop2, u);
                units.remove(u);
                b.getTraps().addFirst(Baf.v().newTrap(exc, methCall, iffalse, pop2));
            }
            ++this.count;
            change = true;
        }
        if (change && debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }
}

