/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.baf.Baf;
import soot.baf.IfNullInst;
import soot.baf.LoadInst;
import soot.baf.PopInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.ThrowInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jbco.util.ThrowSet;
import soot.jimple.NullConstant;

public class ConstructorConfuser
extends BodyTransformer
implements IJbcoTransform {
    static int count = 0;
    static int[] instances = new int[4];
    public static String[] dependancies = new String[]{"bb.jbco_dcc", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_dcc";

    @Override
    public String[] getDependancies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Constructor methods have been jumbled: " + count);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (!b.getMethod().getSubSignature().equals("void <init>()")) {
            return;
        }
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        SootClass origClass = b.getMethod().getDeclaringClass();
        SootClass c = origClass;
        c = c.hasSuperclass() ? c.getSuperclass() : null;
        PatchingChain<Unit> units = b.getUnits();
        Iterator<Unit> it = units.snapshotIterator();
        Unit prev = null;
        SpecialInvokeInst sii = null;
        while (it.hasNext()) {
            Unit u = it.next();
            if (u instanceof SpecialInvokeInst) {
                sii = (SpecialInvokeInst)u;
                SootMethodRef smr = sii.getMethodRef();
                if (c != null && smr.declaringClass().getName().equals(c.getName()) && smr.name().equals("<init>")) break;
                sii = null;
            }
            prev = u;
        }
        if (sii == null) {
            return;
        }
        int lowi = -1;
        int lowest = 99999999;
        int rand = Rand.getInt(4);
        for (int i = 0; i < instances.length; ++i) {
            if (lowest <= instances[i]) continue;
            lowest = instances[i];
            lowi = i;
        }
        if (instances[rand] > instances[lowi]) {
            rand = lowi;
        }
        boolean done2 = false;
        switch (rand) {
            case 0: {
                if (prev != null && prev instanceof LoadInst && sii.getMethodRef().parameterTypes().size() == 0 && !BodyBuilder.isExceptionCaughtAt(units, sii, b.getTraps().iterator())) {
                    Type t;
                    Local bl = ((LoadInst)prev).getLocal();
                    Map<Local, Local> locals = Main.methods2Baf2JLocals.get(b.getMethod());
                    if (locals != null && locals.containsKey(bl) && (t = locals.get(bl).getType()) instanceof RefType && ((RefType)t).getSootClass().getName().equals(origClass.getName())) {
                        units.insertBefore(Baf.v().newDup1Inst(RefType.v()), (Unit)sii);
                        IfNullInst ifinst = Baf.v().newIfNullInst(sii);
                        units.insertBeforeNoRedirect(ifinst, sii);
                        units.insertAfter(Baf.v().newThrowInst(), (Unit)ifinst);
                        units.insertAfter(Baf.v().newPushInst(NullConstant.v()), (Unit)ifinst);
                        Unit pop = Baf.v().newPopInst(RefType.v());
                        units.add(pop);
                        units.add((Unit)prev.clone());
                        b.getTraps().add(Baf.v().newTrap(ThrowSet.getRandomThrowable(), ifinst, sii, pop));
                        if (Rand.getInt() % 2 == 0) {
                            pop = (Unit)pop.clone();
                            units.insertBefore(pop, (Unit)sii);
                            units.insertBefore(Baf.v().newGotoInst(sii), pop);
                            units.add(Baf.v().newJSRInst(pop));
                        } else {
                            units.add(Baf.v().newGotoInst(sii));
                        }
                        done2 = true;
                        break;
                    }
                }
            }
            case 1: {
                if (!BodyBuilder.isExceptionCaughtAt(units, sii, b.getTraps().iterator())) {
                    ThrowInst handler = Baf.v().newThrowInst();
                    units.add(handler);
                    b.getTraps().add(Baf.v().newTrap(ThrowSet.getRandomThrowable(), sii, units.getSuccOf(sii), handler));
                    done2 = true;
                    break;
                }
            }
            case 2: {
                if (sii.getMethodRef().parameterTypes().size() == 0 && !BodyBuilder.isExceptionCaughtAt(units, sii, b.getTraps().iterator())) {
                    while (c != null) {
                        if (c.getName().equals("java.lang.Throwable")) {
                            ThrowInst throwThis = Baf.v().newThrowInst();
                            units.insertBefore(throwThis, (Unit)sii);
                            b.getTraps().add(Baf.v().newTrap(origClass, throwThis, sii, sii));
                            done2 = true;
                            break;
                        }
                        if (c.hasSuperclass()) {
                            c = c.getSuperclass();
                            continue;
                        }
                        c = null;
                    }
                }
                if (done2) break;
            }
            case 3: {
                PopInst pop = Baf.v().newPopInst(RefType.v());
                units.insertBefore(pop, (Unit)sii);
                units.insertBeforeNoRedirect(Baf.v().newJSRInst(pop), pop);
                done2 = true;
            }
        }
        if (done2) {
            int n = rand;
            instances[n] = instances[n] + 1;
            ++count;
        }
        if (debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }
}

