/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import soot.Local;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;

public class UnopInstruction
extends DexlibAbstractInstruction {
    AssignStmt assign = null;

    public UnopInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    public void jimplify(DexBody body) {
        if (!(this.instruction instanceof Instruction12x)) {
            throw new IllegalArgumentException("Expected Instruction12x but got: " + this.instruction.getClass());
        }
        Instruction12x cmpInstr = (Instruction12x)this.instruction;
        int dest = cmpInstr.getRegisterA();
        Local source = body.getRegisterLocal(cmpInstr.getRegisterB());
        Value expr = this.getExpression(source);
        this.assign = Jimple.v().newAssignStmt(body.getRegisterLocal(dest), expr);
        this.setUnit(this.assign);
        this.addTags(this.assign);
        body.add(this.assign);
    }

    private Value getExpression(Local source) {
        Opcode opcode = this.instruction.getOpcode();
        switch (opcode) {
            case NEG_INT: 
            case NEG_LONG: 
            case NEG_FLOAT: 
            case NEG_DOUBLE: {
                return Jimple.v().newNegExpr(source);
            }
            case NOT_LONG: {
                return this.getNotLongExpr(source);
            }
            case NOT_INT: {
                return this.getNotIntExpr(source);
            }
        }
        throw new RuntimeException("Invalid Opcode: " + (Object)((Object)opcode));
    }

    private Value getNotIntExpr(Local source) {
        return Jimple.v().newXorExpr(source, IntConstant.v(-1));
    }

    private Value getNotLongExpr(Local source) {
        return Jimple.v().newXorExpr(source, LongConstant.v(-1L));
    }

    @Override
    boolean overridesRegister(int register2) {
        TwoRegisterInstruction i = (TwoRegisterInstruction)this.instruction;
        int dest = i.getRegisterA();
        return register2 == dest;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register2) {
        int source = ((TwoRegisterInstruction)this.instruction).getRegisterB();
        Opcode opcode = this.instruction.getOpcode();
        switch (opcode) {
            case NEG_FLOAT: 
            case NEG_DOUBLE: {
                return source == register2;
            }
        }
        return false;
    }
}

