/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.reference.MethodReference;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.MoveResultInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;

public abstract class MethodInvocationInstruction
extends DexlibAbstractInstruction
implements DanglingInstruction {
    protected InvokeExpr invocation;
    protected AssignStmt assign = null;
    private SootMethodRef methodRef = null;

    public MethodInvocationInstruction(Instruction instruction, int codeAddress) {
        super(instruction, codeAddress);
    }

    @Override
    public void finalize(DexBody body, DexlibAbstractInstruction successor) {
        if (successor instanceof MoveResultInstruction) {
            this.assign = Jimple.v().newAssignStmt(body.getStoreResultLocal(), this.invocation);
            this.setUnit(this.assign);
            this.addTags(this.assign);
            body.add(this.assign);
            this.unit = this.assign;
        } else {
            InvokeStmt invoke = Jimple.v().newInvokeStmt(this.invocation);
            this.setUnit(invoke);
            this.addTags(invoke);
            body.add(invoke);
            this.unit = invoke;
        }
    }

    @Override
    public Set<Type> introducedTypes() {
        HashSet<Type> types = new HashSet<Type>();
        MethodReference method = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        types.add(DexType.toSoot(method.getDefiningClass()));
        types.add(DexType.toSoot(method.getReturnType()));
        List<? extends CharSequence> paramTypes = method.getParameterTypes();
        if (paramTypes != null) {
            for (CharSequence charSequence : paramTypes) {
                types.add(DexType.toSoot(charSequence.toString()));
            }
        }
        return types;
    }

    @Override
    boolean isUsedAsFloatingPoint(DexBody body, int register2) {
        return this.isUsedAsFloatingPoint(body, register2, false);
    }

    protected boolean isUsedAsFloatingPoint(DexBody body, int register2, boolean isStatic) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List<? extends CharSequence> paramTypes = item.getParameterTypes();
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register2 && Util.isFloatLike(DexType.toSoot(paramTypes.get(j).toString()))) {
                    return true;
                }
                if (DexType.isWide(paramTypes.get(j).toString())) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected boolean isUsedAsObject(DexBody body, int register2, boolean isStatic) {
        MethodReference item = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        List<? extends CharSequence> paramTypes = item.getParameterTypes();
        List<Integer> regs = this.getUsedRegistersNums();
        if (paramTypes == null) {
            return false;
        }
        if (!isStatic && regs.get(0) == register2) {
            return true;
        }
        int i = 0;
        int j = 0;
        while (i < regs.size()) {
            if (!isStatic && i == 0) {
                --j;
            } else {
                if (regs.get(i) == register2 && DexType.toSoot(paramTypes.get(j).toString()) instanceof RefType) {
                    return true;
                }
                if (DexType.isWide(paramTypes.get(j).toString())) {
                    ++i;
                }
            }
            ++i;
            ++j;
        }
        return false;
    }

    protected SootMethodRef getSootMethodRef() {
        return this.getSootMethodRef(InvocationType.Virtual);
    }

    protected SootMethodRef getStaticSootMethodRef() {
        return this.getSootMethodRef(InvocationType.Static);
    }

    private SootMethodRef getSootMethodRef(InvocationType invType) {
        String tItem;
        if (this.methodRef != null) {
            return this.methodRef;
        }
        MethodReference mItem = (MethodReference)((ReferenceInstruction)this.instruction).getReference();
        String className = tItem = mItem.getDefiningClass();
        Debug.printDbg("tItem: ", tItem, " class name: ", className);
        className = className.startsWith("[") ? "java.lang.Object" : Util.dottedClassName(tItem);
        SootClass sc = SootResolver.v().makeClassRef(className);
        if (invType == InvocationType.Interface && sc.isPhantom()) {
            sc.setModifiers(sc.getModifiers() | 0x200);
        }
        String methodName = mItem.getName();
        Type returnType = DexType.toSoot(mItem.getReturnType());
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        List<? extends CharSequence> paramTypes = mItem.getParameterTypes();
        if (paramTypes != null) {
            for (CharSequence charSequence : paramTypes) {
                parameterTypes.add(DexType.toSoot(charSequence.toString()));
            }
        }
        Debug.printDbg("sc: ", sc);
        Debug.printDbg("methodName: ", methodName);
        Debug.printDbg("parameterTypes: ", new Object[0]);
        for (Type type : parameterTypes) {
            Debug.printDbg(" t: ", type);
        }
        Debug.printDbg("returnType: ", returnType);
        Debug.printDbg("isStatic: ", invType == InvocationType.Static);
        this.methodRef = Scene.v().makeMethodRef(sc, methodName, parameterTypes, returnType, invType == InvocationType.Static);
        return this.methodRef;
    }

    protected MethodReference getTargetMethodReference() {
        return (MethodReference)((ReferenceInstruction)this.instruction).getReference();
    }

    /*
     * WARNING - void declaration
     */
    protected List<Local> buildParameters(DexBody body, boolean isStatic) {
        MethodReference item = this.getTargetMethodReference();
        List<? extends CharSequence> paramTypes = item.getParameterTypes();
        ArrayList<Local> parameters = new ArrayList<Local>();
        List<Integer> regs = this.getUsedRegistersNums();
        Debug.printDbg(" [methodIdItem]: ", item);
        Debug.printDbg(" params types:", new Object[0]);
        if (paramTypes != null) {
            for (CharSequence charSequence : paramTypes) {
                Debug.printDbg(" t: ", charSequence);
            }
        }
        Debug.printDbg(" used registers (", regs.size(), "): ");
        Iterator<Object> iterator2 = regs.iterator();
        while (iterator2.hasNext()) {
            int n = (Integer)iterator2.next();
            Debug.printDbg(" r: ", n);
        }
        int i = 0;
        boolean bl = false;
        while (i < regs.size()) {
            void var8_12;
            parameters.add(body.getRegisterLocal(regs.get(i)));
            if (!isStatic && i == 0) {
                --var8_12;
            } else if (paramTypes != null && DexType.isWide(paramTypes.get((int)var8_12).toString())) {
                ++i;
            }
            ++i;
            ++var8_12;
        }
        return parameters;
    }

    protected List<Integer> getUsedRegistersNums() {
        if (this.instruction instanceof Instruction35c) {
            return this.getUsedRegistersNums((Instruction35c)this.instruction);
        }
        if (this.instruction instanceof Instruction3rc) {
            return this.getUsedRegistersNums((Instruction3rc)this.instruction);
        }
        throw new RuntimeException("Instruction is neither a InvokeInstruction nor a InvokeRangeInstruction");
    }

    protected void jimplifyVirtual(DexBody body) {
        SootMethodRef ref = this.getSootMethodRef();
        if (ref.declaringClass().isInterface()) {
            this.methodRef = null;
            this.jimplifyInterface(body);
            return;
        }
        List<Local> parameters = this.buildParameters(body, false);
        this.invocation = Jimple.v().newVirtualInvokeExpr(parameters.get(0), ref, parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifyInterface(DexBody body) {
        SootMethodRef ref = this.getSootMethodRef(InvocationType.Interface);
        if (!ref.declaringClass().isInterface()) {
            this.jimplifyVirtual(body);
            return;
        }
        List<Local> parameters = this.buildParameters(body, false);
        this.invocation = Jimple.v().newInterfaceInvokeExpr(parameters.get(0), this.getSootMethodRef(InvocationType.Interface), parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifySpecial(DexBody body) {
        List<Local> parameters = this.buildParameters(body, false);
        this.invocation = Jimple.v().newSpecialInvokeExpr(parameters.get(0), this.getSootMethodRef(), parameters.subList(1, parameters.size()));
        body.setDanglingInstruction(this);
    }

    protected void jimplifyStatic(DexBody body) {
        this.invocation = Jimple.v().newStaticInvokeExpr(this.getStaticSootMethodRef(), this.buildParameters(body, true));
        body.setDanglingInstruction(this);
    }

    private static enum InvocationType {
        Static,
        Interface,
        Virtual;

    }
}

