/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import java.util.Set;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.DexAnnotation;
import soot.dexpler.DexField;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;

public class DexClass {
    protected String name;
    protected String type;
    protected String superClassName;
    protected String[] interfaceNames;
    protected Set<? extends Annotation> annotations;
    protected Set<SootField> fields;
    protected Set<SootMethod> soot_methods;
    protected Set<Type> types;
    protected int accessFlags;

    private DexClass(ClassDef classDef) {
    }

    public static IInitialResolver.Dependencies makeSootClass(SootClass sc, ClassDef defItem, DexFile dexFile) {
        SootMethod sm;
        SootField sootField;
        String superClass = defItem.getSuperclass();
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        String sourceFile = defItem.getSourceFile();
        if (sourceFile != null) {
            sc.addTag(new SourceFileTag(sourceFile));
        }
        if (superClass != null) {
            String superClassName = Util.dottedClassName(superClass);
            SootClass sootSuperClass = SootResolver.v().makeClassRef(superClassName);
            sc.setSuperclass(sootSuperClass);
            deps.typesToHierarchy.add(sootSuperClass.getType());
        }
        int accessFlags = defItem.getAccessFlags();
        sc.setModifiers(accessFlags);
        if (defItem.getInterfaces() != null) {
            for (String string2 : defItem.getInterfaces()) {
                String string3 = Util.dottedClassName(string2);
                if (sc.implementsInterface(string3)) continue;
                SootClass interfaceClass = SootResolver.v().makeClassRef(string3);
                interfaceClass.setModifiers(interfaceClass.getModifiers() | 0x200);
                sc.addInterface(interfaceClass);
                deps.typesToHierarchy.add(interfaceClass.getType());
            }
        }
        if (Options.v().oaat() && sc.resolvingLevel() <= 1) {
            return deps;
        }
        DexAnnotation da = new DexAnnotation(sc, deps);
        for (Field field2 : defItem.getStaticFields()) {
            if (sc.declaresField(field2.getName(), DexType.toSoot(field2.getType()))) continue;
            sootField = DexField.makeSootField(field2);
            sc.addField(sootField);
            da.handleFieldAnnotation(sootField, field2);
        }
        for (Field field3 : defItem.getInstanceFields()) {
            if (sc.declaresField(field3.getName(), DexType.toSoot(field3.getType()))) continue;
            sootField = DexField.makeSootField(field3);
            sc.addField(sootField);
            da.handleFieldAnnotation(sootField, field3);
        }
        for (Method method : defItem.getDirectMethods()) {
            sm = DexMethod.makeSootMethod(dexFile, method, sc);
            if (sc.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) continue;
            sc.addMethod(sm);
            da.handleMethodAnnotation(sm, method);
        }
        for (Method method : defItem.getVirtualMethods()) {
            sm = DexMethod.makeSootMethod(dexFile, method, sc);
            if (sc.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) continue;
            sc.addMethod(sm);
            da.handleMethodAnnotation(sm, method);
        }
        da.handleClassAnnotation(defItem);
        InnerClassAttribute innerClassAttribute = (InnerClassAttribute)sc.getTag("InnerClassAttribute");
        if (innerClassAttribute != null) {
            Iterator<InnerClassTag> iterator2 = innerClassAttribute.getSpecs().iterator();
            while (iterator2.hasNext()) {
                InnerClassAttribute icat;
                InnerClassTag ict;
                String inner2;
                Tag t = iterator2.next();
                if (!(t instanceof InnerClassTag) || !(inner2 = (ict = (InnerClassTag)t).getInnerClass().replaceAll("/", ".")).equals(sc.getName())) continue;
                String outer = null;
                outer = ict.getOuterClass() == null ? ict.getInnerClass().replaceAll("\\$[0-9].*$", "").replaceAll("/", ".") : ict.getOuterClass().replaceAll("/", ".");
                SootClass osc = SootResolver.v().makeClassRef(outer);
                if (osc == sc) {
                    if (!sc.hasOuterClass()) continue;
                    osc = sc.getOuterClass();
                }
                if ((icat = (InnerClassAttribute)osc.getTag("InnerClassAttribute")) == null) {
                    icat = new InnerClassAttribute();
                    osc.addTag(icat);
                }
                InnerClassTag newt = new InnerClassTag(ict.getInnerClass(), ict.getOuterClass(), ict.getShortName(), ict.getAccessFlags());
                icat.add(newt);
                iterator2.remove();
            }
        }
        return deps;
    }
}

