/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.AnnotationVisibility;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.Debug;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.DeprecatedTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toDex.SootToDexUtils;

public class DexAnnotation {
    private final Type ARRAY_TYPE = RefType.v("Array");
    private final SootClass clazz;
    private final IInitialResolver.Dependencies deps;

    DexAnnotation(SootClass clazz, IInitialResolver.Dependencies deps) {
        this.clazz = clazz;
        this.deps = deps;
    }

    void handleClassAnnotation(ClassDef classDef) {
        Set<? extends Annotation> aSet = classDef.getAnnotations();
        if (aSet == null || aSet.isEmpty()) {
            return;
        }
        List<Tag> tags2 = this.handleAnnotation(aSet, classDef.getType());
        if (tags2 == null) {
            return;
        }
        InnerClassAttribute ica = null;
        for (Tag t : tags2) {
            if (t == null) continue;
            if (t instanceof InnerClassTag) {
                if (ica == null && (ica = (InnerClassAttribute)this.clazz.getTag("InnerClassAttribute")) == null) {
                    ica = new InnerClassAttribute();
                    this.clazz.addTag(ica);
                }
                ica.add((InnerClassTag)t);
            } else if (t instanceof VisibilityAnnotationTag) {
                VisibilityAnnotationTag vt = (VisibilityAnnotationTag)t;
                for (AnnotationTag a2 : vt.getAnnotations()) {
                    if (!a2.getType().equals("Ldalvik/annotation/AnnotationDefault;")) continue;
                    for (AnnotationElem ae : a2.getElems()) {
                        if (!(ae instanceof AnnotationAnnotationElem)) continue;
                        AnnotationAnnotationElem aae = (AnnotationAnnotationElem)ae;
                        AnnotationTag at = aae.getValue();
                        HashMap<String, AnnotationElem> defaults = new HashMap<String, AnnotationElem>();
                        for (AnnotationElem annotationElem : at.getElems()) {
                            defaults.put(annotationElem.getName(), annotationElem);
                        }
                        for (SootMethod sootMethod : this.clazz.getMethods()) {
                            String methodName = sootMethod.getName();
                            if (!defaults.containsKey(methodName)) continue;
                            AnnotationElem e = (AnnotationElem)defaults.get(methodName);
                            Type annotationType = this.getSootType(e);
                            boolean isCorrectType = false;
                            if (annotationType == null) {
                                isCorrectType = true;
                            } else if (annotationType.equals(sootMethod.getReturnType())) {
                                isCorrectType = true;
                            } else if (annotationType.equals(this.ARRAY_TYPE) && sootMethod.getReturnType() instanceof ArrayType) {
                                isCorrectType = true;
                            }
                            if (!isCorrectType || sootMethod.getParameterCount() != 0) continue;
                            e.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(e);
                            sootMethod.addTag(d);
                            defaults.remove(sootMethod.getName());
                        }
                        for (Map.Entry entry2 : defaults.entrySet()) {
                            SootMethod found = this.clazz.getMethodByNameUnsafe((String)entry2.getKey());
                            AnnotationElem element2 = (AnnotationElem)entry2.getValue();
                            if (found == null) continue;
                            element2.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(element2);
                            found.addTag(d);
                        }
                    }
                }
                if (vt.getVisibility() != 1) {
                    this.clazz.addTag(vt);
                }
            } else {
                this.clazz.addTag(t);
            }
            Debug.printDbg("add class annotation: ", t, " type: ", t.getClass());
        }
    }

    private Type getSootType(AnnotationElem e) {
        Type annotationType;
        switch (e.getKind()) {
            case '[': {
                annotationType = this.ARRAY_TYPE;
                AnnotationArrayElem array = (AnnotationArrayElem)e;
                if (array.getNumValues() <= 0) break;
                AnnotationElem firstElement = array.getValueAt(0);
                Type type = this.getSootType(firstElement);
                if (type == null) {
                    return null;
                }
                if (type.equals(this.ARRAY_TYPE)) {
                    return this.ARRAY_TYPE;
                }
                return ArrayType.v(type, 1);
            }
            case 's': {
                annotationType = RefType.v("java.lang.String");
                break;
            }
            case 'c': {
                annotationType = RefType.v("java.lang.Class");
                break;
            }
            case 'e': {
                AnnotationEnumElem enumElem = (AnnotationEnumElem)e;
                annotationType = Util.getType(enumElem.getTypeName());
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'Z': {
                annotationType = Util.getType(String.valueOf(e.getKind()));
                break;
            }
            default: {
                annotationType = null;
            }
        }
        return annotationType;
    }

    void handleFieldAnnotation(Host h, Field f) {
        List<Tag> tags2;
        Set<? extends Annotation> aSet = f.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags2 = this.handleAnnotation(aSet, null)) != null) {
            for (Tag t : tags2) {
                if (t == null) continue;
                h.addTag(t);
                Debug.printDbg("add field annotation: ", t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleMethodAnnotation(Host h, Method method) {
        boolean bl;
        List<Tag> tags2;
        Set<? extends Annotation> aSet = method.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags2 = this.handleAnnotation(aSet, null)) != null) {
            for (Tag tag : tags2) {
                if (tag == null) continue;
                h.addTag(tag);
                Debug.printDbg("add method annotation: ", tag);
            }
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        boolean addParameterNames = false;
        for (MethodParameter methodParameter : method.getParameters()) {
            String name = methodParameter.getName();
            parameterNames.add(name);
            if (name == null) continue;
            addParameterNames = true;
        }
        if (addParameterNames) {
            h.addTag(new ParamNamesTag(parameterNames));
        }
        boolean bl2 = false;
        List<? extends MethodParameter> list = method.getParameters();
        for (MethodParameter methodParameter : list) {
            Debug.printDbg("parameter ", methodParameter, " annotations: ", methodParameter.getAnnotations());
            if (methodParameter.getAnnotations().size() <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) return;
        VisibilityParameterAnnotationTag tag = new VisibilityParameterAnnotationTag(list.size(), 0);
        for (MethodParameter methodParameter : list) {
            List<Tag> tags3 = this.handleAnnotation(methodParameter.getAnnotations(), null);
            if (tags3 == null) {
                tag.addVisibilityAnnotation(null);
                continue;
            }
            VisibilityAnnotationTag paramVat = new VisibilityAnnotationTag(0);
            tag.addVisibilityAnnotation(paramVat);
            for (Tag t : tags3) {
                if (t == null) continue;
                AnnotationTag vat = null;
                if (!(t instanceof VisibilityAnnotationTag)) {
                    if (t instanceof DeprecatedTag) {
                        vat = new AnnotationTag("Ljava/lang/Deprecated;");
                    } else {
                        if (!(t instanceof SignatureTag)) throw new RuntimeException("error: unhandled tag for parameter annotation in method " + h + " (" + t + ").");
                        SignatureTag sig = (SignatureTag)t;
                        ArrayList<AnnotationElem> sigElements = new ArrayList<AnnotationElem>();
                        for (String s2 : SootToDexUtils.splitSignature(sig.getSignature())) {
                            sigElements.add(new AnnotationStringElem(s2, 's', "value"));
                        }
                        AnnotationArrayElem elem = new AnnotationArrayElem(sigElements, 's', "value");
                        vat = new AnnotationTag("Ldalvik/annotation/Signature;", Collections.singleton(elem));
                    }
                } else {
                    vat = ((VisibilityAnnotationTag)t).getAnnotations().get(0);
                }
                Debug.printDbg("add parameter annotation: ", t);
                paramVat.addAnnotation(vat);
            }
        }
        if (tag.getVisibilityAnnotations().size() <= 0) return;
        h.addTag(tag);
    }

    /*
     * WARNING - void declaration
     */
    private List<Tag> handleAnnotation(Set<? extends Annotation> annotations, String classType) {
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        ArrayList<Tag> tags2 = new ArrayList<Tag>();
        VisibilityAnnotationTag[] vatg = new VisibilityAnnotationTag[3];
        for (Annotation annotation2 : annotations) {
            AnnotationElem e;
            int v = this.getVisibility(annotation2.getVisibility());
            Tag t = null;
            Type atype = DexType.toSoot(annotation2.getType());
            String atypes = atype.toString();
            int eSize = annotation2.getElements().size();
            Debug.printDbg("annotation type: ", atypes, " elements: ", eSize);
            if (atypes.equals("dalvik.annotation.AnnotationDefault")) {
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation Default. Got " + eSize + " instead.");
                }
                e = this.getElements(annotation2.getElements()).get(0);
                AnnotationTag annotationTag = new AnnotationTag(annotation2.getType());
                annotationTag.addElem(e);
                if (vatg[v] == null) {
                    vatg[v] = new VisibilityAnnotationTag(v);
                }
                vatg[v].addAnnotation(annotationTag);
            } else {
                if (atypes.equals("dalvik.annotation.EnclosingClass")) {
                    if (eSize != 1) {
                        throw new RuntimeException("error: expected 1 element for annotation EnclosingClass. Got " + eSize + " instead.");
                    }
                    for (AnnotationElement annotationElement : annotation2.getElements()) {
                        String string3 = ((TypeEncodedValue)annotationElement.getValue()).getValue();
                        string3 = Util.dottedClassName(string3);
                        this.deps.typesToSignature.add(RefType.v(string3));
                        this.clazz.setOuterClass(SootResolver.v().makeClassRef(string3));
                        assert (this.clazz.getOuterClass() != this.clazz);
                    }
                    continue;
                }
                if (atypes.equals("dalvik.annotation.EnclosingMethod")) {
                    if (eSize != 1) {
                        throw new RuntimeException("error: expected 1 element for annotation EnclosingMethod. Got " + eSize + " instead.");
                    }
                    e = (AnnotationStringElem)this.getElements(annotation2.getElements()).get(0);
                    String[] stringArray = ((AnnotationStringElem)e).getValue().split("\\ \\|");
                    String string4 = stringArray[0];
                    String methodString = stringArray[1];
                    String parameters = stringArray[2];
                    String returnType = stringArray[3];
                    String methodSigString = "(" + parameters + ")" + returnType;
                    t = new EnclosingMethodTag(string4, methodString, methodSigString);
                    String outerClass2 = string4.replace("/", ".");
                    this.deps.typesToSignature.add(RefType.v(outerClass2));
                    this.clazz.setOuterClass(SootResolver.v().makeClassRef(outerClass2));
                    assert (this.clazz.getOuterClass() != this.clazz);
                } else {
                    if (atypes.equals("dalvik.annotation.InnerClass")) {
                        void var14_38;
                        void var14_36;
                        void var13_22;
                        int accessFlags = -1;
                        Object var13_21 = null;
                        for (AnnotationElem ele : this.getElements(annotation2.getElements())) {
                            if (ele instanceof AnnotationIntElem && ele.getName().equals("accessFlags")) {
                                accessFlags = ((AnnotationIntElem)ele).getValue();
                                continue;
                            }
                            if (ele instanceof AnnotationStringElem && ele.getName().equals("name")) {
                                String string5 = ((AnnotationStringElem)ele).getValue();
                                continue;
                            }
                            throw new RuntimeException("Unexpected inner class annotation element");
                        }
                        if (var13_22 == null) {
                            String string6 = classType.replaceAll("\\$[0-9,a-z,A-Z]*;$", ";");
                        } else {
                            String string7 = classType.replaceFirst("\\$" + (String)var13_22 + ";$", ";");
                        }
                        if (var14_36.equals(classType)) {
                            Object var14_37 = null;
                        }
                        InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(classType), var14_38 == null ? null : DexType.toSootICAT((String)var14_38), (String)var13_22, accessFlags);
                        tags2.add(innerTag);
                        if (var14_38 == null || this.clazz.hasOuterClass()) continue;
                        String sootOuterClass = Util.dottedClassName((String)var14_38);
                        this.deps.typesToSignature.add(RefType.v(sootOuterClass));
                        this.clazz.setOuterClass(SootResolver.v().makeClassRef(sootOuterClass));
                        assert (this.clazz.getOuterClass() != this.clazz);
                        continue;
                    }
                    if (atypes.equals("dalvik.annotation.MemberClasses")) {
                        AnnotationArrayElem e2 = (AnnotationArrayElem)this.getElements(annotation2.getElements()).get(0);
                        for (AnnotationElem annotationElem : e2.getValues()) {
                            AnnotationClassElem c = (AnnotationClassElem)annotationElem;
                            String innerClass = c.getDesc();
                            String outerClass3 = innerClass.replaceAll("\\$[^\\$]*$", "");
                            String name = innerClass.replaceAll("^.*\\$", "").replaceAll(";$", "");
                            if (name.replaceAll("[0-9].*", "").equals("")) {
                                name = null;
                            }
                            int accessFlags = 0;
                            InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(innerClass), DexType.toSootICAT(outerClass3), name, accessFlags);
                            tags2.add(innerTag);
                        }
                        continue;
                    }
                    if (atypes.equals("dalvik.annotation.Signature")) {
                        void var13_26;
                        if (eSize != 1) {
                            throw new RuntimeException("error: expected 1 element for annotation Signature. Got " + eSize + " instead.");
                        }
                        e = (AnnotationArrayElem)this.getElements(annotation2.getElements()).get(0);
                        String string8 = "";
                        for (AnnotationElem ae2 : ((AnnotationArrayElem)e).getValues()) {
                            AnnotationStringElem s2 = (AnnotationStringElem)ae2;
                            String string9 = (String)var13_26 + s2.getValue();
                        }
                        t = new SignatureTag((String)var13_26);
                    } else {
                        if (atypes.equals("dalvik.annotation.Throws")) continue;
                        if (atypes.equals("java.lang.Deprecated")) {
                            if (eSize != 0) {
                                throw new RuntimeException("error: expected 1 element for annotation Deprecated. Got " + eSize + " instead.");
                            }
                            t = new DeprecatedTag();
                            AnnotationTag adt = new AnnotationTag("Ljava/lang/Deprecated;");
                            if (vatg[v] == null) {
                                vatg[v] = new VisibilityAnnotationTag(v);
                            }
                            vatg[v].addAnnotation(adt);
                        } else {
                            Debug.printDbg("read visibility tag: ", annotation2.getType());
                            if (vatg[v] == null) {
                                vatg[v] = new VisibilityAnnotationTag(v);
                            }
                            AnnotationTag tag = new AnnotationTag(annotation2.getType());
                            for (AnnotationElem annotationElem : this.getElements(annotation2.getElements())) {
                                tag.addElem(annotationElem);
                            }
                            vatg[v].addAnnotation(tag);
                        }
                    }
                }
            }
            tags2.add(t);
        }
        for (VisibilityAnnotationTag vat : vatg) {
            if (vat == null) continue;
            tags2.add(vat);
        }
        return tags2;
    }

    private ArrayList<AnnotationElem> getElements(Set<? extends AnnotationElement> set2) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (AnnotationElement annotationElement : set2) {
            Debug.printDbg("   element type: ", annotationElement.getValue().getClass());
            ArrayList<AnnotationElem> eList = this.handleAnnotationElement(annotationElement, Collections.singletonList(annotationElement.getValue()));
            if (eList == null) continue;
            aelemList.addAll(eList);
        }
        return aelemList;
    }

    private ArrayList<AnnotationElem> handleAnnotationElement(AnnotationElement ae, List<? extends EncodedValue> evList) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (EncodedValue encodedValue : evList) {
            int type = encodedValue.getValueType();
            AnnotationElem elem = null;
            Debug.printDbg("encoded value type: ", type);
            switch (type) {
                case 0: {
                    EncodedValue v = (ByteEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'B', ae.getName());
                    break;
                }
                case 2: {
                    EncodedValue v = (ShortEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'S', ae.getName());
                    break;
                }
                case 3: {
                    EncodedValue v = (CharEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'C', ae.getName());
                    break;
                }
                case 4: {
                    EncodedValue v = (IntEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'I', ae.getName());
                    break;
                }
                case 6: {
                    EncodedValue v = (LongEncodedValue)encodedValue;
                    elem = new AnnotationLongElem(v.getValue(), 'J', ae.getName());
                    break;
                }
                case 16: {
                    EncodedValue v = (FloatEncodedValue)encodedValue;
                    elem = new AnnotationFloatElem(v.getValue(), 'F', ae.getName());
                    break;
                }
                case 17: {
                    EncodedValue v = (DoubleEncodedValue)encodedValue;
                    elem = new AnnotationDoubleElem(v.getValue(), 'D', ae.getName());
                    break;
                }
                case 23: {
                    EncodedValue v = (StringEncodedValue)encodedValue;
                    elem = new AnnotationStringElem(v.getValue(), 's', ae.getName());
                    Debug.printDbg("value for string: ", v.getValue());
                    break;
                }
                case 24: {
                    EncodedValue v = (TypeEncodedValue)encodedValue;
                    elem = new AnnotationClassElem(DexType.toSootAT(v.getValue()), 'c', ae.getName());
                    break;
                }
                case 25: {
                    EncodedValue v = (FieldEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    String fieldSig = "";
                    fieldSig = fieldSig + DexType.toSootAT(fr.getDefiningClass()) + ": ";
                    fieldSig = fieldSig + DexType.toSootAT(fr.getType()) + " ";
                    fieldSig = fieldSig + fr.getName();
                    Debug.printDbg("FIELD: ", fieldSig);
                    elem = new AnnotationStringElem(fieldSig, 'f', ae.getName());
                    break;
                }
                case 26: {
                    EncodedValue v = (MethodEncodedValue)encodedValue;
                    MethodReference mr = v.getValue();
                    String className = DexType.toSootICAT(mr.getDefiningClass());
                    String string2 = DexType.toSootAT(mr.getReturnType());
                    String methodName = mr.getName();
                    String parameters = "";
                    for (CharSequence charSequence : mr.getParameterTypes()) {
                        parameters = parameters + DexType.toSootAT(charSequence.toString());
                    }
                    String mSig = className + " |" + methodName + " |" + parameters + " |" + string2;
                    elem = new AnnotationStringElem(mSig, 'M', ae.getName());
                    break;
                }
                case 27: {
                    EncodedValue v = (EnumEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    elem = new AnnotationEnumElem(DexType.toSootAT(fr.getType()).toString(), fr.getName(), 'e', ae.getName());
                    break;
                }
                case 28: {
                    EncodedValue v = (ArrayEncodedValue)encodedValue;
                    ArrayList<AnnotationElem> l = this.handleAnnotationElement(ae, v.getValue());
                    if (l == null) break;
                    elem = new AnnotationArrayElem(l, '[', ae.getName());
                    break;
                }
                case 29: {
                    EncodedValue v = (AnnotationEncodedValue)encodedValue;
                    AnnotationTag t = new AnnotationTag(DexType.toSootAT(v.getType()).toString());
                    for (AnnotationElement annotationElement : v.getElements()) {
                        ArrayList<EncodedValue> l = new ArrayList<EncodedValue>();
                        l.add(annotationElement.getValue());
                        ArrayList<AnnotationElem> aList = this.handleAnnotationElement(annotationElement, l);
                        if (aList == null) continue;
                        for (AnnotationElem annotationElem : aList) {
                            t.addElem(annotationElem);
                        }
                    }
                    elem = new AnnotationAnnotationElem(t, '@', ae.getName());
                    break;
                }
                case 30: {
                    elem = new AnnotationStringElem(null, 'N', ae.getName());
                    break;
                }
                case 31: {
                    EncodedValue v = (BooleanEncodedValue)encodedValue;
                    elem = new AnnotationBooleanElem(v.getValue(), 'Z', ae.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown annotation element 0x" + Integer.toHexString(type));
                }
            }
            if (elem == null) continue;
            aelemList.add(elem);
        }
        return aelemList;
    }

    private int getVisibility(int visibility) {
        if ("runtime".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 0;
        }
        if ("system".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 1;
        }
        if ("build".equals(AnnotationVisibility.getVisibility(visibility))) {
            return 2;
        }
        throw new RuntimeException("error: unknown annotation visibility: '" + visibility + "'");
    }

    class MyAnnotations {
        List<AnnotationTag> annotationList = new ArrayList<AnnotationTag>();
        List<Integer> visibilityList = new ArrayList<Integer>();

        MyAnnotations() {
        }

        public void add(AnnotationTag a2, int visibility) {
            this.annotationList.add(a2);
            this.visibilityList.add(new Integer(visibility));
        }

        public List<AnnotationTag> getAnnotations() {
            return this.annotationList;
        }

        public List<Integer> getVisibilityList() {
            return this.visibilityList;
        }
    }
}

