/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import soot.G;
import soot.Singletons;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETSwitchNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.dava.toolkits.base.finders.IndexComparator;
import soot.dava.toolkits.base.finders.SwitchNode;
import soot.dava.toolkits.base.finders.SwitchNodeGraph;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.util.IterableSet;

public class SwitchFinder
implements FactFinder {
    private IterableSet junkBody;
    private HashSet targetSet;
    private LinkedList targetList;
    private LinkedList snTargetList;
    private LinkedList tSuccList;
    private HashMap index2target;
    private HashMap tSucc2indexSet;
    private HashMap tSucc2target;
    private HashMap tSucc2Body;

    public SwitchFinder(Singletons.Global g) {
    }

    public static SwitchFinder v() {
        return G.v().soot_dava_toolkits_base_finders_SwitchFinder();
    }

    @Override
    public void find(DavaBody davaBody, AugmentedStmtGraph asg, SETNode SET2) throws RetriggerAnalysisException {
        Dava.v().log("SwitchFinder::find()");
        String defaultStr = "default";
        for (AugmentedStmt as : asg) {
            Stmt s2 = as.get_Stmt();
            if (!(s2 instanceof TableSwitchStmt) && !(s2 instanceof LookupSwitchStmt)) continue;
            Value key2 = null;
            this.junkBody = new IterableSet();
            this.targetSet = new HashSet();
            this.targetList = new LinkedList();
            this.snTargetList = new LinkedList();
            this.tSuccList = new LinkedList();
            this.index2target = new HashMap();
            this.tSucc2indexSet = new HashMap();
            this.tSucc2target = new HashMap();
            this.tSucc2Body = new HashMap();
            if (s2 instanceof TableSwitchStmt) {
                TableSwitchStmt tss = (TableSwitchStmt)s2;
                int target_count = tss.getHighIndex() - tss.getLowIndex() + 1;
                for (int i = 0; i < target_count; ++i) {
                    this.build_Bindings(as, new Integer(i + tss.getLowIndex()), asg.get_AugStmt((Stmt)tss.getTarget(i)));
                }
                this.build_Bindings(as, "default", asg.get_AugStmt((Stmt)tss.getDefaultTarget()));
                key2 = tss.getKey();
            } else if (s2 instanceof LookupSwitchStmt) {
                LookupSwitchStmt lss = (LookupSwitchStmt)s2;
                int target_count = lss.getTargetCount();
                for (int i = 0; i < target_count; ++i) {
                    this.build_Bindings(as, new Integer(lss.getLookupValue(i)), asg.get_AugStmt((Stmt)lss.getTarget(i)));
                }
                this.build_Bindings(as, "default", asg.get_AugStmt((Stmt)lss.getDefaultTarget()));
                key2 = lss.getKey();
            }
            for (AugmentedStmt tSucc : this.tSuccList) {
                AugmentedStmt target = (AugmentedStmt)this.tSucc2target.get(tSucc);
                this.snTargetList.addLast(new SwitchNode(target, (TreeSet)this.tSucc2indexSet.get(tSucc), (IterableSet)this.tSucc2Body.get(tSucc)));
            }
            TreeSet targetHeads = new TreeSet();
            TreeSet killBodies = new TreeSet();
            asg.calculate_Reachability((Collection)this.targetList, this.targetSet, as);
            SwitchNodeGraph sng = new SwitchNodeGraph(this.snTargetList);
            killBodies.addAll(this.snTargetList);
            this.snTargetList = new LinkedList();
            LinkedList<SwitchNode> worklist = new LinkedList<SwitchNode>();
            worklist.addAll(sng.getHeads());
            while (!worklist.isEmpty()) {
                SwitchNode sn = (SwitchNode)worklist.removeFirst();
                this.snTargetList.addLast(sn);
                killBodies.remove(sn);
                SwitchNode champ = null;
                for (SwitchNode ssn : sn.get_Succs()) {
                    if (champ != null && champ.get_Score() >= ssn.get_Score()) continue;
                    champ = ssn;
                }
                if (champ == null || champ.get_Score() <= 0) continue;
                worklist.addLast(champ);
            }
            for (SwitchNode sn : killBodies) {
                IterableSet snBody = sn.get_Body();
                snBody.clear();
                snBody.add(sn.get_AugStmt());
            }
            sng = new SwitchNodeGraph(this.snTargetList);
            targetHeads.addAll(sng.getHeads());
            LinkedList<SwitchNode> switchNodeList = new LinkedList<SwitchNode>();
            block7: while (!targetHeads.isEmpty() || !killBodies.isEmpty()) {
                SwitchNode nextNode;
                if (targetHeads.isEmpty() || !targetHeads.isEmpty() && !killBodies.isEmpty() && ((SwitchNode)targetHeads.first()).compareTo(killBodies.first()) > 0) {
                    nextNode = (SwitchNode)killBodies.first();
                    killBodies.remove(nextNode);
                    switchNodeList.addLast(nextNode);
                    continue;
                }
                nextNode = (SwitchNode)targetHeads.first();
                targetHeads.remove(nextNode);
                while (true) {
                    switchNodeList.addLast(nextNode);
                    if (nextNode.get_Succs().isEmpty()) continue block7;
                    nextNode = (SwitchNode)nextNode.get_Succs().get(0);
                }
            }
            IterableSet<AugmentedStmt> body = new IterableSet<AugmentedStmt>();
            body.add(as);
            for (SwitchNode sn : switchNodeList) {
                body.addAll(sn.get_Body());
                if (!sn.get_IndexSet().contains("default")) continue;
                sn.get_IndexSet().clear();
                sn.get_IndexSet().add("default");
            }
            body.addAll(this.junkBody);
            for (ExceptionNode en : davaBody.get_ExceptionFacts()) {
                IterableSet tryBody = en.get_TryBody();
                if (!tryBody.contains(as)) continue;
                Iterator fbit = body.snapshotIterator();
                block11: while (fbit.hasNext()) {
                    AugmentedStmt fbas = (AugmentedStmt)fbit.next();
                    if (tryBody.contains(fbas)) continue;
                    body.remove(fbas);
                    for (SwitchNode sn : switchNodeList) {
                        IterableSet switchBody = sn.get_Body();
                        if (!switchBody.contains(fbas)) continue;
                        switchBody.remove(fbas);
                        continue block11;
                    }
                }
            }
            SET2.nest(new SETSwitchNode(as, key2, body, switchNodeList, this.junkBody));
        }
    }

    private IterableSet find_SubBody(AugmentedStmt switchAS, AugmentedStmt branchS) {
        IterableSet<AugmentedStmt> subBody = new IterableSet<AugmentedStmt>();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        subBody.add(branchS);
        branchS = branchS.bsuccs.get(0);
        if (branchS.get_Dominators().contains(switchAS)) {
            worklist.addLast(branchS);
            subBody.add(branchS);
        }
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            for (AugmentedStmt sas : as.csuccs) {
                if (subBody.contains(sas) || !sas.get_Dominators().contains(branchS)) continue;
                worklist.addLast(sas);
                subBody.add(sas);
            }
        }
        return subBody;
    }

    private void build_Bindings(AugmentedStmt swAs, Object index, AugmentedStmt target) {
        AugmentedStmt tSucc = target.bsuccs.get(0);
        if (this.targetSet.add(tSucc)) {
            this.targetList.addLast(tSucc);
        }
        this.index2target.put(index, target);
        TreeSet<Object> indices = null;
        indices = (TreeSet<Object>)this.tSucc2indexSet.get(tSucc);
        if (indices == null) {
            indices = new TreeSet<Object>(new IndexComparator());
            this.tSucc2indexSet.put(tSucc, indices);
            this.tSucc2target.put(tSucc, target);
            this.tSucc2Body.put(tSucc, this.find_SubBody(swAs, target));
            this.tSuccList.add(tSucc);
        } else {
            this.junkBody.add(target);
            Iterator<AugmentedStmt> sit = target.bsuccs.iterator();
            while (sit.hasNext()) {
                sit.next().bpreds.remove(target);
            }
            sit = target.csuccs.iterator();
            while (sit.hasNext()) {
                sit.next().cpreds.remove(target);
            }
            target.bsuccs.clear();
            target.csuccs.clear();
        }
        indices.add(index);
    }
}

