/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DInstanceFieldRef;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.internal.javaRep.DStaticFieldRef;
import soot.dava.internal.javaRep.DVariableDeclarationStmt;
import soot.dava.toolkits.base.AST.structuredAnalysis.MustMayInitialize;
import soot.dava.toolkits.base.AST.traversals.ASTParentNodeFinder;
import soot.dava.toolkits.base.AST.traversals.AllVariableUses;
import soot.grimp.internal.GAssignStmt;
import soot.jimple.ConvertToBaf;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.internal.JimpleLocal;

public class FinalFieldDefinition {
    SootClass sootClass;
    SootMethod sootMethod;
    DavaBody davaBody;
    List<SootField> cancelFinalModifier;

    public FinalFieldDefinition(ASTMethodNode node) {
        this.davaBody = node.getDavaBody();
        this.sootMethod = this.davaBody.getMethod();
        this.sootClass = this.sootMethod.getDeclaringClass();
        String subSignature = this.sootMethod.getName();
        if (subSignature.compareTo("<clinit>") != 0 && subSignature.compareTo("<init>") != 0) {
            return;
        }
        ArrayList<SootField> interesting = this.findFinalFields();
        if (interesting.size() == 0) {
            return;
        }
        this.cancelFinalModifier = new ArrayList<SootField>();
        this.analyzeMethod(node, interesting);
        for (SootField field2 : this.cancelFinalModifier) {
            field2.setModifiers(0xFFEF & field2.getModifiers());
        }
    }

    public ArrayList<SootField> findFinalFields() {
        ArrayList<SootField> interestingFinalFields = new ArrayList<SootField>();
        for (SootField tempField : this.sootClass.getFields()) {
            if (!tempField.isFinal()) continue;
            if (tempField.isStatic() && this.sootMethod.getName().compareTo("<clinit>") == 0) {
                interestingFinalFields.add(tempField);
            }
            if (tempField.isStatic() || this.sootMethod.getName().compareTo("<init>") != 0) continue;
            interestingFinalFields.add(tempField);
        }
        return interestingFinalFields;
    }

    public void analyzeMethod(ASTMethodNode node, List<SootField> varsOfInterest) {
        MustMayInitialize must2 = new MustMayInitialize(node, 0);
        for (SootField interest : varsOfInterest) {
            Type fieldType = interest.getType();
            if (fieldType instanceof DoubleType && interest.hasTag("DoubleConstantValueTag") || fieldType instanceof FloatType && interest.hasTag("FloatConstantValueTag") || fieldType instanceof LongType && interest.hasTag("LongConstantValueTag") || fieldType instanceof CharType && interest.hasTag("IntegerConstantValueTag") || fieldType instanceof BooleanType && interest.hasTag("IntegerConstantValueTag") || (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) && interest.hasTag("IntegerConstantValueTag") || interest.hasTag("StringConstantValueTag") || must2.isMustInitialized(interest)) continue;
            MustMayInitialize may = new MustMayInitialize(node, 1);
            if (may.isMayInitialized(interest)) {
                List defs = must2.getDefs(interest);
                if (defs == null) {
                    throw new RuntimeException("Sootfield: " + interest + " is mayInitialized but the defs is null");
                }
                this.handleAssignOnSomePaths(node, interest, defs);
                continue;
            }
            this.assignDefault(node, interest);
        }
    }

    public void assignDefault(ASTMethodNode node, SootField f) {
        Stmt s2;
        List<Object> stmts;
        ASTNode lastNode;
        AugmentedStmt defaultStmt = this.createDefaultStmt(f);
        if (defaultStmt == null) {
            return;
        }
        List<Object> subBodies = node.get_SubBodies();
        if (subBodies.size() != 1) {
            throw new RuntimeException("SubBodies size of method node not equal to 1");
        }
        List body = (List)subBodies.get(0);
        boolean done2 = false;
        if (body.size() != 0 && (lastNode = (ASTNode)body.get(body.size() - 1)) instanceof ASTStatementSequenceNode && (stmts = ((ASTStatementSequenceNode)lastNode).getStatements()).size() != 0 && !((s2 = ((AugmentedStmt)stmts.get(0)).get_Stmt()) instanceof DVariableDeclarationStmt)) {
            stmts.add(defaultStmt);
            ASTStatementSequenceNode newNode = new ASTStatementSequenceNode(stmts);
            body.remove(body.size() - 1);
            body.add(newNode);
            node.replaceBody(body);
            done2 = true;
        }
        if (!done2) {
            ArrayList<Object> newBody = new ArrayList<Object>();
            newBody.add(defaultStmt);
            ASTStatementSequenceNode newNode = new ASTStatementSequenceNode(newBody);
            body.add(newNode);
            node.replaceBody(body);
        }
    }

    public AugmentedStmt createDefaultStmt(Object field2) {
        Value ref = null;
        Type fieldType = null;
        if (field2 instanceof SootField) {
            SootFieldRef tempFieldRef = ((SootField)field2).makeRef();
            fieldType = ((SootField)field2).getType();
            ref = ((SootField)field2).isStatic() ? new DStaticFieldRef(tempFieldRef, true) : new DInstanceFieldRef(new JimpleLocal("this", fieldType), tempFieldRef, new HashSet<Object>());
        } else if (field2 instanceof Local) {
            ref = (Local)field2;
            fieldType = ((Local)field2).getType();
        }
        GAssignStmt assignStmt = null;
        if (fieldType instanceof RefType) {
            assignStmt = new GAssignStmt(ref, NullConstant.v());
        } else if (fieldType instanceof DoubleType) {
            assignStmt = new GAssignStmt(ref, DoubleConstant.v(0.0));
        } else if (fieldType instanceof FloatType) {
            assignStmt = new GAssignStmt(ref, FloatConstant.v(0.0f));
        } else if (fieldType instanceof LongType) {
            assignStmt = new GAssignStmt(ref, LongConstant.v(0L));
        } else if (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType || fieldType instanceof CharType || fieldType instanceof BooleanType) {
            assignStmt = new GAssignStmt(ref, DIntConstant.v(0, fieldType));
        }
        if (assignStmt != null) {
            AugmentedStmt as = new AugmentedStmt(assignStmt);
            return as;
        }
        return null;
    }

    public void handleAssignOnSomePaths(ASTMethodNode node, SootField field2, List defs) {
        if (defs.size() != 1) {
            this.cancelFinalModifier.add(field2);
        } else {
            AllVariableUses varUses = new AllVariableUses(node);
            node.apply(varUses);
            List allUses = varUses.getUsesForField(field2);
            if (allUses != null && allUses.size() != 0) {
                this.cancelFinalModifier.add(field2);
            } else {
                Type localType = field2.getType();
                JimpleLocal newLocal = new JimpleLocal("DavaTemp_" + field2.getName(), localType);
                DVariableDeclarationStmt varStmt = new DVariableDeclarationStmt(localType, this.davaBody);
                varStmt.addLocal(newLocal);
                AugmentedStmt as = new AugmentedStmt(varStmt);
                ASTStatementSequenceNode declNode = node.getDeclarations();
                List<Object> stmts = declNode.getStatements();
                stmts.add(as);
                declNode = new ASTStatementSequenceNode(stmts);
                List<Object> subBodies = node.get_SubBodies();
                if (subBodies.size() != 1) {
                    throw new DecompilationException("ASTMethodNode does not have one subBody");
                }
                List body = (List)subBodies.get(0);
                body.remove(0);
                body.add(0, declNode);
                node.replaceBody(body);
                node.setDeclarations(declNode);
                AugmentedStmt initialization = this.createDefaultStmt(newLocal);
                if (body.size() < 2) {
                    throw new RuntimeException("Size of body is less than 1");
                }
                ASTNode nodeSecond = (ASTNode)body.get(1);
                if (nodeSecond instanceof ASTStatementSequenceNode) {
                    List<Object> stmts1 = ((ASTStatementSequenceNode)nodeSecond).getStatements();
                    stmts1.add(initialization);
                    nodeSecond = new ASTStatementSequenceNode(stmts1);
                    body.remove(1);
                } else {
                    ArrayList<Object> tempList = new ArrayList<Object>();
                    tempList.add(initialization);
                    nodeSecond = new ASTStatementSequenceNode(tempList);
                }
                body.add(1, nodeSecond);
                node.replaceBody(body);
                ((GAssignStmt)defs.get(0)).setLeftOp(newLocal);
                SootFieldRef tempFieldRef = field2.makeRef();
                ConvertToBaf ref = field2.isStatic() ? new DStaticFieldRef(tempFieldRef, true) : new DInstanceFieldRef(new JimpleLocal("this", field2.getType()), tempFieldRef, new HashSet<Object>());
                GAssignStmt assignStmt = new GAssignStmt((Value)((Object)ref), newLocal);
                AugmentedStmt assignStmt1 = new AugmentedStmt(assignStmt);
                ASTParentNodeFinder parentFinder = new ASTParentNodeFinder();
                node.apply(parentFinder);
                Object parent = parentFinder.getParentOf(defs.get(0));
                if (!(parent instanceof ASTStatementSequenceNode)) {
                    throw new DecompilationException("Parent of stmt was not a stmt seq node");
                }
                Object grandParent = parentFinder.getParentOf(parent);
                if (grandParent == null) {
                    throw new DecompilationException("Parent of stmt seq node was null");
                }
                MustMayInitialize must2 = new MustMayInitialize(node, 0);
                while (!must2.isMustInitialized(field2)) {
                    Object parentOfGrandParent = parentFinder.getParentOf(grandParent);
                    if (!(grandParent instanceof ASTMethodNode) && parentOfGrandParent == null) {
                        throw new DecompilationException("Parent of non method node was null");
                    }
                    boolean notResolved = false;
                    ASTNode ancestor = (ASTNode)parentOfGrandParent;
                    List<Object> ancestorBodies = ancestor.get_SubBodies();
                    Iterator<Object> it = ancestorBodies.iterator();
                    while (it.hasNext()) {
                        List ancestorSubBody = null;
                        ancestorSubBody = ancestor instanceof ASTTryNode ? (List)((ASTTryNode.container)it.next()).o : (List)it.next();
                        if (ancestorSubBody.indexOf(grandParent) <= -1) continue;
                        int index = ancestorSubBody.indexOf(grandParent);
                        if (index + 1 < ancestorSubBody.size() && ancestorSubBody.get(index + 1) instanceof ASTStatementSequenceNode) {
                            ASTStatementSequenceNode someNode = (ASTStatementSequenceNode)ancestorSubBody.get(index + 1);
                            List<Object> stmtsLast = someNode.getStatements();
                            ArrayList<Object> newStmts = new ArrayList<Object>();
                            newStmts.add(assignStmt1);
                            newStmts.addAll(stmtsLast);
                            someNode.setStatements(newStmts);
                            must2 = new MustMayInitialize(node, 0);
                            if (must2.isMustInitialized(field2)) break;
                            someNode.setStatements(stmtsLast);
                            notResolved = true;
                            break;
                        }
                        ArrayList<Object> tempList = new ArrayList<Object>();
                        tempList.add(assignStmt1);
                        ASTStatementSequenceNode lastNode = new ASTStatementSequenceNode(tempList);
                        ancestorSubBody.add(index + 1, lastNode);
                        must2 = new MustMayInitialize(node, 0);
                        if (must2.isMustInitialized(field2)) break;
                        ancestorSubBody.remove(index + 1);
                        notResolved = true;
                        break;
                    }
                    if (!notResolved) continue;
                    grandParent = parentFinder.getParentOf(grandParent);
                }
            }
        }
    }
}

