/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.HashMap;
import java.util.List;
import soot.Local;
import soot.SootField;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.structuredAnalysis.CP;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.CPHelper;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.jimple.ConditionExpr;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

public class CPApplication
extends DepthFirstAdapter {
    CP cp = null;
    String className = null;

    public CPApplication(ASTMethodNode AST2, HashMap<String, Object> constantValueFields, HashMap<String, SootField> classNameFieldNameToSootFieldMapping) {
        this.className = AST2.getDavaBody().getMethod().getDeclaringClass().getName();
        this.cp = new CP(AST2, constantValueFields, classNameFieldNameToSootFieldMapping);
    }

    public CPApplication(boolean verbose, ASTMethodNode AST2, HashMap<String, Object> constantValueFields, HashMap<String, SootField> classNameFieldNameToSootFieldMapping) {
        super(verbose);
        this.className = AST2.getDavaBody().getMethod().getDeclaringClass().getName();
        this.cp = new CP(AST2, constantValueFields, classNameFieldNameToSootFieldMapping);
    }

    @Override
    public void inASTSwitchNode(ASTSwitchNode node) {
        Value newValue;
        FieldRef useField;
        SootField usedSootField;
        Object value2;
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        Value key2 = node.get_Key();
        if (key2 instanceof Local) {
            Value newValue2;
            Local useLocal = (Local)key2;
            Object value3 = beforeSet.contains(this.className, useLocal.toString());
            if (value3 != null && (newValue2 = CPHelper.createConstant(value3)) != null) {
                node.set_Key(newValue2);
            }
        } else if (key2 instanceof FieldRef && (value2 = beforeSet.contains((usedSootField = (useField = (FieldRef)key2).getField()).getDeclaringClass().getName(), usedSootField.getName().toString())) != null && (newValue = CPHelper.createConstant(value2)) != null) {
            node.set_Key(newValue);
        }
    }

    @Override
    public void inASTForLoopNode(ASTForLoopNode node) {
        for (AugmentedStmt augmentedStmt : node.getInit()) {
            Stmt s2 = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s2.getUseBoxes();
            DavaFlowSet davaFlowSet = this.cp.getBeforeSet(s2);
            if (davaFlowSet == null || !(davaFlowSet instanceof CPFlowSet)) continue;
            CPFlowSet beforeSet = (CPFlowSet)davaFlowSet;
            this.substituteUses(useBoxes, beforeSet);
        }
        DavaFlowSet davaFlowSet = this.cp.getAfterSet(node);
        if (davaFlowSet == null) {
            return;
        }
        if (!(davaFlowSet instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)davaFlowSet;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
        for (AugmentedStmt augmentedStmt : node.getUpdate()) {
            Stmt s3 = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s3.getUseBoxes();
            this.substituteUses(useBoxes, afterSet);
        }
    }

    @Override
    public void inASTWhileNode(ASTWhileNode node) {
        DavaFlowSet obj = this.cp.getAfterSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
    }

    @Override
    public void inASTDoWhileNode(ASTDoWhileNode node) {
        DavaFlowSet obj = this.cp.getAfterSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet afterSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, afterSet);
    }

    @Override
    public void inASTIfNode(ASTIfNode node) {
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, beforeSet);
    }

    @Override
    public void inASTIfElseNode(ASTIfElseNode node) {
        DavaFlowSet obj = this.cp.getBeforeSet(node);
        if (obj == null) {
            return;
        }
        if (!(obj instanceof CPFlowSet)) {
            return;
        }
        CPFlowSet beforeSet = (CPFlowSet)obj;
        ASTCondition cond = node.get_Condition();
        this.changedCondition(cond, beforeSet);
    }

    public ASTCondition changedCondition(ASTCondition cond, CPFlowSet set2) {
        if (cond instanceof ASTAggregatedCondition) {
            ASTCondition left = this.changedCondition(((ASTAggregatedCondition)cond).getLeftOp(), set2);
            ASTCondition right = this.changedCondition(((ASTAggregatedCondition)cond).getRightOp(), set2);
            ((ASTAggregatedCondition)cond).setLeftOp(left);
            ((ASTAggregatedCondition)cond).setRightOp(right);
            return cond;
        }
        if (cond instanceof ASTUnaryCondition) {
            Value val = ((ASTUnaryCondition)cond).getValue();
            if (val instanceof Local) {
                Value newValue;
                Object value2 = set2.contains(this.className, ((Local)val).toString());
                if (value2 != null && (newValue = CPHelper.createConstant(value2)) != null) {
                    ((ASTUnaryCondition)cond).setValue(newValue);
                }
            } else if (val instanceof FieldRef) {
                Value newValue;
                FieldRef useField = (FieldRef)val;
                SootField usedSootField = useField.getField();
                Object value3 = set2.contains(usedSootField.getDeclaringClass().getName(), usedSootField.getName().toString());
                if (value3 != null && (newValue = CPHelper.createConstant(value3)) != null) {
                    ((ASTUnaryCondition)cond).setValue(newValue);
                }
            } else {
                this.substituteUses(val.getUseBoxes(), set2);
            }
            return cond;
        }
        if (cond instanceof ASTBinaryCondition) {
            ConditionExpr val = ((ASTBinaryCondition)cond).getConditionExpr();
            this.substituteUses(val.getUseBoxes(), set2);
            return cond;
        }
        throw new RuntimeException("Method getUseList in ASTUsesAndDefs encountered unknown condition type");
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> statements = node.getStatements();
        for (AugmentedStmt augmentedStmt : statements) {
            Stmt s2 = augmentedStmt.get_Stmt();
            List<ValueBox> useBoxes = s2.getUseBoxes();
            DavaFlowSet obj = this.cp.getBeforeSet(s2);
            if (obj == null || !(obj instanceof CPFlowSet)) continue;
            CPFlowSet beforeSet = (CPFlowSet)obj;
            this.substituteUses(useBoxes, beforeSet);
        }
    }

    public void substituteUses(List useBoxes, CPFlowSet beforeSet) {
        for (Object useObj : useBoxes) {
            Value newValue;
            FieldRef useField;
            SootField usedSootField;
            Object value2;
            Value use = ((ValueBox)useObj).getValue();
            if (use instanceof Local) {
                Value newValue2;
                Local useLocal = (Local)use;
                Object value3 = beforeSet.contains(this.className, useLocal.toString());
                if (value3 == null || (newValue2 = CPHelper.createConstant(value3)) == null) continue;
                ((ValueBox)useObj).setValue(newValue2);
                continue;
            }
            if (!(use instanceof FieldRef) || (value2 = beforeSet.contains((usedSootField = (useField = (FieldRef)use).getField()).getDeclaringClass().getName(), usedSootField.getName().toString())) == null || (newValue = CPHelper.createConstant(value2)) == null) continue;
            ((ValueBox)useObj).setValue(newValue);
        }
    }
}

