/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.interProcedural;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.PhaseOptions;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.dava.DavaBody;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.AST.interProcedural.ConstantFieldValueFinder;
import soot.dava.toolkits.base.AST.transformations.CPApplication;
import soot.dava.toolkits.base.AST.transformations.EliminateConditions;
import soot.dava.toolkits.base.AST.transformations.LocalVariableCleaner;
import soot.dava.toolkits.base.AST.transformations.SimplifyConditions;
import soot.dava.toolkits.base.AST.transformations.SimplifyExpressions;
import soot.dava.toolkits.base.AST.transformations.UnreachableCodeEliminator;
import soot.dava.toolkits.base.AST.transformations.UselessLabelFinder;
import soot.dava.toolkits.base.AST.transformations.VoidReturnRemover;
import soot.dava.toolkits.base.renamer.Renamer;
import soot.dava.toolkits.base.renamer.infoGatheringAnalysis;
import soot.util.Chain;

public class InterProceduralAnalyses {
    public static boolean DEBUG = false;

    public static void applyInterProceduralAnalyses() {
        Chain<SootClass> classes = Scene.v().getApplicationClasses();
        if (DEBUG) {
            System.out.println("\n\nInvoking redundantFielduseEliminator");
        }
        ConstantFieldValueFinder finder = new ConstantFieldValueFinder(classes);
        HashMap<String, Object> constantValueFields = finder.getFieldsWithConstantValues();
        if (DEBUG) {
            finder.printConstantValueFields();
        }
        for (SootClass s2 : classes) {
            Iterator<SootMethod> methodIt = s2.methodIterator();
            while (methodIt.hasNext()) {
                boolean renamer;
                ASTNode AST2;
                SootMethod m = methodIt.next();
                DavaBody body = null;
                if (!m.hasActiveBody() || !((AST2 = (ASTNode)(body = (DavaBody)m.getActiveBody()).getUnits().getFirst()) instanceof ASTMethodNode)) continue;
                Map<String, String> options = PhaseOptions.v().getPhaseOptions("db.deobfuscate");
                boolean deobfuscate = PhaseOptions.getBoolean(options, "enabled");
                if (deobfuscate) {
                    if (DEBUG) {
                        System.out.println("\nSTART CP Class:" + s2.getName() + " Method: " + m.getName());
                    }
                    CPApplication CPApp = new CPApplication((ASTMethodNode)AST2, constantValueFields, finder.getClassNameFieldNameToSootFieldMapping());
                    AST2.apply(CPApp);
                    if (DEBUG) {
                        System.out.println("DONE CP for " + m.getName());
                    }
                }
                AST2.apply(new SimplifyExpressions());
                AST2.apply(new SimplifyConditions());
                AST2.apply(new EliminateConditions((ASTMethodNode)AST2));
                AST2.apply(new UnreachableCodeEliminator(AST2));
                AST2.apply(new LocalVariableCleaner(AST2));
                if (deobfuscate) {
                    if (DEBUG) {
                        System.out.println("reinvoking analyzeAST");
                    }
                    UselessLabelFinder.DEBUG = false;
                    body.analyzeAST();
                }
                if (renamer = PhaseOptions.getBoolean(options = PhaseOptions.v().getPhaseOptions("db.renamer"), "enabled")) {
                    InterProceduralAnalyses.applyRenamerAnalyses(AST2, body);
                }
                VoidReturnRemover.cleanClass(s2);
            }
        }
    }

    private static void applyRenamerAnalyses(ASTNode AST2, DavaBody body) {
        infoGatheringAnalysis info2 = new infoGatheringAnalysis(body);
        AST2.apply(info2);
        Renamer renamer = new Renamer(info2.getHeuristicSet(), (ASTMethodNode)AST2);
        renamer.rename();
    }
}

