/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST;

import soot.G;
import soot.Singletons;
import soot.Value;
import soot.dava.toolkits.base.AST.ASTAnalysis;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.Expr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.Ref;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;

public class ASTWalker {
    public ASTWalker(Singletons.Global g) {
    }

    public static ASTWalker v() {
        return G.v().soot_dava_toolkits_base_AST_ASTWalker();
    }

    public void walk_stmt(ASTAnalysis a2, Stmt s2) {
        if (a2.getAnalysisDepth() < 1) {
            return;
        }
        if (s2 instanceof DefinitionStmt) {
            DefinitionStmt ds = (DefinitionStmt)s2;
            this.walk_value(a2, ds.getRightOp());
            this.walk_value(a2, ds.getLeftOp());
            a2.analyseDefinitionStmt(ds);
        } else if (s2 instanceof ReturnStmt) {
            ReturnStmt rs = (ReturnStmt)s2;
            this.walk_value(a2, rs.getOp());
            a2.analyseReturnStmt(rs);
        } else if (s2 instanceof InvokeStmt) {
            InvokeStmt is2 = (InvokeStmt)s2;
            this.walk_value(a2, is2.getInvokeExpr());
            a2.analyseInvokeStmt(is2);
        } else if (s2 instanceof ThrowStmt) {
            ThrowStmt ts = (ThrowStmt)s2;
            this.walk_value(a2, ts.getOp());
            a2.analyseThrowStmt(ts);
        } else {
            a2.analyseStmt(s2);
        }
    }

    public void walk_value(ASTAnalysis a2, Value v) {
        if (a2.getAnalysisDepth() < 2) {
            return;
        }
        if (v instanceof Expr) {
            Expr e = (Expr)v;
            if (e instanceof BinopExpr) {
                BinopExpr be2 = (BinopExpr)e;
                this.walk_value(a2, be2.getOp1());
                this.walk_value(a2, be2.getOp2());
                a2.analyseBinopExpr(be2);
            } else if (e instanceof UnopExpr) {
                UnopExpr ue = (UnopExpr)e;
                this.walk_value(a2, ue.getOp());
                a2.analyseUnopExpr(ue);
            } else if (e instanceof CastExpr) {
                CastExpr ce = (CastExpr)e;
                this.walk_value(a2, ce.getOp());
                a2.analyseExpr(ce);
            } else if (e instanceof NewArrayExpr) {
                NewArrayExpr nae = (NewArrayExpr)e;
                this.walk_value(a2, nae.getSize());
                a2.analyseNewArrayExpr(nae);
            } else if (e instanceof NewMultiArrayExpr) {
                NewMultiArrayExpr nmae = (NewMultiArrayExpr)e;
                for (int i = 0; i < nmae.getSizeCount(); ++i) {
                    this.walk_value(a2, nmae.getSize(i));
                }
                a2.analyseNewMultiArrayExpr(nmae);
            } else if (e instanceof InstanceOfExpr) {
                InstanceOfExpr ioe = (InstanceOfExpr)e;
                this.walk_value(a2, ioe.getOp());
                a2.analyseInstanceOfExpr(ioe);
            } else if (e instanceof InvokeExpr) {
                InvokeExpr ie = (InvokeExpr)e;
                for (int i = 0; i < ie.getArgCount(); ++i) {
                    this.walk_value(a2, ie.getArg(i));
                }
                if (ie instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                    this.walk_value(a2, iie.getBase());
                    a2.analyseInstanceInvokeExpr(iie);
                } else {
                    a2.analyseInvokeExpr(ie);
                }
            } else {
                a2.analyseExpr(e);
            }
        } else if (v instanceof Ref) {
            Ref r = (Ref)v;
            if (r instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)r;
                this.walk_value(a2, ar.getBase());
                this.walk_value(a2, ar.getIndex());
                a2.analyseArrayRef(ar);
            } else if (r instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)r;
                this.walk_value(a2, ifr.getBase());
                a2.analyseInstanceFieldRef(ifr);
            } else {
                a2.analyseRef(r);
            }
        } else {
            a2.analyseValue(v);
        }
    }
}

