/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;

abstract class AnnotationElemBuilder
extends AnnotationVisitor {
    protected final ArrayList<AnnotationElem> elems;

    AnnotationElemBuilder(int expected) {
        super(327680);
        this.elems = new ArrayList(expected);
    }

    AnnotationElemBuilder() {
        this(4);
    }

    public AnnotationElem getAnnotationElement(String name, Object value2) {
        AnnotationElem elem;
        if (value2 instanceof Byte) {
            elem = new AnnotationIntElem(((Byte)value2).byteValue(), 'B', name);
        } else if (value2 instanceof Boolean) {
            elem = new AnnotationIntElem((Boolean)value2 != false ? 1 : 0, 'Z', name);
        } else if (value2 instanceof Character) {
            elem = new AnnotationIntElem(((Character)value2).charValue(), 'C', name);
        } else if (value2 instanceof Short) {
            elem = new AnnotationIntElem(((Short)value2).shortValue(), 'S', name);
        } else if (value2 instanceof Integer) {
            elem = new AnnotationIntElem((Integer)value2, 'I', name);
        } else if (value2 instanceof Long) {
            elem = new AnnotationLongElem((Long)value2, 'J', name);
        } else if (value2 instanceof Float) {
            elem = new AnnotationFloatElem(((Float)value2).floatValue(), 'F', name);
        } else if (value2 instanceof Double) {
            elem = new AnnotationDoubleElem((Double)value2, 'D', name);
        } else if (value2 instanceof String) {
            elem = new AnnotationStringElem(value2.toString(), 's', name);
        } else if (value2 instanceof Type) {
            Type t = (Type)value2;
            elem = new AnnotationClassElem(t.getDescriptor(), 'c', name);
        } else if (value2.getClass().isArray()) {
            ArrayList<AnnotationElem> annotationArray = new ArrayList<AnnotationElem>();
            if (value2 instanceof byte[]) {
                byte[] byArray = (byte[])value2;
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    Byte element2 = byArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element2));
                }
            } else if (value2 instanceof boolean[]) {
                boolean[] blArray = (boolean[])value2;
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    Boolean element3 = blArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element3));
                }
            } else if (value2 instanceof char[]) {
                char[] cArray = (char[])value2;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character element4 = Character.valueOf(cArray[i]);
                    annotationArray.add(this.getAnnotationElement(name, element4));
                }
            } else if (value2 instanceof short[]) {
                short[] sArray = (short[])value2;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    Short element5 = sArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element5));
                }
            } else if (value2 instanceof int[]) {
                int[] nArray = (int[])value2;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer element6 = nArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element6));
                }
            } else if (value2 instanceof long[]) {
                long[] lArray = (long[])value2;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long element7 = lArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element7));
                }
            } else if (value2 instanceof float[]) {
                float[] fArray = (float[])value2;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    Float element8 = Float.valueOf(fArray[i]);
                    annotationArray.add(this.getAnnotationElement(name, element8));
                }
            } else if (value2 instanceof double[]) {
                double[] dArray = (double[])value2;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double element9 = dArray[i];
                    annotationArray.add(this.getAnnotationElement(name, element9));
                }
            } else if (value2 instanceof String[]) {
                for (String element10 : (String[])value2) {
                    annotationArray.add(this.getAnnotationElement(name, element10));
                }
            } else if (value2 instanceof Type[]) {
                for (Type element11 : (Type[])value2) {
                    annotationArray.add(this.getAnnotationElement(name, element11));
                }
            } else {
                throw new UnsupportedOperationException("Unsupported array value type: " + value2.getClass());
            }
            elem = new AnnotationArrayElem(annotationArray, '[', name);
        } else {
            throw new UnsupportedOperationException("Unsupported value type: " + value2.getClass());
        }
        return elem;
    }

    @Override
    public void visit(String name, Object value2) {
        AnnotationElem elem = this.getAnnotationElement(name, value2);
        this.elems.add(elem);
    }

    @Override
    public void visitEnum(String name, String desc, String value2) {
        this.elems.add(new AnnotationEnumElem(desc, value2, 'e', name));
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                String ename = name;
                if (ename == null) {
                    ename = "default";
                }
                AnnotationElemBuilder.this.elems.add(new AnnotationArrayElem(this.elems, '[', ename));
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(final String name, final String desc) {
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag tag = new AnnotationTag(desc, this.elems);
                AnnotationElemBuilder.this.elems.add(new AnnotationAnnotationElem(tag, '@', name));
            }
        };
    }

    @Override
    public abstract void visitEnd();
}

