/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import soot.CompilationDeathException;
import soot.G;
import soot.Pack;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Transform;
import soot.options.CGOptions;
import soot.options.Options;
import soot.toolkits.astmetrics.ClassData;

public class Main {
    public static final String versionString = Main.class.getPackage().getImplementationVersion() == null ? "trunk" : Main.class.getPackage().getImplementationVersion();
    private Date start;
    private Date finish;
    public String[] cmdLineArgs = new String[0];

    public Main(Singletons.Global g) {
    }

    public static Main v() {
        return G.v().soot_Main();
    }

    private void printVersion() {
        G.v().out.println("Soot version " + versionString);
        G.v().out.println("Copyright (C) 1997-2010 Raja Vallee-Rai and others.");
        G.v().out.println("All rights reserved.");
        G.v().out.println("");
        G.v().out.println("Contributions are copyright (C) 1997-2010 by their respective contributors.");
        G.v().out.println("See the file 'credits' for a list of contributors.");
        G.v().out.println("See individual source files for details.");
        G.v().out.println("");
        G.v().out.println("Soot comes with ABSOLUTELY NO WARRANTY.  Soot is free software,");
        G.v().out.println("and you are welcome to redistribute it under certain conditions.");
        G.v().out.println("See the accompanying file 'COPYING-LESSER.txt' for details.");
        G.v().out.println();
        G.v().out.println("Visit the Soot website:");
        G.v().out.println("  http://www.sable.mcgill.ca/soot/");
        G.v().out.println();
        G.v().out.println("For a list of command line options, enter:");
        G.v().out.println("  java soot.Main --help");
    }

    private void processCmdLine(String[] args) {
        if (!Options.v().parse(args)) {
            throw new CompilationDeathException(0, "Option parse error");
        }
        if (PackManager.v().onlyStandardPacks()) {
            for (Pack pack : PackManager.v().allPacks()) {
                Options.v().warnForeignPhase(pack.getPhaseName());
                for (Transform tr : pack) {
                    Options.v().warnForeignPhase(tr.getPhaseName());
                }
            }
        }
        Options.v().warnNonexistentPhase();
        if (Options.v().help()) {
            G.v().out.println(Options.v().getUsage());
            throw new CompilationDeathException(1);
        }
        if (Options.v().phase_list()) {
            G.v().out.println(Options.v().getPhaseList());
            throw new CompilationDeathException(1);
        }
        if (!Options.v().phase_help().isEmpty()) {
            for (String phase : Options.v().phase_help()) {
                G.v().out.println(Options.v().getPhaseHelp(phase));
            }
            throw new CompilationDeathException(1);
        }
        if (!Options.v().unfriendly_mode() && args.length == 0 || Options.v().version()) {
            this.printVersion();
            throw new CompilationDeathException(1);
        }
        if (Options.v().on_the_fly()) {
            Options.v().set_whole_program(true);
            PhaseOptions.v().setPhaseOption("cg", "off");
        }
        this.postCmdLineCheck();
    }

    private void postCmdLineCheck() {
        if (Options.v().classes().isEmpty() && Options.v().process_dir().isEmpty()) {
            throw new CompilationDeathException(0, "No input classes specified!");
        }
    }

    public static void main(String[] args) {
        try {
            Main.v().run(args);
        }
        catch (StackOverflowError e) {
            G.v().out.println("Soot has run out of stack memory.");
            G.v().out.println("To allocate more stack memory to Soot, use the -Xss switch to Java.");
            G.v().out.println("For example (for 2MB): java -Xss2m soot.Main ...");
            throw e;
        }
        catch (OutOfMemoryError e) {
            G.v().out.println("Soot has run out of the memory allocated to it by the Java VM.");
            G.v().out.println("To allocate more memory to Soot, use the -Xmx switch to Java.");
            G.v().out.println("For example (for 2GB): java -Xmx2g soot.Main ...");
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bos));
            String stackStraceString = bos.toString();
            try {
                String TRACKER_URL = "https://github.com/Sable/soot/issues/new?";
                String commandLineArgs = Joiner.on(" ").join(args);
                String body = "Steps to reproduce:\n1.) ...\n\nFiles used to reproduce: \n...\n\nSoot version: " + versionString + "\n\n" + "Command line:\n" + commandLineArgs + "\n\nMax Memory:\n" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB\n\nStack trace:\n" + stackStraceString;
                String title = e.getClass().getName() + " when ...";
                StringBuilder sb = new StringBuilder();
                sb.append("\n\nOuuups... something went wrong! Sorry about that.\n");
                sb.append("Follow these steps to fix the problem:\n");
                sb.append("1.) Are you sure you used the right command line?\n");
                sb.append("    Click here to double-check:\n");
                sb.append("    https://ssebuild.cased.de/nightly/soot/doc/soot_options.htm\n");
                sb.append("\n");
                sb.append("2.) Not sure whether it's a bug? Feel free to discuss\n");
                sb.append("    the issue on the Soot mailing list:\n");
                sb.append("    https://github.com/Sable/soot/wiki/Getting-help\n");
                sb.append("\n");
                sb.append("3.) Sure it's a bug? Click this link to report it.\n");
                sb.append("    https://github.com/Sable/soot/issues/new?title=" + URLEncoder.encode(title, "UTF-8") + "&body=" + URLEncoder.encode(body, "UTF-8") + "\n");
                sb.append("    Please be as precise as possible when giving us\n");
                sb.append("    information on how to reproduce the problem. Thanks!");
                System.err.println(sb.toString());
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
        }
    }

    public void run(String[] args) {
        this.cmdLineArgs = args;
        this.start = new Date();
        try {
            Timers.v().totalTimer.start();
            this.processCmdLine(this.cmdLineArgs);
            this.autoSetOptions();
            G.v().out.println("Soot started on " + this.start);
            Scene.v().loadNecessaryClasses();
            if (Options.v().ast_metrics()) {
                try {
                    FileOutputStream streamOut = new FileOutputStream("../astMetrics.xml");
                    PrintWriter writerOut = new PrintWriter(new OutputStreamWriter(streamOut));
                    writerOut.println("<?xml version='1.0'?>");
                    writerOut.println("<ASTMetrics>");
                    for (ClassData cData : G.v().ASTMetricsData) {
                        writerOut.println(cData.toString());
                    }
                    writerOut.println("</ASTMetrics>");
                    writerOut.flush();
                    ((OutputStream)streamOut).close();
                }
                catch (IOException e) {
                    throw new CompilationDeathException("Cannot output file astMetrics", e);
                }
                return;
            }
            PackManager.v().runPacks();
            if (!Options.v().oaat()) {
                PackManager.v().writeOutput();
            }
            Timers.v().totalTimer.end();
            if (Options.v().time()) {
                Timers.v().printProfilingInformation();
            }
        }
        catch (CompilationDeathException e) {
            Timers.v().totalTimer.end();
            if (e.getStatus() != 1) {
                throw e;
            }
            return;
        }
        this.finish = new Date();
        G.v().out.println("Soot finished on " + this.finish);
        long runtime = this.finish.getTime() - this.start.getTime();
        G.v().out.println("Soot has run for " + runtime / 60000L + " min. " + runtime % 60000L / 1000L + " sec.");
    }

    public void autoSetOptions() {
        CGOptions cgOptions;
        String log;
        if (Options.v().no_bodies_for_excluded()) {
            Options.v().set_allow_phantom_refs(true);
        }
        if ((log = (cgOptions = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"))).reflection_log()) != null && log.length() > 0) {
            Options.v().set_allow_phantom_refs(true);
        }
        if (Options.v().allow_phantom_refs()) {
            PhaseOptions.v().setPhaseOption("jb.tr", "ignore-wrong-staticness:true");
        }
    }
}

