/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public interface SimpleSet {
    public static final SimpleSet emptySet = new SimpleSet(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public SimpleSet add(Object o) {
            if (o instanceof SimpleSet) {
                return (SimpleSet)o;
            }
            return new SimpleSetImpl().add(o);
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public boolean isSingleton(Object o) {
            return false;
        }
    };
    public static final SimpleSet fullSet = new SimpleSet(){

        @Override
        public int size() {
            throw new Error("Operation size not supported on the full set");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public SimpleSet add(Object o) {
            return this;
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator iterator() {
            throw new Error("Operation iterator not support on the full set");
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public boolean isSingleton(Object o) {
            return false;
        }
    };

    public int size();

    public boolean isEmpty();

    public SimpleSet add(Object var1);

    public Iterator iterator();

    public boolean contains(Object var1);

    public boolean isSingleton();

    public boolean isSingleton(Object var1);

    public static class SimpleSetImpl
    implements SimpleSet {
        private HashSet internalSet;

        public SimpleSetImpl() {
            this.internalSet = new HashSet(4);
        }

        public SimpleSetImpl(Collection c) {
            this.internalSet = new HashSet(c.size());
            this.internalSet.addAll(c);
        }

        private SimpleSetImpl(SimpleSetImpl set2) {
            this.internalSet = new HashSet(set2.internalSet);
        }

        @Override
        public int size() {
            return this.internalSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.internalSet.isEmpty();
        }

        @Override
        public SimpleSet add(Object o) {
            if (this.internalSet.contains(o)) {
                return this;
            }
            SimpleSetImpl set2 = new SimpleSetImpl(this);
            set2.internalSet.add(o);
            return set2;
        }

        @Override
        public Iterator iterator() {
            return this.internalSet.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.internalSet.contains(o);
        }

        @Override
        public boolean isSingleton() {
            return this.internalSet.size() == 1;
        }

        @Override
        public boolean isSingleton(Object o) {
            return this.isSingleton() && this.contains(o);
        }
    }
}

