/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Expr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Unary;
import soot.JastAddJ.Variable;

public abstract class PostfixExpr
extends Unary
implements Cloneable {
    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public PostfixExpr clone() throws CloneNotSupportedException {
        PostfixExpr node = (PostfixExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void definiteAssignment() {
        Variable v;
        if (this.getOperand().isVariable() && (v = this.getOperand().varDecl()) != null && v.isFinal()) {
            this.error("++ and -- can not be applied to final variable " + v);
        }
    }

    @Override
    protected boolean checkDUeverywhere(Variable v) {
        if (this.getOperand().isVariable() && this.getOperand().varDecl() == v && !this.isDAbefore(v)) {
            return false;
        }
        return super.checkDUeverywhere(v);
    }

    @Override
    public void typeCheck() {
        if (!this.getOperand().isVariable()) {
            this.error("postfix expressions only work on variables");
        } else if (!this.getOperand().type().isNumericType()) {
            this.error("postfix expressions only operates on numeric types");
        }
    }

    public PostfixExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public PostfixExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        if (caller == this.getOperandNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    @Override
    public boolean Define_boolean_isIncOrDec(ASTNode caller, ASTNode child) {
        if (caller == this.getOperandNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isIncOrDec(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getOperandNoTransform()) {
            return NameType.EXPRESSION_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

