/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.BooleanLiteral;
import soot.JastAddJ.Constant;
import soot.JastAddJ.DoubleLiteral;
import soot.JastAddJ.FloatingPointLiteral;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.LongLiteral;
import soot.JastAddJ.PrimaryExpr;
import soot.JastAddJ.StringLiteral;

public abstract class Literal
extends PrimaryExpr
implements Cloneable {
    protected String tokenString_LITERAL;
    public int LITERALstart;
    public int LITERALend;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Literal clone() throws CloneNotSupportedException {
        Literal node = (Literal)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public static Literal buildBooleanLiteral(boolean value2) {
        return new BooleanLiteral(value2 ? "true" : "false");
    }

    public static Literal buildStringLiteral(String value2) {
        return new StringLiteral(value2);
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.getLITERAL());
    }

    protected static String escape(String s2) {
        StringBuffer result2 = new StringBuffer();
        block10: for (int i = 0; i < s2.length(); ++i) {
            switch (s2.charAt(i)) {
                case '\b': {
                    result2.append("\\b");
                    continue block10;
                }
                case '\t': {
                    result2.append("\\t");
                    continue block10;
                }
                case '\n': {
                    result2.append("\\n");
                    continue block10;
                }
                case '\f': {
                    result2.append("\\f");
                    continue block10;
                }
                case '\r': {
                    result2.append("\\r");
                    continue block10;
                }
                case '\"': {
                    result2.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result2.append("\\'");
                    continue block10;
                }
                case '\\': {
                    result2.append("\\\\");
                    continue block10;
                }
                default: {
                    char value2 = s2.charAt(i);
                    if (value2 < ' ' || value2 > '~') {
                        result2.append(Literal.asEscape(value2));
                        continue block10;
                    }
                    result2.append(s2.charAt(i));
                }
            }
        }
        return result2.toString();
    }

    protected static String asEscape(int value2) {
        StringBuffer s2 = new StringBuffer("\\u");
        String hex = Integer.toHexString(value2);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            s2.append("0");
        }
        s2.append(hex);
        return s2.toString();
    }

    public Literal() {
    }

    @Override
    public void init$Children() {
    }

    public Literal(String p0) {
        this.setLITERAL(p0);
    }

    public Literal(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value2) {
        this.tokenString_LITERAL = value2;
    }

    public void setLITERAL(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol2.value;
        this.LITERALstart = symbol2.getStart();
        this.LITERALend = symbol2.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public static Literal buildDoubleLiteral(double value2) {
        String digits = Double.toString(value2);
        DoubleLiteral lit = new DoubleLiteral(digits);
        lit.setDigits(digits);
        lit.setKind(0);
        return lit;
    }

    public static Literal buildFloatLiteral(float value2) {
        String digits = Float.toString(value2);
        FloatingPointLiteral lit = new FloatingPointLiteral(digits);
        lit.setDigits(digits);
        lit.setKind(0);
        return lit;
    }

    public static Literal buildIntegerLiteral(int value2) {
        String digits = Integer.toHexString(value2);
        IntegerLiteral lit = new IntegerLiteral("0x" + digits);
        lit.setDigits(digits.toLowerCase());
        lit.setKind(1);
        return lit;
    }

    public static Literal buildLongLiteral(long value2) {
        String digits = Long.toHexString(value2);
        LongLiteral lit = new LongLiteral("0x" + digits);
        lit.setDigits(digits.toLowerCase());
        lit.setKind(1);
        return lit;
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getLITERAL() + "]";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

