/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.ImportDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.ParTypeDecl;
import soot.JastAddJ.Problem;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.SingleStaticImportDecl;
import soot.JastAddJ.SingleTypeImportDecl;
import soot.JastAddJ.TypeDecl;

public class CompilationUnit
extends ASTNode<ASTNode>
implements Cloneable {
    private String relativeName;
    private String pathName;
    private boolean fromSource;
    protected ArrayList errors = new ArrayList();
    protected ArrayList warnings = new ArrayList();
    protected Collection parseErrors = new ArrayList();
    public boolean isResolved = false;
    protected String tokenjava_lang_String_PackageDecl;
    public int PackageDeclstart;
    public int PackageDeclend;
    protected boolean packageName_computed = false;
    protected String packageName_value;
    protected Map lookupType_String_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.packageName_computed = false;
        this.packageName_value = null;
        this.lookupType_String_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public CompilationUnit clone() throws CloneNotSupportedException {
        CompilationUnit node = (CompilationUnit)super.clone();
        node.packageName_computed = false;
        node.packageName_value = null;
        node.lookupType_String_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public CompilationUnit copy() {
        try {
            CompilationUnit node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public CompilationUnit fullCopy() {
        CompilationUnit tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public void setRelativeName(String name) {
        this.relativeName = name;
    }

    public void setPathName(String name) {
        this.pathName = name;
    }

    public void setFromSource(boolean value2) {
        this.fromSource = value2;
    }

    public Collection parseErrors() {
        return this.parseErrors;
    }

    public void addParseError(Problem msg) {
        this.parseErrors.add(msg);
    }

    public void errorCheck(Collection collection) {
        this.collectErrors();
        collection.addAll(this.errors);
    }

    public void errorCheck(Collection err, Collection warn) {
        this.collectErrors();
        err.addAll(this.errors);
        warn.addAll(this.warnings);
    }

    public void refined_NameCheck_CompilationUnit_nameCheck() {
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            ImportDecl decl = this.getImportDecl(i);
            if (!(decl instanceof SingleTypeImportDecl)) continue;
            TypeDecl importedType = decl.getAccess().type();
            Iterator iter2 = this.localLookupType(importedType.name()).iterator();
            while (iter2.hasNext()) {
                TypeDecl local = (TypeDecl)iter2.next();
                if (local == importedType) continue;
                this.error("imported type " + decl + " is conflicting with visible type");
            }
        }
    }

    @Override
    public void toString(StringBuffer s2) {
        try {
            int i;
            if (!this.getPackageDecl().equals("")) {
                s2.append("package " + this.getPackageDecl() + ";\n");
            }
            for (i = 0; i < this.getNumImportDecl(); ++i) {
                this.getImportDecl(i).toString(s2);
            }
            for (i = 0; i < this.getNumTypeDecl(); ++i) {
                this.getTypeDecl(i).toString(s2);
                s2.append("\n");
            }
        }
        catch (NullPointerException e) {
            System.out.print("Error in compilation unit hosting " + this.getTypeDecl(0).typeName());
            throw e;
        }
    }

    @Override
    public void transformation() {
        if (this.fromSource()) {
            for (int i = 0; i < this.getNumTypeDecl(); ++i) {
                this.getTypeDecl(i).transformation();
            }
        }
    }

    public CompilationUnit() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new List(), 0);
        this.setChild(new List(), 1);
    }

    public CompilationUnit(String p0, List<ImportDecl> p1, List<TypeDecl> p2) {
        this.setPackageDecl(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    public CompilationUnit(Symbol p0, List<ImportDecl> p1, List<TypeDecl> p2) {
        this.setPackageDecl(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPackageDecl(String value2) {
        this.tokenjava_lang_String_PackageDecl = value2;
    }

    public void setPackageDecl(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setPackageDecl is only valid for String lexemes");
        }
        this.tokenjava_lang_String_PackageDecl = (String)symbol2.value;
        this.PackageDeclstart = symbol2.getStart();
        this.PackageDeclend = symbol2.getEnd();
    }

    public String getPackageDecl() {
        return this.tokenjava_lang_String_PackageDecl != null ? this.tokenjava_lang_String_PackageDecl : "";
    }

    public void setImportDeclList(List<ImportDecl> list) {
        this.setChild(list, 0);
    }

    public int getNumImportDecl() {
        return this.getImportDeclList().getNumChild();
    }

    public int getNumImportDeclNoTransform() {
        return this.getImportDeclListNoTransform().getNumChildNoTransform();
    }

    public ImportDecl getImportDecl(int i) {
        return (ImportDecl)this.getImportDeclList().getChild(i);
    }

    public void addImportDecl(ImportDecl node) {
        List<ImportDecl> list = this.parent == null || state == null ? this.getImportDeclListNoTransform() : this.getImportDeclList();
        list.addChild(node);
    }

    public void addImportDeclNoTransform(ImportDecl node) {
        List<ImportDecl> list = this.getImportDeclListNoTransform();
        list.addChild(node);
    }

    public void setImportDecl(ImportDecl node, int i) {
        List<ImportDecl> list = this.getImportDeclList();
        list.setChild(node, i);
    }

    public List<ImportDecl> getImportDecls() {
        return this.getImportDeclList();
    }

    public List<ImportDecl> getImportDeclsNoTransform() {
        return this.getImportDeclListNoTransform();
    }

    public List<ImportDecl> getImportDeclList() {
        List list = (List)this.getChild(0);
        list.getNumChild();
        return list;
    }

    public List<ImportDecl> getImportDeclListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    public void setTypeDeclList(List<TypeDecl> list) {
        this.setChild(list, 1);
    }

    public int getNumTypeDecl() {
        return this.getTypeDeclList().getNumChild();
    }

    public int getNumTypeDeclNoTransform() {
        return this.getTypeDeclListNoTransform().getNumChildNoTransform();
    }

    public TypeDecl getTypeDecl(int i) {
        return (TypeDecl)this.getTypeDeclList().getChild(i);
    }

    public void addTypeDecl(TypeDecl node) {
        List<TypeDecl> list = this.parent == null || state == null ? this.getTypeDeclListNoTransform() : this.getTypeDeclList();
        list.addChild(node);
    }

    public void addTypeDeclNoTransform(TypeDecl node) {
        List<TypeDecl> list = this.getTypeDeclListNoTransform();
        list.addChild(node);
    }

    public void setTypeDecl(TypeDecl node, int i) {
        List<TypeDecl> list = this.getTypeDeclList();
        list.setChild(node, i);
    }

    public List<TypeDecl> getTypeDecls() {
        return this.getTypeDeclList();
    }

    public List<TypeDecl> getTypeDeclsNoTransform() {
        return this.getTypeDeclListNoTransform();
    }

    public List<TypeDecl> getTypeDeclList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<TypeDecl> getTypeDeclListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    @Override
    public void nameCheck() {
        this.refined_NameCheck_CompilationUnit_nameCheck();
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            String name;
            SingleStaticImportDecl decl;
            if (!(this.getImportDecl(i) instanceof SingleStaticImportDecl) || (decl = (SingleStaticImportDecl)this.getImportDecl(i)).importedTypes(name = decl.name()).isEmpty()) continue;
            TypeDecl type = (TypeDecl)decl.importedTypes(name).iterator().next();
            if (!this.localLookupType(name).contains(type)) continue;
            decl.error(this.packageName() + "." + name + " is already defined in this compilation unit");
        }
    }

    private SimpleSet refined_TypeScopePropagation_CompilationUnit_Child_lookupType_String(String name) {
        SimpleSet set2 = this.localLookupType(name);
        if (!set2.isEmpty()) {
            return set2;
        }
        set2 = this.importedTypes(name);
        if (!set2.isEmpty()) {
            return set2;
        }
        TypeDecl result2 = this.lookupType(this.packageName(), name);
        if (result2 != null && result2.accessibleFromPackage(this.packageName())) {
            return SimpleSet.emptySet.add(result2);
        }
        set2 = this.importedTypesOnDemand(name);
        if (!set2.isEmpty()) {
            return set2;
        }
        result2 = this.lookupType("@primitive", name);
        if (result2 != null) {
            return SimpleSet.emptySet.add(result2);
        }
        result2 = this.lookupType("java.lang", name);
        if (result2 != null && result2.accessibleFromPackage(this.packageName())) {
            return SimpleSet.emptySet.add(result2);
        }
        return this.lookupType(name);
    }

    public String relativeName() {
        ASTNode$State state = this.state();
        return this.relativeName;
    }

    public String pathName() {
        ASTNode$State state = this.state();
        return this.pathName;
    }

    public boolean fromSource() {
        ASTNode$State state = this.state();
        return this.fromSource;
    }

    public SimpleSet localLookupType(String name) {
        ASTNode$State state = this.state();
        for (int i = 0; i < this.getNumTypeDecl(); ++i) {
            if (!this.getTypeDecl(i).name().equals(name)) continue;
            return SimpleSet.emptySet.add(this.getTypeDecl(i));
        }
        return SimpleSet.emptySet;
    }

    public SimpleSet importedTypes(String name) {
        ASTNode$State state = this.state();
        SimpleSet set2 = SimpleSet.emptySet;
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (this.getImportDecl(i).isOnDemand()) continue;
            Iterator iter2 = this.getImportDecl(i).importedTypes(name).iterator();
            while (iter2.hasNext()) {
                set2 = set2.add(iter2.next());
            }
        }
        return set2;
    }

    public SimpleSet importedTypesOnDemand(String name) {
        ASTNode$State state = this.state();
        SimpleSet set2 = SimpleSet.emptySet;
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (!this.getImportDecl(i).isOnDemand()) continue;
            Iterator iter2 = this.getImportDecl(i).importedTypes(name).iterator();
            while (iter2.hasNext()) {
                set2 = set2.add(iter2.next());
            }
        }
        return set2;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getPackageDecl() + "]";
    }

    public String packageName() {
        if (this.packageName_computed) {
            return this.packageName_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.packageName_value = this.packageName_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.packageName_computed = true;
        }
        return this.packageName_value;
    }

    private String packageName_compute() {
        return this.getPackageDecl();
    }

    public SimpleSet importedFields(String name) {
        ASTNode$State state = this.state();
        SimpleSet set2 = SimpleSet.emptySet;
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (this.getImportDecl(i).isOnDemand()) continue;
            Iterator iter2 = this.getImportDecl(i).importedFields(name).iterator();
            while (iter2.hasNext()) {
                set2 = set2.add(iter2.next());
            }
        }
        return set2;
    }

    public SimpleSet importedFieldsOnDemand(String name) {
        ASTNode$State state = this.state();
        SimpleSet set2 = SimpleSet.emptySet;
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (!this.getImportDecl(i).isOnDemand()) continue;
            Iterator iter2 = this.getImportDecl(i).importedFields(name).iterator();
            while (iter2.hasNext()) {
                set2 = set2.add(iter2.next());
            }
        }
        return set2;
    }

    public Collection importedMethods(String name) {
        ASTNode$State state = this.state();
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (this.getImportDecl(i).isOnDemand()) continue;
            list.addAll(this.getImportDecl(i).importedMethods(name));
        }
        return list;
    }

    public Collection importedMethodsOnDemand(String name) {
        ASTNode$State state = this.state();
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.getNumImportDecl(); ++i) {
            if (!this.getImportDecl(i).isOnDemand()) continue;
            list.addAll(this.getImportDecl(i).importedMethods(name));
        }
        return list;
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        ASTNode$State state = this.state();
        TypeDecl lookupType_String_String_value = this.getParent().Define_TypeDecl_lookupType(this, null, packageName, typeName);
        return lookupType_String_String_value;
    }

    public SimpleSet lookupType(String name) {
        String _parameters = name;
        if (this.lookupType_String_values == null) {
            this.lookupType_String_values = new HashMap(4);
        }
        if (this.lookupType_String_values.containsKey(_parameters)) {
            return (SimpleSet)this.lookupType_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        SimpleSet lookupType_String_value = this.getParent().Define_SimpleSet_lookupType(this, null, name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.lookupType_String_values.put(_parameters, lookupType_String_value);
        }
        return lookupType_String_value;
    }

    public SimpleSet lookupVariable(String name) {
        ASTNode$State state = this.state();
        SimpleSet lookupVariable_String_value = this.getParent().Define_SimpleSet_lookupVariable(this, null, name);
        return lookupVariable_String_value;
    }

    public Collection lookupMethod(String name) {
        ASTNode$State state = this.state();
        Collection lookupMethod_String_value = this.getParent().Define_Collection_lookupMethod(this, null, name);
        return lookupMethod_String_value;
    }

    @Override
    public CompilationUnit Define_CompilationUnit_compilationUnit(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this;
    }

    @Override
    public boolean Define_boolean_isIncOrDec(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isIncOrDec(this, caller);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getImportDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return !exceptionType.isUncheckedException();
        }
        if (caller == this.getTypeDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return !exceptionType.isUncheckedException();
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getImportDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.lookupType(name);
        }
        int childIndex = this.getIndexOfChild(caller);
        SimpleSet result2 = SimpleSet.emptySet;
        Iterator iter2 = this.refined_TypeScopePropagation_CompilationUnit_Child_lookupType_String(name).iterator();
        while (iter2.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter2.next();
            if (typeDecl instanceof ParTypeDecl) {
                result2 = result2.add(((ParTypeDecl)((Object)typeDecl)).genericDecl());
                continue;
            }
            result2 = result2.add(typeDecl);
        }
        return result2;
    }

    @Override
    public SimpleSet Define_SimpleSet_allImportedTypes(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getImportDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.importedTypes(name);
        }
        return this.getParent().Define_SimpleSet_allImportedTypes(this, caller, name);
    }

    @Override
    public String Define_String_packageName(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.packageName();
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getImportDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return NameType.PACKAGE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return null;
    }

    @Override
    public boolean Define_boolean_isNestedType(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public boolean Define_boolean_isMemberType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return false;
        }
        return this.getParent().Define_boolean_isMemberType(this, caller);
    }

    @Override
    public boolean Define_boolean_isLocalClass(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return false;
    }

    @Override
    public String Define_String_hostPackage(ASTNode caller, ASTNode child) {
        int childIndex = this.getIndexOfChild(caller);
        return this.packageName();
    }

    @Override
    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        if (caller == this.getImportDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return null;
        }
        return this.getParent().Define_TypeDecl_hostType(this, caller);
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getTypeDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            SimpleSet set2 = this.importedFields(name);
            if (!set2.isEmpty()) {
                return set2;
            }
            set2 = this.importedFieldsOnDemand(name);
            if (!set2.isEmpty()) {
                return set2;
            }
            return this.lookupVariable(name);
        }
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    @Override
    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getTypeDeclListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            Collection list = this.importedMethods(name);
            if (!list.isEmpty()) {
                return list;
            }
            list = this.importedMethodsOnDemand(name);
            if (!list.isEmpty()) {
                return list;
            }
            return this.lookupMethod(name);
        }
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

