/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.CompilationDeathException;
import soot.G;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.Problem;
import soot.JastAddJ.Program;
import soot.JastAddJ.TypeDecl;
import soot.MethodSource;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.javaToJimple.IInitialResolver;

public class JastAddInitialResolver
implements IInitialResolver {
    protected Map<String, CompilationUnit> classNameToCU = new HashMap<String, CompilationUnit>();

    public JastAddInitialResolver(Singletons.Global g) {
    }

    public static JastAddInitialResolver v() {
        return G.v().soot_JastAddInitialResolver();
    }

    @Override
    public void formAst(String fullPath, List<String> locations, String className) {
        Program program = SootResolver.v().getProgram();
        CompilationUnit u = program.getCachedOrLoadCompilationUnit(fullPath);
        if (u != null && !u.isResolved) {
            u.isResolved = true;
            ArrayList errors = new ArrayList();
            u.errorCheck(errors);
            if (!errors.isEmpty()) {
                for (Problem p : errors) {
                    G.v().out.println(p);
                }
                throw new CompilationDeathException(0, "there were errors during parsing and/or type checking (JastAdd frontend)");
            }
            u.transformation();
            u.jimplify1phase1();
            u.jimplify1phase2();
            HashSet<SootClass> types = new HashSet<SootClass>();
            for (TypeDecl typeDecl : u.getTypeDecls()) {
                this.collectTypeDecl(typeDecl, types);
            }
            if (types.isEmpty()) {
                this.classNameToCU.put(className, u);
            } else {
                for (SootClass sc : types) {
                    this.classNameToCU.put(sc.getName(), u);
                }
            }
        }
    }

    private void collectTypeDecl(TypeDecl typeDecl, HashSet<SootClass> types) {
        types.add(typeDecl.getSootClassDecl());
        for (TypeDecl nestedType : typeDecl.nestedTypes()) {
            this.collectTypeDecl(nestedType, types);
        }
    }

    private TypeDecl findNestedTypeDecl(TypeDecl typeDecl, SootClass sc) {
        if (typeDecl.sootClass() == sc) {
            return typeDecl;
        }
        for (TypeDecl nestedType : typeDecl.nestedTypes()) {
            TypeDecl t = this.findNestedTypeDecl(nestedType, sc);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public IInitialResolver.Dependencies resolveFromJavaFile(SootClass sootclass) {
        CompilationUnit u = this.classNameToCU.get(sootclass.getName());
        if (u == null) {
            throw new RuntimeException("Error: couldn't find class: " + sootclass.getName() + " are the packages set properly?");
        }
        HashSet<SootClass> types = new HashSet<SootClass>();
        for (TypeDecl typeDecl : u.getTypeDecls()) {
            this.collectTypeDecl(typeDecl, types);
        }
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        u.collectTypesToHierarchy(deps.typesToHierarchy);
        u.collectTypesToSignatures(deps.typesToSignature);
        for (SootClass sc : types) {
            for (SootMethod m : sc.getMethods()) {
                m.setSource(new MethodSource(){

                    @Override
                    public Body getBody(SootMethod m, String phaseName) {
                        SootClass sc = m.getDeclaringClass();
                        CompilationUnit u = JastAddInitialResolver.this.classNameToCU.get(sc.getName());
                        for (TypeDecl typeDecl : u.getTypeDecls()) {
                            if ((typeDecl = JastAddInitialResolver.this.findNestedTypeDecl(typeDecl, sc)) == null) continue;
                            if (typeDecl.clinit == m) {
                                typeDecl.jimplify2clinit();
                                return m.getActiveBody();
                            }
                            for (BodyDecl bodyDecl : typeDecl.getBodyDecls()) {
                                if (bodyDecl instanceof MethodDecl) {
                                    MethodDecl methodDecl = (MethodDecl)bodyDecl;
                                    if (!m.equals(methodDecl.sootMethod)) continue;
                                    methodDecl.jimplify2();
                                    return m.getActiveBody();
                                }
                                if (!(bodyDecl instanceof ConstructorDecl)) continue;
                                ConstructorDecl constrDecl = (ConstructorDecl)bodyDecl;
                                if (!m.equals(constrDecl.sootMethod)) continue;
                                constrDecl.jimplify2();
                                return m.getActiveBody();
                            }
                        }
                        throw new RuntimeException("Could not find body for " + m.getSignature() + " in " + m.getDeclaringClass().getName());
                    }
                });
            }
        }
        return deps;
    }
}

