/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.HashSet;
import soot.AttributesUnitPrinter;
import soot.Local;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.IdentityRef;
import soot.jimple.Jimple;

public abstract class AbstractUnitPrinter
implements UnitPrinter {
    protected boolean startOfLine = true;
    protected String indent = "        ";
    protected StringBuffer output = new StringBuffer();
    protected AttributesUnitPrinter pt;
    protected HashSet<String> quotableLocals;

    @Override
    public void setPositionTagger(AttributesUnitPrinter pt) {
        this.pt = pt;
        pt.setUnitPrinter(this);
    }

    @Override
    public AttributesUnitPrinter getPositionTagger() {
        return this.pt;
    }

    @Override
    public void startUnit(Unit u) {
        this.handleIndent();
        if (this.pt != null) {
            this.pt.startUnit(u);
        }
    }

    @Override
    public void endUnit(Unit u) {
        if (this.pt != null) {
            this.pt.endUnit(u);
        }
    }

    @Override
    public void startUnitBox(UnitBox ub) {
        this.handleIndent();
    }

    @Override
    public void endUnitBox(UnitBox ub) {
    }

    @Override
    public void startValueBox(ValueBox vb) {
        this.handleIndent();
        if (this.pt != null) {
            this.pt.startValueBox(vb);
        }
    }

    @Override
    public void endValueBox(ValueBox vb) {
        if (this.pt != null) {
            this.pt.endValueBox(vb);
        }
    }

    @Override
    public void noIndent() {
        this.startOfLine = false;
    }

    @Override
    public void incIndent() {
        this.indent = this.indent + "    ";
    }

    @Override
    public void decIndent() {
        if (this.indent.length() >= 4) {
            this.indent = this.indent.substring(4);
        }
    }

    @Override
    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public String getIndent() {
        return this.indent;
    }

    @Override
    public abstract void literal(String var1);

    @Override
    public abstract void type(Type var1);

    @Override
    public abstract void methodRef(SootMethodRef var1);

    @Override
    public abstract void fieldRef(SootFieldRef var1);

    @Override
    public abstract void identityRef(IdentityRef var1);

    @Override
    public abstract void unitRef(Unit var1, boolean var2);

    @Override
    public void newline() {
        this.output.append("\n");
        this.startOfLine = true;
        if (this.pt != null) {
            this.pt.newline();
        }
    }

    @Override
    public void local(Local l) {
        this.handleIndent();
        if (this.quotableLocals == null) {
            this.initializeQuotableLocals();
        }
        if (this.quotableLocals.contains(l.getName())) {
            this.output.append("'" + l.getName() + "'");
        } else {
            this.output.append(l.getName());
        }
    }

    @Override
    public void constant(Constant c) {
        this.handleIndent();
        this.output.append(c.toString());
    }

    public String toString() {
        String ret = this.output.toString();
        this.output = new StringBuffer();
        return ret;
    }

    @Override
    public StringBuffer output() {
        return this.output;
    }

    protected void handleIndent() {
        if (this.startOfLine) {
            this.output.append(this.indent);
        }
        this.startOfLine = false;
    }

    protected void initializeQuotableLocals() {
        this.quotableLocals = new HashSet();
        this.quotableLocals.addAll(Jimple.jimpleKeywordList());
    }
}

