/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.LinkedList;
import soot.G;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;

class AbstractSootFieldRef
implements SootFieldRef {
    private final SootClass declaringClass;
    private final String name;
    private final Type type;
    private final boolean isStatic;

    public AbstractSootFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
        if (declaringClass == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null class");
        }
        if (name == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null name");
        }
        if (type == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null type");
        }
    }

    @Override
    public SootClass declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public String getSignature() {
        return SootField.getSignature(this.declaringClass, this.name, this.type);
    }

    @Override
    public SootField resolve() {
        return this.resolve(null);
    }

    private SootField checkStatic(SootField ret) {
        if (ret.isStatic() != this.isStatic() && !ret.isPhantom() && !TypeAssigner.v().ignoreWrongStaticNess()) {
            throw new ResolutionFailedException("Resolved " + this + " to " + ret + " which has wrong static-ness");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SootField resolve(StringBuffer trace) {
        SootClass cl = this.declaringClass;
        while (true) {
            SootField clField;
            if (trace != null) {
                trace.append("Looking in " + cl + " which has fields " + cl.getFields() + "\n");
            }
            if ((clField = cl.getFieldUnsafe(this.name, this.type)) != null) {
                return this.checkStatic(clField);
            }
            if (Scene.v().allowsPhantomRefs() && cl.isPhantom()) {
                SootField f = new SootField(this.name, this.type, this.isStatic() ? 8 : 0);
                f.setPhantom(true);
                SootClass sootClass = cl;
                synchronized (sootClass) {
                    clField = cl.getFieldUnsafe(this.name, this.type);
                    if (clField != null) {
                        return this.checkStatic(clField);
                    }
                    cl.addField(f);
                    return f;
                }
            }
            LinkedList<SootClass> queue = new LinkedList<SootClass>();
            queue.addAll(cl.getInterfaces());
            while (!queue.isEmpty()) {
                SootField ifaceField;
                SootClass iface = (SootClass)queue.removeFirst();
                if (trace != null) {
                    trace.append("Looking in " + iface + " which has fields " + iface.getFields() + "\n");
                }
                if ((ifaceField = iface.getFieldUnsafe(this.name, this.type)) != null) {
                    return this.checkStatic(ifaceField);
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        if (Options.v().allow_phantom_refs()) {
            SootField sf = new SootField(this.name, this.type, this.isStatic ? 8 : 0);
            sf.setPhantom(true);
            SootClass sootClass = this.declaringClass;
            synchronized (sootClass) {
                SootField clField = cl.getFieldUnsafe(this.name, this.type);
                if (clField != null) {
                    return this.checkStatic(clField);
                }
                this.declaringClass.addField(sf);
                return sf;
            }
        }
        if (trace == null) {
            FieldResolutionFailedException e = new FieldResolutionFailedException();
            if (Options.v().ignore_resolution_errors()) {
                G.v().out.println(e.getMessage());
            } else {
                throw e;
            }
        }
        return null;
    }

    public String toString() {
        return this.getSignature();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result2 = 31 * result2 + (this.isStatic ? 1231 : 1237);
        result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
        result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSootFieldRef other = (AbstractSootFieldRef)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public class FieldResolutionFailedException
    extends ResolutionFailedException {
        private static final long serialVersionUID = -4657113720516199499L;

        public FieldResolutionFailedException() {
            super("Class " + AbstractSootFieldRef.this.declaringClass + " doesn't have field " + AbstractSootFieldRef.this.name + " : " + AbstractSootFieldRef.this.type + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(super.toString());
            AbstractSootFieldRef.this.resolve(ret);
            return ret.toString();
        }
    }
}

