/*
 * Decompiled with CFR 0.152.
 */
package ppg.spec;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import ppg.PPG;
import ppg.PPGError;
import ppg.atoms.GrammarPart;
import ppg.atoms.Nonterminal;
import ppg.atoms.Production;
import ppg.atoms.SemanticAction;
import ppg.atoms.SymbolList;
import ppg.cmds.Command;
import ppg.cmds.DropCmd;
import ppg.cmds.ExtendCmd;
import ppg.cmds.NewProdCmd;
import ppg.cmds.OverrideCmd;
import ppg.cmds.TransferCmd;
import ppg.code.ScanCode;
import ppg.lex.Lexer;
import ppg.parse.Parser;
import ppg.spec.CUPSpec;
import ppg.spec.Spec;
import ppg.util.CodeWriter;

public class PPGSpec
extends Spec {
    private String include;
    private Vector commands;
    private Vector code;
    private Spec parent;
    private Vector startSyms;

    public PPGSpec(String incFile, String pkg, Vector imp, Vector codeParts, Vector syms, Vector precedence, Vector startList, Vector cmds) {
        this.include = incFile;
        this.packageName = pkg;
        this.imports = imp;
        this.code = codeParts;
        this.symbols = syms;
        this.prec = precedence;
        this.startSyms = startList;
        this.commands = cmds;
        this.parent = null;
    }

    public boolean isMultiStartSymbol() {
        return this.startSyms.size() > 1;
    }

    public void patchMultiStartSymbols(CUPSpec cupSpec) {
        String token;
        if (!this.isMultiStartSymbol()) {
            cupSpec.setStart((String)this.startSyms.elementAt(0));
            return;
        }
        String parseCode = "";
        String currSymbolName = "ppg_curr_sym";
        parseCode = parseCode + "Symbol " + currSymbolName + ";\n\n";
        Vector<String> tokens = new Vector<String>();
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            tokens.addElement(new String("JLGEN_TOKEN_" + String.valueOf(i / 2)));
        }
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            String startSym = (String)this.startSyms.elementAt(i);
            String method = (String)this.startSyms.elementAt(i + 1);
            token = (String)tokens.elementAt(i / 2);
            parseCode = parseCode + "public Symbol " + method + " () throws Exception {\n" + "\t" + currSymbolName + " = " + "new Symbol(" + PPG.SYMBOL_CLASS_NAME + "." + token + ")" + ";\n" + "\t" + "return parse();\n}\n\n";
        }
        cupSpec.parserCode.append(parseCode);
        String scanCodeAdd = "\n// scan code generated by PPG\nif (" + currSymbolName + "!= null) {\n" + "\tSymbol result = " + currSymbolName + ";\n" + "\t" + currSymbolName + " = null" + ";\n" + "\treturn result;\n" + "}\n" + "// end scan code generated by PPG\n\n";
        if (cupSpec.scanCode != null) {
            cupSpec.scanCode.prepend(scanCodeAdd);
        } else {
            cupSpec.scanCode = new ScanCode(scanCodeAdd);
        }
        String newStartSym = "multi_start_symbool";
        cupSpec.setStart(newStartSym);
        Nonterminal startNT = new Nonterminal(newStartSym, null);
        Vector<String> newSymbols = new Vector<String>();
        newSymbols.addElement(newStartSym);
        SymbolList sl = new SymbolList(1, null, newSymbols);
        Vector<SymbolList> addedSymbols = new Vector<SymbolList>();
        addedSymbols.addElement(sl);
        cupSpec.addSymbols(addedSymbols);
        SymbolList tokenList = new SymbolList(0, "Symbol", tokens);
        Vector<SymbolList> addedTokens = new Vector<SymbolList>();
        addedTokens.addElement(tokenList);
        cupSpec.addSymbols(addedTokens);
        Vector rhs = new Vector();
        for (int i = 0; i < this.startSyms.size(); i += 2) {
            Vector<GrammarPart> rhsPart = new Vector<GrammarPart>();
            String startSym = (String)this.startSyms.elementAt(i);
            token = (String)tokens.elementAt(i / 2);
            rhsPart.addElement(new Nonterminal(token, null));
            rhsPart.addElement(new Nonterminal(startSym, "s"));
            rhsPart.addElement(new SemanticAction("RESULT = s;"));
            rhs.addElement(rhsPart);
        }
        Production p = new Production(startNT, rhs);
        cupSpec.addProductions(p);
    }

    public void parseChain(String basePath) {
        File file = null;
        String simpleName = this.include;
        try {
            InputStream is2 = ClassLoader.getSystemResourceAsStream(this.include);
            if (is2 != null) {
                PPG.DEBUG("found " + this.include + " as a resource");
            } else {
                String fullPath = (basePath == "" ? "" : basePath + System.getProperty("file.separator")) + this.include;
                PPG.DEBUG("looking for " + fullPath + " as a file");
                file = new File(fullPath);
                is2 = new FileInputStream(file);
                simpleName = file.getName();
            }
            Lexer lex = new Lexer(is2, simpleName);
            Parser parser2 = new Parser(simpleName, lex);
            PPG.DEBUG("parsing " + simpleName);
            parser2.parse();
            this.parent = (Spec)parser2.getProgramNode();
            is2.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("ppg: " + simpleName + " not found.");
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("ppg: Exception: " + e.getMessage());
            System.exit(1);
        }
        this.parent.setChild(this);
        String parentDir = null;
        if (file != null) {
            parentDir = file.getParent();
        }
        this.parent.parseChain(parentDir == null ? "" : parentDir);
    }

    public CUPSpec coalesce() throws PPGError {
        CUPSpec combined2 = this.parent.coalesce();
        CUPSpec newSpec = (CUPSpec)combined2.clone();
        newSpec.setPkgName(this.packageName);
        newSpec.addImports(this.imports);
        if (this.prec == null) {
            newSpec.prec.removeAllElements();
        } else if (this.prec.size() != 0) {
            newSpec.prec.removeAllElements();
            newSpec.prec.addAll(this.prec);
        }
        newSpec.replaceCode(this.code);
        newSpec.addSymbols(this.symbols);
        if (this.child == null) {
            this.patchMultiStartSymbols(newSpec);
        }
        this.processTransferL(combined2, newSpec);
        this.processDrop(combined2, newSpec);
        this.processOverride(combined2, newSpec);
        this.processTransferR(combined2, newSpec);
        this.processExtend(combined2, newSpec);
        this.processNew(combined2, newSpec);
        newSpec.removeEmptyProductions();
        return newSpec;
    }

    private void processDrop(CUPSpec combined2, CUPSpec newSpec) throws PPGError {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof DropCmd)) continue;
            DropCmd drop2 = (DropCmd)cmd2;
            if (drop2.isProdDrop()) {
                newSpec.dropProductions(drop2.getProduction());
                continue;
            }
            Vector symbols = drop2.getSymbols();
            for (int j = 0; j < symbols.size(); ++j) {
                String sym2 = (String)symbols.elementAt(j);
                newSpec.dropSymbol(sym2);
                newSpec.dropAllProductions(sym2);
            }
        }
    }

    private void processOverride(CUPSpec combined2, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof OverrideCmd)) continue;
            OverrideCmd override = (OverrideCmd)cmd2;
            newSpec.dropProductions(override.getLHS());
            newSpec.addProductions(override.getProduction());
        }
    }

    private void processExtend(CUPSpec combined2, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof ExtendCmd)) continue;
            ExtendCmd extend = (ExtendCmd)cmd2;
            newSpec.addProductions(extend.getProduction());
        }
    }

    private void processTransferL(CUPSpec combined2, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof TransferCmd)) continue;
            TransferCmd transfer = (TransferCmd)cmd2;
            Nonterminal source = transfer.getSource();
            Vector prodList = transfer.getTransferList();
            Production prod = (Production)prodList.elementAt(0);
            prod = (Production)prod.clone();
            for (int j = 1; j < prodList.size(); ++j) {
                Production prodNew = (Production)prodList.elementAt(j);
                prod.union((Production)prodNew.clone());
            }
            prod.setLHS(transfer.getSource());
            newSpec.dropProductions(prod);
        }
    }

    private void processTransferR(CUPSpec combined2, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof TransferCmd)) continue;
            TransferCmd transfer = (TransferCmd)cmd2;
            Vector prodList = transfer.getTransferList();
            for (int j = 0; j < prodList.size(); ++j) {
                Production prod = (Production)prodList.elementAt(j);
                Nonterminal target = prod.getLHS();
                prod.setLHS(transfer.getSource());
                Production prodTransfer = combined2.findProduction(prod);
                prodTransfer.setLHS(target);
                newSpec.addProductions(prodTransfer);
            }
        }
    }

    private void processNew(CUPSpec combined2, CUPSpec newSpec) {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command cmd2 = (Command)this.commands.elementAt(i);
            if (!(cmd2 instanceof NewProdCmd)) continue;
            NewProdCmd newProd = (NewProdCmd)cmd2;
            newSpec.addProductions(newProd.getProduction());
        }
    }

    public void unparse(CodeWriter cw) {
        cw.begin(0);
        if (this.include != null) {
            cw.write(this.include + "\n");
        }
        if (this.commands != null) {
            for (int i = 0; i < this.commands.size(); ++i) {
                ((Command)this.commands.elementAt(i)).unparse(cw);
            }
        }
        cw.end();
    }
}

