/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.Branch;
import polyglot.ast.Labeled;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.SwitchBlock;
import polyglot.ast.Throw;
import polyglot.visit.AlphaRenamer;
import polyglot.visit.NodeVisitor;

public class CodeCleaner
extends NodeVisitor {
    protected NodeFactory nf;
    protected AlphaRenamer alphaRen;

    public CodeCleaner(NodeFactory nf) {
        this.nf = nf;
        this.alphaRen = new AlphaRenamer(nf);
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        if (!(n instanceof Block) && !(n instanceof Labeled)) {
            return n;
        }
        if (n instanceof Labeled) {
            Labeled l = (Labeled)n;
            if (!(l.statement() instanceof Block)) {
                return n;
            }
            Block b = (Block)l.statement();
            if (b.statements().size() != 1) {
                if (this.labelRefs(b).contains(l.label())) {
                    return n;
                }
                return this.nf.Block(b.position(), this.clean(this.flattenBlock(b)));
            }
            b = (Block)b.visit(this.alphaRen);
            return this.nf.Labeled(l.position(), l.label(), (Stmt)b.statements().get(0));
        }
        Block b = (Block)n;
        List stmtList = this.clean(this.flattenBlock(b));
        if (b instanceof SwitchBlock) {
            return this.nf.SwitchBlock(b.position(), stmtList);
        }
        return this.nf.Block(b.position(), stmtList);
    }

    protected List flattenBlock(Block b) {
        LinkedList<Stmt> stmtList = new LinkedList<Stmt>();
        Iterator it = b.statements().iterator();
        while (it.hasNext()) {
            Stmt stmt = (Stmt)it.next();
            if (stmt instanceof Block) {
                stmt = (Stmt)stmt.visit(this.alphaRen);
                stmtList.addAll(((Block)stmt).statements());
                continue;
            }
            stmtList.add(stmt);
        }
        return stmtList;
    }

    protected List clean(List l) {
        LinkedList<Stmt> stmtList = new LinkedList<Stmt>();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Stmt stmt = (Stmt)it.next();
            stmtList.add(stmt);
            if (!(stmt instanceof Branch) && !(stmt instanceof Return) && !(stmt instanceof Throw)) continue;
            return stmtList;
        }
        return l;
    }

    protected Set labelRefs(Block b) {
        final HashSet result2 = new HashSet();
        b.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof Branch) {
                    result2.add(((Branch)n).label());
                }
                return n;
            }
        });
        return result2;
    }
}

