/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class XmlPullParserFactory {
    private static final boolean DEBUG = false;
    public static final String DEFAULT_PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    private static Object MY_REF = new XmlPullParserException();
    private static final String DEFAULT_KXML_IMPL_FACTORY_CLASS_NAME = "org.kxml2.io.XmlReader";
    private static final String DEFAULT_XPP_IMPL_FACTORY_CLASS_NAME = "org.xmlpull.xpp3.factory.Xpp3Factory";
    private static final String DEFAULT_RESOURCE_NAME = "/META-INF/services/org.xmlpull.v1.XmlPullParserFactory";
    private static String foundFactoryClassName = null;
    protected Hashtable features = new Hashtable();
    private static final String PREFIX = "DEBUG XMLPULL factory: ";

    protected XmlPullParserFactory() {
    }

    public static XmlPullParserFactory newInstance() throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(null, null);
    }

    public static XmlPullParserFactory newInstance(String factoryClassName) throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(null, factoryClassName);
    }

    public static XmlPullParserFactory newInstance(Class classLoaderCtx) throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(classLoaderCtx, null);
    }

    private static void debug(String msg) {
        throw new RuntimeException("only when DEBUG enabled can print messages");
    }

    public static XmlPullParserFactory newInstance(Class classLoaderCtx, String factoryClassName) throws XmlPullParserException {
        Class<?> clazz;
        XmlPullParserFactory factoryImpl = null;
        if (factoryClassName != null) {
            try {
                clazz = null;
                clazz = classLoaderCtx != null ? Class.forName(factoryClassName) : Class.forName(factoryClassName);
                factoryImpl = (XmlPullParserFactory)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new XmlPullParserException("could not create instance of XMLPULL factory for class " + factoryClassName + " (root exception:" + ex + ")", ex);
            }
        }
        if (factoryImpl == null) {
            if (foundFactoryClassName == null) {
                XmlPullParserFactory.findFactoryClassName(classLoaderCtx);
            }
            if (foundFactoryClassName != null) {
                try {
                    clazz = null;
                    clazz = classLoaderCtx != null ? Class.forName(foundFactoryClassName) : Class.forName(foundFactoryClassName);
                    factoryImpl = (XmlPullParserFactory)clazz.newInstance();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (factoryImpl == null) {
            try {
                clazz = null;
                factoryClassName = DEFAULT_XPP_IMPL_FACTORY_CLASS_NAME;
                clazz = classLoaderCtx != null ? Class.forName(factoryClassName) : Class.forName(factoryClassName);
                factoryImpl = (XmlPullParserFactory)clazz.newInstance();
                foundFactoryClassName = factoryClassName;
            }
            catch (Exception ex2) {
                try {
                    Class<?> clazz2 = null;
                    factoryClassName = DEFAULT_KXML_IMPL_FACTORY_CLASS_NAME;
                    clazz2 = classLoaderCtx != null ? Class.forName(factoryClassName) : Class.forName(factoryClassName);
                    factoryImpl = (XmlPullParserFactory)clazz2.newInstance();
                    foundFactoryClassName = factoryClassName;
                }
                catch (Exception ex3) {
                    throw new XmlPullParserException("could not load any factory class (even small or full default implementation)", ex3);
                }
            }
        }
        if (factoryImpl == null) {
            throw new RuntimeException("XMLPULL: internal parser factory error");
        }
        return factoryImpl;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void findFactoryClassName(Class classLoaderCtx) {
        InputStream is2;
        block11: {
            if (foundFactoryClassName != null) {
                throw new RuntimeException("internal XMLPULL initialization error");
            }
            is2 = null;
            if (classLoaderCtx != null) {
                is2 = classLoaderCtx.getResourceAsStream(DEFAULT_RESOURCE_NAME);
            }
            if (is2 == null) {
                Class<?> klass = MY_REF.getClass();
                is2 = klass.getResourceAsStream(DEFAULT_RESOURCE_NAME);
            }
            if (is2 == null) break block11;
            foundFactoryClassName = XmlPullParserFactory.readLine(is2);
        }
        Object var4_4 = null;
        if (is2 == null) return;
        try {
            is2.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                Object var4_5 = null;
                if (is2 == null) return;
                try {
                    is2.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (is2 == null) throw throwable;
            try {
                is2.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static String readLine(InputStream input2) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        while ((ch = input2.read()) >= 0 && ch != 10) {
            sb.append((char)ch);
        }
        int n = sb.length();
        if (n > 0 && sb.charAt(n - 1) == '\r') {
            sb.setLength(n - 1);
        }
        return sb.toString();
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        this.features.put(name, new Boolean(state));
    }

    public boolean getFeature(String name) {
        Boolean value2 = (Boolean)this.features.get(name);
        return value2 != null ? value2 : false;
    }

    public void setNamespaceAware(boolean awareness) throws XmlPullParserException {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", new Boolean(awareness));
    }

    public boolean isNamespaceAware() {
        Boolean value2 = (Boolean)this.features.get("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        return value2 != null ? value2 : false;
    }

    public void setValidating(boolean validating) throws XmlPullParserException {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", new Boolean(validating));
    }

    public boolean isValidating() {
        Boolean value2 = (Boolean)this.features.get("http://xmlpull.org/v1/doc/features.html#validation");
        return value2 != null ? value2 : false;
    }

    public abstract XmlPullParser newPullParser() throws XmlPullParserException;
}

