/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckMethodAdapter;

public class CheckAnnotationAdapter
extends AnnotationVisitor {
    private final boolean named;
    private boolean end;

    public CheckAnnotationAdapter(AnnotationVisitor av) {
        this(av, true);
    }

    CheckAnnotationAdapter(AnnotationVisitor av, boolean named) {
        super(327680, av);
        this.named = named;
    }

    public void visit(String name, Object value2) {
        int sort2;
        this.checkEnd();
        this.checkName(name);
        if (!(value2 instanceof Byte || value2 instanceof Boolean || value2 instanceof Character || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long || value2 instanceof Float || value2 instanceof Double || value2 instanceof String || value2 instanceof Type || value2 instanceof byte[] || value2 instanceof boolean[] || value2 instanceof char[] || value2 instanceof short[] || value2 instanceof int[] || value2 instanceof long[] || value2 instanceof float[] || value2 instanceof double[])) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (value2 instanceof Type && (sort2 = ((Type)value2).getSort()) == 11) {
            throw new IllegalArgumentException("Invalid annotation value");
        }
        if (this.av != null) {
            this.av.visit(name, value2);
        }
    }

    public void visitEnum(String name, String desc, String value2) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        if (value2 == null) {
            throw new IllegalArgumentException("Invalid enum value");
        }
        if (this.av != null) {
            this.av.visitEnum(name, desc, value2);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.checkEnd();
        this.checkName(name);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitAnnotation(name, desc));
    }

    public AnnotationVisitor visitArray(String name) {
        this.checkEnd();
        this.checkName(name);
        return new CheckAnnotationAdapter(this.av == null ? null : this.av.visitArray(name), false);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private void checkName(String name) {
        if (this.named && name == null) {
            throw new IllegalArgumentException("Annotation value name must not be null");
        }
    }
}

