/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.internal.JCastExpr;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class LocalMayAliasAnalysisWithArray
extends ForwardFlowAnalysis<Unit, Set<Set<Value>>> {
    private Body body;

    public LocalMayAliasAnalysisWithArray(UnitGraph graph) {
        super(graph);
        this.body = graph.getBody();
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(Set<Set<Value>> source, Unit unit, Set<Set<Value>> target) {
        target.addAll(source);
        if (unit instanceof DefinitionStmt) {
            DefinitionStmt def = (DefinitionStmt)unit;
            Value left = def.getLeftOp();
            Value right = def.getRightOp();
            if (right instanceof Constant) {
                Set<Value> leftSet = null;
                for (Set<Value> s2 : source) {
                    if (!s2.contains(left)) continue;
                    leftSet = s2;
                    break;
                }
                if (leftSet == null) {
                    throw new RuntimeException("internal error");
                }
                target.remove(leftSet);
                HashSet<Value> setWithoutLeft = new HashSet<Value>(leftSet);
                setWithoutLeft.remove(left);
                target.add(setWithoutLeft);
                target.add(Collections.singleton(left));
            } else {
                InstanceInvokeExpr iexpr;
                Value value2;
                Set<Value> leftSet = null;
                Set<Value> rightSet = null;
                Set<Value> castSet = null;
                Set<Value> arraySet = null;
                Set<Value> invokeSet = null;
                for (Set<Value> s3 : source) {
                    if (!s3.contains(left)) continue;
                    leftSet = s3;
                    break;
                }
                for (Set<Value> s3 : source) {
                    if (!s3.contains(right)) continue;
                    rightSet = s3;
                    break;
                }
                if (right instanceof JCastExpr) {
                    JCastExpr expr = (JCastExpr)right;
                    value2 = expr.getOp();
                    for (Set<Value> s4 : source) {
                        if (!s4.contains(value2)) continue;
                        castSet = s4;
                        break;
                    }
                }
                if (right instanceof ArrayRef) {
                    ArrayRef ref = (ArrayRef)right;
                    value2 = ref.getBase();
                    for (Set<Value> s4 : source) {
                        if (!s4.contains(value2)) continue;
                        arraySet = s4;
                        break;
                    }
                }
                if (right instanceof InstanceInvokeExpr && (iexpr = (InstanceInvokeExpr)right).getMethod().getName().equals("get")) {
                    value2 = iexpr.getBase();
                    for (Set<Value> s4 : source) {
                        if (!s4.contains(value2)) continue;
                        invokeSet = s4;
                        break;
                    }
                }
                if (leftSet == null || rightSet == null) {
                    throw new RuntimeException("internal error");
                }
                target.remove(leftSet);
                target.remove(rightSet);
                if (castSet != null) {
                    target.remove(castSet);
                }
                if (arraySet != null) {
                    target.remove(arraySet);
                }
                if (invokeSet != null) {
                    target.remove(invokeSet);
                }
                HashSet<Value> union2 = new HashSet<Value>(leftSet);
                union2.addAll(rightSet);
                if (castSet != null) {
                    union2.addAll(castSet);
                }
                if (arraySet != null) {
                    union2.addAll(arraySet);
                }
                if (invokeSet != null) {
                    union2.addAll(invokeSet);
                }
                target.add(union2);
            }
        }
    }

    @Override
    protected void copy(Set<Set<Value>> source, Set<Set<Value>> target) {
        target.clear();
        target.addAll(source);
    }

    @Override
    protected Set<Set<Value>> entryInitialFlow() {
        HashSet<Set<Value>> res = new HashSet<Set<Value>>();
        for (ValueBox vb : this.body.getUseAndDefBoxes()) {
            res.add(Collections.singleton(vb.getValue()));
        }
        return res;
    }

    @Override
    protected void merge(Set<Set<Value>> source1, Set<Set<Value>> source2, Set<Set<Value>> target) {
        target.clear();
        target.addAll(source1);
        target.addAll(source2);
    }

    @Override
    protected Set<Set<Value>> newInitialFlow() {
        return new HashSet<Set<Value>>();
    }

    public boolean mayAlias(Value v1, Value v2, Unit u) {
        Set res = (Set)this.getFlowBefore(u);
        for (Set set2 : res) {
            if (!set2.contains(v1) || !set2.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public Set<Value> mayAliases(Value v, Unit u) {
        HashSet<Value> res = new HashSet<Value>();
        Set flow = (Set)this.getFlowBefore(u);
        for (Set set2 : flow) {
            if (!set2.contains(v)) continue;
            res.addAll(set2);
        }
        return res;
    }

    public Set<Value> mayAliasesAtExit(Value v) {
        HashSet<Value> res = new HashSet<Value>();
        for (Unit u : this.graph.getTails()) {
            Set flow = (Set)this.getFlowAfter(u);
            for (Set set2 : flow) {
                if (!set2.contains(v)) continue;
                res.addAll(set2);
            }
        }
        return res;
    }
}

