/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import com.bpodgursky.jbool_expressions.rules.RuleSet;
import java.util.Iterator;
import java.util.List;
import org.k33nteam.jade.solver.ConstrainInfo;
import org.k33nteam.jade.solver.ForwardMyBranchedFlowAnalysis;
import soot.Unit;
import soot.jimple.IfStmt;
import soot.toolkits.graph.UnitGraph;

public class LocalConstraintFlowAnalysis
extends ForwardMyBranchedFlowAnalysis<ConstrainInfo> {
    boolean shouldPrecise = false;

    public boolean isShouldPrecise() {
        return this.shouldPrecise;
    }

    public LocalConstraintFlowAnalysis(UnitGraph graph, boolean precise) {
        super(graph);
        this.doAnalysis();
        this.shouldPrecise = precise;
    }

    @Override
    protected void flowThrough(ConstrainInfo in, Unit s2, List<ConstrainInfo> fallOut, List<ConstrainInfo> branchOuts) {
        ConstrainInfo out = new ConstrainInfo(in);
        ConstrainInfo outBranch = new ConstrainInfo(in);
        if (s2 instanceof IfStmt) {
            IfStmt stmt = (IfStmt)s2;
            out.intersect(stmt, false);
            outBranch.intersect(stmt, true);
        }
        Iterator<ConstrainInfo> it = fallOut.iterator();
        while (it.hasNext()) {
            this.copy(out, it.next());
        }
        it = branchOuts.iterator();
        while (it.hasNext()) {
            this.copy(outBranch, it.next());
        }
    }

    @Override
    protected void merge(ConstrainInfo in1, ConstrainInfo in2, ConstrainInfo out) {
        out.union(in1);
        out.union(in2);
    }

    @Override
    protected void copy(ConstrainInfo source, ConstrainInfo dest) {
        dest.copy(source);
    }

    @Override
    protected ConstrainInfo newInitialFlow() {
        return new ConstrainInfo();
    }

    @Override
    protected ConstrainInfo entryInitialFlow() {
        return new ConstrainInfo(true);
    }

    public String flowResult(Unit unit) {
        ConstrainInfo flowresult = (ConstrainInfo)this.getFlowBefore(unit);
        if (flowresult.expression != null) {
            return RuleSet.simplify(flowresult.expression).toString();
        }
        return "<<null>>";
    }
}

