/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import java.util.HashMap;
import java.util.Map;
import org.k33nteam.jade.solver.DataObject;
import org.k33nteam.jade.solver.model.IntentSource;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.toolkits.scalar.Pair;

class IntentTaintFact {
    Map<Value, Pair<IntentSource, DataObject>> facts = new HashMap<Value, Pair<IntentSource, DataObject>>();
    static Map<SootMethod, IntentSource> sources = new HashMap<SootMethod, IntentSource>();
    static Map<Integer, IntentSource> params = new HashMap<Integer, IntentSource>();
    static Map<SootField, IntentSource> fields = new HashMap<SootField, IntentSource>();
    static IntentSource FROM_GET_INTENT = new IntentSource();

    IntentTaintFact() {
    }

    public static void reset() {
        sources.clear();
        params.clear();
        fields.clear();
    }

    public void killValue(Value Value2) {
        this.facts.remove(Value2);
    }

    public void copyValue(Value dest, Value src) {
        if (this.facts.containsKey(src)) {
            this.facts.put(dest, this.facts.get(src));
        } else {
            this.killValue(dest);
        }
    }

    public void copy(IntentTaintFact fact) {
        this.facts.clear();
        this.merge(fact);
    }

    public void merge(IntentTaintFact fact) {
        this.facts.putAll(fact.facts);
    }

    public IntentSource getGetIntent() {
        return FROM_GET_INTENT;
    }

    public void putPair(Value Value2, Pair<IntentSource, DataObject> pair) {
        this.facts.put(Value2, pair);
    }

    public IntentSource getIntentSourceFromMethod(SootMethod method) {
        if (sources.containsKey(method)) {
            return sources.get(method);
        }
        sources.put(method, new IntentSource());
        return sources.get(method);
    }

    public IntentSource getIntentSourceFromParam(Integer integer) {
        if (params.containsKey(integer)) {
            return params.get(integer);
        }
        params.put(integer, new IntentSource());
        return params.get(integer);
    }

    public IntentSource getIntentSourceFromField(SootField field2) {
        if (fields.containsKey(field2)) {
            return fields.get(field2);
        }
        fields.put(field2, new IntentSource());
        return fields.get(field2);
    }

    public Pair<IntentSource, DataObject> getPairFromValue(Value value2) {
        return this.facts.get(value2);
    }

    public static DataObject getRecurTail(DataObject object) {
        while (!object.clear) {
            object = object.data;
        }
        return object;
    }

    public void clear() {
        this.facts.clear();
    }

    public String toString() {
        return "[ " + this.facts.toString() + ", " + sources.toString() + " ]";
    }

    public boolean equals(Object obj) {
        return obj instanceof IntentTaintFact && this.facts.equals(((IntentTaintFact)obj).facts);
    }
}

