/*
 * Decompiled with CFR 0.152.
 */
package org.k33nteam.jade.solver;

import java.util.HashSet;
import java.util.List;
import org.k33nteam.jade.solver.DataObject;
import org.k33nteam.jade.solver.IntentTaintFact;
import org.k33nteam.jade.solver.model.IntentSource;
import soot.Body;
import soot.EquivalentValue;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.Unit;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JCastExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.Pair;

class ForwardIntentTaintAnalysis
extends ForwardFlowAnalysis<Unit, IntentTaintFact> {
    private Body body;

    public ForwardIntentTaintAnalysis(DirectedGraph<Unit> graph, Body body) {
        super(graph);
        this.body = body;
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(IntentTaintFact in, Unit d, IntentTaintFact out) {
        Stmt stmt = (Stmt)d;
        out.copy(in);
        if (stmt instanceof JAssignStmt) {
            JAssignStmt assignStmt = (JAssignStmt)stmt;
            Value right = assignStmt.getRightOp();
            Value left = assignStmt.getLeftOp();
            if (right instanceof InvokeExpr) {
                InvokeExpr expr = (InvokeExpr)right;
                if (expr.getMethod().getReturnType().toString().equals("android.content.Intent")) {
                    IntentSource source = in.getIntentSourceFromMethod(expr.getMethod());
                    DataObject object = DataObject.newInstance();
                    object.setStatus(2);
                    Pair<IntentSource, DataObject> pair = new Pair<IntentSource, DataObject>(source, object);
                    out.putPair(ForwardIntentTaintAnalysis.getFieldRefWrap(left), pair);
                } else if (expr instanceof InstanceInvokeExpr && (((InstanceInvokeExpr)expr).getBase().getType().toString().equals("android.content.Intent") || ((InstanceInvokeExpr)expr).getBase().getType().toString().equals("android.os.Bundle") || ((InstanceInvokeExpr)expr).getBase().getType().toString().equals("android.net.Uri"))) {
                    InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)expr;
                    if (instanceInvokeExpr.getArgCount() <= 1) {
                        Pair<IntentSource, DataObject> pair = in.getPairFromValue(instanceInvokeExpr.getBase());
                        if (pair != null) {
                            Value value2;
                            IntentSource source = pair.getO1();
                            DataObject root = in.getPairFromValue(instanceInvokeExpr.getBase()).getO2();
                            root = root.clone();
                            DataObject object = IntentTaintFact.getRecurTail(root);
                            object.setKeyAndData(expr.getMethod().getName(), DataObject.newInstance());
                            if (instanceInvokeExpr.getArgCount() == 1 && (value2 = instanceInvokeExpr.getArg(0)) instanceof StringConstant) {
                                object.getData().setKeyAndData(((StringConstant)value2).value, DataObject.newInstance());
                            }
                            pair = new Pair<IntentSource, DataObject>(source, root);
                            out.putPair(ForwardIntentTaintAnalysis.getFieldRefWrap(left), pair);
                        } else {
                            System.err.println("intent source not found. skip");
                            System.err.println("method: " + this.body.getMethod());
                        }
                    }
                } else if ((expr.getMethod().getName().equals("isEmpty") || expr.getMethod().getName().equals("isNullOrNil") || expr.getMethod().getName().equals("iM") || expr.getMethod().getName().equals("lm")) && expr.getMethod().getParameterCount() == 1) {
                    Value value3 = expr.getArg(0);
                    if (in.getPairFromValue(value3) != null) {
                        IntentSource source = in.getPairFromValue(value3).getO1();
                        DataObject root = in.getPairFromValue(value3).getO2();
                        root = root.clone();
                        DataObject object = IntentTaintFact.getRecurTail(root);
                        object.setKeyAndData(expr.getMethod().toString(), DataObject.newInstance());
                        out.putPair(ForwardIntentTaintAnalysis.getFieldRefWrap(left), new Pair<IntentSource, DataObject>(source, root));
                    }
                } else {
                    out.killValue(ForwardIntentTaintAnalysis.getFieldRefWrap(left));
                }
            } else if (right instanceof JCastExpr) {
                right = ((JCastExpr)right).getOp();
                out.copyValue(ForwardIntentTaintAnalysis.getFieldRefWrap(left), ForwardIntentTaintAnalysis.getFieldRefWrap(right));
            } else if (right instanceof Constant) {
                out.killValue(ForwardIntentTaintAnalysis.getFieldRefWrap(left));
            } else {
                out.copyValue(ForwardIntentTaintAnalysis.getFieldRefWrap(left), ForwardIntentTaintAnalysis.getFieldRefWrap(right));
            }
        }
    }

    @Override
    protected IntentTaintFact newInitialFlow() {
        return new IntentTaintFact();
    }

    @Override
    protected IntentTaintFact entryInitialFlow() {
        IntentTaintFact fact = new IntentTaintFact();
        List<Local> params = this.body.getParameterLocals();
        int cnt = 0;
        for (Value value2 : params) {
            if (value2 == null || !value2.getType().toString().equals("android.content.Intent")) continue;
            IntentSource source = fact.getIntentSourceFromParam(cnt);
            DataObject object = DataObject.newInstance();
            object.setStatus(2);
            Pair<IntentSource, DataObject> pair = new Pair<IntentSource, DataObject>(source, object);
            fact.putPair(value2, pair);
            ++cnt;
        }
        HashSet<SootField> travelled = new HashSet<SootField>();
        for (Unit unit : this.body.getUnits()) {
            RefType refType;
            FieldRef fieldRef;
            SootField sootField;
            Stmt stmt = (Stmt)unit;
            if (!stmt.containsFieldRef() || travelled.contains(sootField = (fieldRef = stmt.getFieldRef()).getField()) || !(fieldRef.getField().getType() instanceof RefType) || !(refType = (RefType)fieldRef.getField().getType()).getSootClass().getName().equals("android.content.Intent")) continue;
            IntentSource source = fact.getIntentSourceFromField(sootField);
            DataObject object = DataObject.newInstance();
            object.setStatus(2);
            Pair<IntentSource, DataObject> pair = new Pair<IntentSource, DataObject>(source, object);
            fact.putPair(ForwardIntentTaintAnalysis.getFieldRefWrap(fieldRef), pair);
            ++cnt;
            travelled.add(sootField);
        }
        return fact;
    }

    @Override
    protected void merge(IntentTaintFact in1, IntentTaintFact in2, IntentTaintFact out) {
        out.clear();
        out.merge(in1);
        out.merge(in2);
    }

    @Override
    protected void copy(IntentTaintFact source, IntentTaintFact dest) {
        dest.copy(source);
    }

    private static Value getFieldRefWrap(Value value2) {
        if (value2 instanceof FieldRef) {
            return new EquivalentValue(value2);
        }
        return value2;
    }
}

