/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringWrapper {
    public static String[] wrapString(@Nonnull String str, int maxWidth, @Nullable String[] output) {
        int i;
        if (output == null) {
            output = new String[(int)((double)(str.length() / maxWidth) * 1.5 + 1.0)];
        }
        int lineStart = 0;
        int arrayIndex = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                output = StringWrapper.addString(output, str.substring(lineStart, i), arrayIndex++);
                lineStart = i + 1;
                continue;
            }
            if (i - lineStart != maxWidth) continue;
            output = StringWrapper.addString(output, str.substring(lineStart, i), arrayIndex++);
            lineStart = i;
        }
        if (lineStart != i || i == 0) {
            output = StringWrapper.addString(output, str.substring(lineStart), arrayIndex++, output.length + 1);
        }
        if (arrayIndex < output.length) {
            output[arrayIndex] = null;
        }
        return output;
    }

    private static String[] addString(@Nonnull String[] arr, String str, int index) {
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, (int)Math.ceil((double)(arr.length + 1) * 1.5));
        }
        arr[index] = str;
        return arr;
    }

    private static String[] addString(@Nonnull String[] arr, String str, int index, int newLength) {
        if (index >= arr.length) {
            arr = StringWrapper.enlargeArray(arr, newLength);
        }
        arr[index] = str;
        return arr;
    }

    private static String[] enlargeArray(String[] arr, int newLength) {
        String[] newArr = new String[newLength];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }
}

