/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.ArraySortedSet;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(@Nonnull Item var1);

    @Nonnull
    protected abstract ImmutableItem makeImmutable(@Nonnull Item var1);

    @Nonnull
    public ImmutableList<ImmutableItem> toList(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableList.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableList) {
            for (Item element2 : iterable) {
                if (this.isImmutable(element2)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableList)iterable;
        }
        final Iterator<? extends Item> iter2 = iterable.iterator();
        return ImmutableList.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter2.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter2.next());
            }

            @Override
            public void remove() {
                iter2.remove();
            }
        });
    }

    @Nonnull
    public ImmutableSet<ImmutableItem> toSet(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSet) {
            for (Item element2 : iterable) {
                if (this.isImmutable(element2)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSet)iterable;
        }
        final Iterator<? extends Item> iter2 = iterable.iterator();
        return ImmutableSet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter2.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter2.next());
            }

            @Override
            public void remove() {
                iter2.remove();
            }
        });
    }

    @Nonnull
    public ImmutableSortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            return ImmutableSortedSet.of();
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSortedSet && ((ImmutableSortedSet)iterable).comparator().equals(comparator)) {
            for (Item element2 : iterable) {
                if (this.isImmutable(element2)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            return (ImmutableSortedSet)iterable;
        }
        final Iterator<? extends Item> iter2 = iterable.iterator();
        return ImmutableSortedSet.copyOf(comparator, new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter2.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter2.next());
            }

            @Override
            public void remove() {
                iter2.remove();
            }
        });
    }

    @Nonnull
    public SortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable SortedSet<? extends Item> sortedSet) {
        if (sortedSet == null || sortedSet.size() == 0) {
            return ImmutableSortedSet.of();
        }
        Object[] newItems = new Object[sortedSet.size()];
        int index = 0;
        for (Object item : sortedSet) {
            newItems[index++] = this.makeImmutable(item);
        }
        return ArraySortedSet.of(comparator, newItems);
    }
}

