/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

public final class Hex {
    private Hex() {
    }

    public static String u8(long v) {
        char[] result2 = new char[16];
        for (int i = 0; i < 16; ++i) {
            result2[15 - i] = Character.forDigit((int)v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String u4(int v) {
        char[] result2 = new char[8];
        for (int i = 0; i < 8; ++i) {
            result2[7 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String u3(int v) {
        char[] result2 = new char[6];
        for (int i = 0; i < 6; ++i) {
            result2[5 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String u2(int v) {
        char[] result2 = new char[4];
        for (int i = 0; i < 4; ++i) {
            result2[3 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String u2or4(int v) {
        if (v == (char)v) {
            return Hex.u2(v);
        }
        return Hex.u4(v);
    }

    public static String u1(int v) {
        char[] result2 = new char[2];
        for (int i = 0; i < 2; ++i) {
            result2[1 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String uNibble(int v) {
        char[] result2 = new char[]{Character.forDigit(v & 0xF, 16)};
        return new String(result2);
    }

    public static String s8(long v) {
        char[] result2 = new char[17];
        if (v < 0L) {
            result2[0] = 45;
            v = -v;
        } else {
            result2[0] = 43;
        }
        for (int i = 0; i < 16; ++i) {
            result2[16 - i] = Character.forDigit((int)v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String s4(int v) {
        char[] result2 = new char[9];
        if (v < 0) {
            result2[0] = 45;
            v = -v;
        } else {
            result2[0] = 43;
        }
        for (int i = 0; i < 8; ++i) {
            result2[8 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String s2(int v) {
        char[] result2 = new char[5];
        if (v < 0) {
            result2[0] = 45;
            v = -v;
        } else {
            result2[0] = 43;
        }
        for (int i = 0; i < 4; ++i) {
            result2[4 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String s1(int v) {
        char[] result2 = new char[3];
        if (v < 0) {
            result2[0] = 45;
            v = -v;
        } else {
            result2[0] = 43;
        }
        for (int i = 0; i < 2; ++i) {
            result2[2 - i] = Character.forDigit(v & 0xF, 16);
            v >>= 4;
        }
        return new String(result2);
    }

    public static String dump(byte[] arr, int offset, int length2, int outOffset, int bpl, int addressLength) {
        int end = offset + length2;
        if ((offset | length2 | end) < 0 || end > arr.length) {
            throw new IndexOutOfBoundsException("arr.length " + arr.length + "; " + offset + "..!" + end);
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("outOffset < 0");
        }
        if (length2 == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(length2 * 4 + 6);
        boolean bol = true;
        int col = 0;
        while (length2 > 0) {
            if (col == 0) {
                String astr;
                switch (addressLength) {
                    case 2: {
                        astr = Hex.u1(outOffset);
                        break;
                    }
                    case 4: {
                        astr = Hex.u2(outOffset);
                        break;
                    }
                    case 6: {
                        astr = Hex.u3(outOffset);
                        break;
                    }
                    default: {
                        astr = Hex.u4(outOffset);
                    }
                }
                sb.append(astr);
                sb.append(": ");
            } else if (!(col & true)) {
                sb.append(' ');
            }
            sb.append(Hex.u1(arr[offset]));
            ++outOffset;
            ++offset;
            if (++col == bpl) {
                sb.append('\n');
                col = 0;
            }
            --length2;
        }
        if (col != 0) {
            sb.append('\n');
        }
        return sb.toString();
    }
}

