/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderStringReference;

class BuilderStringPool
implements StringSection<BuilderStringReference, BuilderStringReference> {
    @Nonnull
    private final ConcurrentMap<String, BuilderStringReference> internedItems = Maps.newConcurrentMap();

    BuilderStringPool() {
    }

    @Nonnull
    BuilderStringReference internString(@Nonnull String string2) {
        BuilderStringReference ret = (BuilderStringReference)this.internedItems.get(string2);
        if (ret != null) {
            return ret;
        }
        BuilderStringReference stringReference = new BuilderStringReference(string2);
        ret = this.internedItems.putIfAbsent(string2, stringReference);
        return ret == null ? stringReference : ret;
    }

    @Nullable
    BuilderStringReference internNullableString(@Nullable String string2) {
        if (string2 == null) {
            return null;
        }
        return this.internString(string2);
    }

    @Override
    public int getNullableItemIndex(@Nullable BuilderStringReference key2) {
        return key2 == null ? -1 : key2.index;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderStringReference key2) {
        return key2.index;
    }

    @Override
    public boolean hasJumboIndexes() {
        return this.internedItems.size() > 65536;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderStringReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderStringReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderStringReference key2) {
                return key2.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderStringReference key2, int value2) {
                int prev = key2.index;
                key2.index = value2;
                return prev;
            }
        };
    }
}

