/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.rewriter.Rewriter;

public class RewriterUtils {
    @Nullable
    public static <T> T rewriteNullable(@Nonnull Rewriter<T> rewriter, @Nullable T value2) {
        return value2 == null ? null : (T)rewriter.rewrite(value2);
    }

    public static <T> Set<T> rewriteSet(final @Nonnull Rewriter<T> rewriter, final @Nonnull Set<? extends T> set2) {
        return new AbstractSet<T>(){

            @Override
            @Nonnull
            public Iterator<T> iterator() {
                final Iterator iterator2 = set2.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator2.next());
                    }

                    @Override
                    public void remove() {
                        iterator2.remove();
                    }
                };
            }

            @Override
            public int size() {
                return set2.size();
            }
        };
    }

    public static <T> List<T> rewriteList(final @Nonnull Rewriter<T> rewriter, final @Nonnull List<? extends T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int i) {
                return RewriterUtils.rewriteNullable(rewriter, list.get(i));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> Iterable<T> rewriteIterable(final @Nonnull Rewriter<T> rewriter, final @Nonnull Iterable<? extends T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator2 = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator2.hasNext();
                    }

                    @Override
                    public T next() {
                        return RewriterUtils.rewriteNullable(rewriter, iterator2.next());
                    }

                    @Override
                    public void remove() {
                        iterator2.remove();
                    }
                };
            }
        };
    }

    public static TypeReference rewriteTypeReference(final @Nonnull Rewriter<String> typeRewriter, final @Nonnull TypeReference typeReference) {
        return new BaseTypeReference(){

            @Override
            @Nonnull
            public String getType() {
                return typeRewriter.rewrite(typeReference.getType());
            }
        };
    }
}

